/**
  Objecto JavaScript
*/

var formItem = Class.create();
formItem.prototype = {
	Version: '1.1.0_wtyp',
  initialize: function(id) {
		
    if(!$(id)){
      alert("El elemento con el "+ id +" no existe.");
      return {};
    }
    
	  this.options = Object.extend({
	    objInstance    : '',  //nombre de la variable donde se instancia la clase -- necesario
	    data           : [],  //tipo de elemento o texto en la celda
	    attribute      : [],  //atributos de los elementos inputs
	    alignTd        : [],  //alineacion por celda
	    varOutput      : [],  //aqui se guardan los nombres de la variables q van a devolver
	    highlightcolor : "#B3CFF2",
	    defaultColor   : "#FFFFFF",
	    rowValidate    : []  //valida las columnas
		}, arguments[1] || {});
		
		if(this.options.objInstance == ''){
		  alert("Debe de colocar como segundo parametro el atributo 'objInstance'.");
		  return {};
		}
		
		this.tableId      = id; //en si es el TBODY
		this.elmDeleteTr  = [];
		this.elements     = [];
		this.processSave  = false;
    
	},
	
	getElm : function(){ return $(this.tableId); },  //retorna el elmento padre
	
	getRowHead : function(){ return this.getElm().rows[0]; },  //devuelve la cabecera del elemento padre
	
	getCountCells : function(){ return this.getRowHead().cells.length; },  //devuelve el numero de cantidad de celdas
	
	getCountRows : function(){ return this.getElm().rows.length; },  //devuelve el numero d cantidad filas actuales
	
	clearValuesByRow : function(elm){  //borra el contenido de toda la fila celda por celda
	  if(elm.tagName == "INPUT"){ var elmRowUse = elm.parentNode.parentNode.cells; }
	  if(elm.tagName == "TD"){ var elmRowUse = elm.parentNode.cells; }	    
	  for (i=0; i<elmRowUse.length; i++) {
	    if(elmRowUse[i].firstChild){
  	    if(elmRowUse[i].firstChild.tagName == "INPUT"){
  	      if(arguments[1]){  //si el segundo parametro es true
  	       if(!(elm === elmRowUse[i].firstChild)){  //aqui pregunto q sea diferente a el elemento ingresado por parametro
  	         if(arguments[2]){
  	           if(arguments[2].indexOf(i)<0){
  	             elmRowUse[i].firstChild.value = "0";
  	           }
  	         }else{
  	           elmRowUse[i].firstChild.value = "0";
  	         }
  	       }
  	      }else{
  	        elmRowUse[i].firstChild.value = "";
  	      }
  	    }else{
  	      if(arguments[2]){
  	        if(arguments[2].indexOf(i)<0){
              elmRowUse[i].innerHTML = "&nbsp;";
  	        }
  	      }else{
  	        elmRowUse[i].innerHTML = "&nbsp;";
  	      }
  	    }
	    }
	  }
	},
	
	getPosition : function(elm){  //retorna la posicion de la celda y registro
	  
	  if(elm){
	    
  	  switch (elm.tagName){
  	    case 'INPUT': 
  	      var cellPos = elm.parentNode.cellIndex;
  	      var rowPos  = elm.parentNode.parentNode.rowIndex;
  	    break;
  	    case 'TD': 
  	      var cellPos = elm.cellIndex;
  	      var rowPos  = elm.parentNode.rowIndex;
  	    break;
  	  }
      
  	  return {cellPos:cellPos, rowPos:rowPos};
  	  
	  }
	  
	  return null;
	  
	},
	
	getElmsByColumn : function(col, tagName){  //retorna en un array todos los elementos de una columna
	  
	  if(typeof(tagName) == 'undefined' || tagName == "" ){
	    tagName = "TD";
	  }
	  
	  var code = this.options.varOutput[col];
	  var tableId = this.tableId;
	  var elements = $(tableId).getElementsBySelector(tagName+'[code="'+code+'"]');
	  
    if(elements.length > 0){
      return elements;
    }else{
      return [];
    }
	  
	},
	
	setReadOnlyByColumn : function(col, typeBoolean){  //coloca en readOnly todos los inputs de una Columna
	  
	  var tagName = arguments[2] ? arguments[2] : "TD";
	  code = this.options.varOutput[col];
	  var tableId = this.tableId;
	  var elements = $(tableId).getElementsBySelector(tagName+'[code="'+code+'"]');
	  
    if(elements.length > 0){
      for(i=0; i<(elements.length); i++){
        if(typeBoolean){
          if(!elements[i].hasClassName('text0')){
            elements[i].addClassName('text0');
          }
        }else{
          if(elements[i].hasClassName('text0')){
            elements[i].removeClassName('text0');
          }
        }
        elements[i].readOnly = typeBoolean;          
        
      }
    }
	  
	},
	
	validateByColumn : function(col, elm){  //verifica q no se repita la columna respectiva por el parametro
	  var tagName = arguments[2] ? arguments[2] : "TD";
	  if(this.options.rowValidate.indexOf(col) > -1){
	    var blCtrl = false;
	    var valueName    = this.options.varOutput[col];
	    var tableId = this.tableId;
	    var elements = $(tableId).getElementsBySelector(tagName+'[code="'+valueName+'"]');
	    if(elements.length > 0){
	      for(i=0; i<(elements.length); i++){
	        if(!(elements[i] === elm)){
	          if(elements[i].value == elm.value){
	            blCtrl = true;
	            break;
	          }
	        }
	      }
	    }
	  }
	  return blCtrl;
	},
	
	validateRows : function(){ //valida las filas de las columnas segun los parametros de this.options.rowValidate
	  tabla        = this.getElm();
	  var rows     = this.getCountRows();
	  result = 0;
	  if(rows == 1){ return true; }
	  for (j=1; j<rows; j++){	  
  	  var rowValidate  = j; //(rows-1);
  	  concatIdRow = tabla.rows[rowValidate].id;
  	  if(this.options.rowValidate.length > 0){
        for (i=0; i<this.options.rowValidate.length; i++){
          if($(concatIdRow + "_td_" + this.options.rowValidate[i])){
            elmSelected = $(concatIdRow + "_td_" + this.options.rowValidate[i]);
            if(elmSelected.firstChild.nodeType == 1){//son elementos
              if(elmSelected.firstChild.tagName == "IMG"){
                return false;
              }else{
                if(elmSelected.firstChild.tagName == "INPUT"){
                  if(elmSelected.firstChild.value!="" && elmSelected.firstChild.value!="0"){
                    result++;
                  }else{
                    return false;
                  }
                }
              }
            }else{
              if(elmSelected.firstChild.nodeType == 3){ //son textos
                if(elmSelected.innerHTML == "&nbsp;"){
                  return false;
                }else{
                  result++;
                }
              }
            }
          }else{
            return true;
          }
        }
  	  }
	  }
	  if(result == (this.options.rowValidate.length*(rows-1))) return true; else return false;
	},
	
	toQueryString : function(){ //devuelven todo el formulario como cadena lista para enviar por la URL
	  var varOutput = this.options.varOutput;
	  var tableId = this.tableId;
	  var string = [];
	  varOutput.each(function(value, i) {
	    if(value){	      
        elements = $(tableId).getElementsBySelector('[code="'+value+'"]');
        elements.each(function(value2, i2) {
          string.push(value+"="+value2.value);
        });
	    }
	  });
	  return (string.join("&"));
	},
	
	countRows : function(){
	  
    var tableId = this.tableId;
    elements = $(tableId).getElementsBySelector('[code="count"]');
    elements.each(function(value, i) {
      value.innerHTML = (i+1);
    });
	  
	},
	
	insert : function(){ //inserta una fila
	  tabla        = this.getElm();
	  var cells    = this.getCountCells();
	  var rows     = this.getCountRows();
	  nameInstance = this.options.objInstance;
    trId = this.tableId + "_tr_" + rows;
    if($(trId)){
      while($(trId)) { //si el id del elemento realizo un bucle buscando el id q no existe
        rows++;
        trId = this.tableId + "_tr_" + rows;
      }
    }
    if(this.validateRows()){
  	  tr = Builder.node('tr',
  	                         {
  	                           id          : trId,
  	                           ondblclick  : "JavaScript:formItem.loadEngine('"+ nameInstance +"','rowSelect','"+ trId +"')",
  	                           onmouseover : "JavaScript:formItem.loadEngine('"+ nameInstance +"','enterHover','"+ trId +"')",
  	                           onmouseout  : "JavaScript:formItem.loadEngine('"+ nameInstance +"','leaveHover','"+ trId +"')"
  	                         });
  	  for(i=0; i<cells; i++){
  	    tdId = trId + "_td_" + i;
  	    td = Builder.node('td',
  	                           {
  	                             id      : tdId,
  	                             style   : "text-align:"+this.options.alignTd[i]
  	                           });
  	    if(this.options.varOutput[i]){ td.setAttribute("code",this.options.varOutput[i]); }
  	    td.innerHTML = this.getElmInputsByInd(i, rows);
  	    tr.appendChild(td);
  	  }
  	  tabla.appendChild(tr);
  	  formItem.focusByeElm(trId+"_td_1"); //enfoca al primer elemento para el codigo
  	  
  	  this.countRows();
  	  
    }
	},
	
	deletes : function(){  //elimina las filas seleccionadas por el click
    this.elements.each(function(elm) {
      if($(elm)){ $(elm).remove(); }
    });
    this.elements = [];
    
    this.countRows();
    
	},
	
	deleteByElm : function(elm){ //elimina fila por el Id o Elemento
	  elm = $(elm);
    $(elm).remove();
	},
	
	getElmInputsByInd : function(index, rowPos){ //devuelve el contenido de cada celda de la fila
	  if(this.options.attribute[index]){
	    attrs = this._attributes(this.options.attribute[index]);
	  }else{
      attrs = this._defaultAttributes(this.options.data[index]);
	  }
	  Id = this.tableId + "_tr_" + rowPos + "_td_" + index;
	  if(this.options.varOutput[index]){
	    inputId    = Id + "_" + this.options.varOutput[index];
	    inputName  = this.options.varOutput[index];
	    codeInput  = this.options.varOutput[index];
	  }else{
	    inputId    = Id + "_default";
	    inputName  = "default[]";
	    codeInput  = "";
	  }
	  switch (this.options.data[index]){
	    case 'iText'  : returnElement = "<input type='text' code='" + codeInput + "' name='"+inputName+"' id='" + inputId + "' " + attrs + " />"; break;
	    case 'iCheck' : returnElement = "<input type='checkbox' code='" + codeInput + "' name='"+inputName+"' id='" + inputId + "' " + attrs + " />"; break;
	    case 'iSelect': returnElement = "<select code='" + codeInput + "' name='"+inputName+"' id='" + inputId + "' " + attrs + "><option value=''>-Seleccione-</option></select>"; break;
	    case 'SelectView': returnElement = "<select code='" + codeInput + "' name='"+inputName+"' id='" + inputId + "' " + attrs + "></select>"; break;
	    case 's'      : returnElement = "&nbsp;"; break;
	  }
	  return returnElement;
	},
	
  _attributes: function(attributes) { //atributos del elemento por celda
    var attrs = [];
    for(attribute in attributes)
      attrs.push((attribute=='className' ? 'class' : attribute) +
          '="' + attributes[attribute].toString().escapeHTML() + '"');
    return attrs.join(" ");
  },
	
  _defaultAttributes : function(elementName){  //atributos por defecto para la celda
    switch (elementName){
      case 'iText'  : attributeDefault = {size:"10", class:'text mayus', onfocus:"this.select();", style:"text-align:right;", value:0}; break;
      case 'iCheck' : attributeDefault = {class:'text', value:0}; break;
      case 'iSelect': attributeDefault = {}; break;
      case 's'      : attributeDefault = {}; break;
    }
    return this._attributes(attributeDefault);
  },
  
	leaveHover : function(id){  //devuelve el color por defecto de la fila cuando termina de pasar la fila
		if(this.verify(id)){
			var tr			= $(id);
			starColor1	= this.options.highlightcolor;
			colorEnd1		= this.options.defaultColor;
			tr.style.backgroundColor = colorEnd1;
			//new Effect.Highlight(tr, { startcolor:starColor1, endcolor:colorEnd1, restorecolor:"transparent",duration:0.3});			
		}
	},
	
	enterHover : function(id){  //devuelve el color por defecto de la fila cuando pasa la fila
		if(this.verify(id)){
			color		= this.options.highlightcolor;
			var tr	= $(id);			
			tr.style.backgroundColor = color;
		}
	},
	
	verify : function(id){  //verifica si esta seleccionada para no cambiar el fondo
		value = true;
		for(i=0; i<this.elements.length; i++){
			if(id == this.elements[i]){
				return false;
			}
		}
		return value;
	},
	
  rowSelect : function(id){  //row seleccionada por el click
    if(this.elements.length > 0){			
			if(!this.verify(id)){
				insert				= false;
				this.elements	= this.elements.without(id);
			}else{
				this.elements.unshift(id);
			}
		}else{
			this.elements.unshift(id);
		}
	}
		
}

Object.extend(formItem, {  //objeto q extiende a la clase para determinar el objeto simple
  
  tagNameInputs : ["SELECT", "INPUT"],
  
	loadEngine : function(objectCreate, module, idObjet){  //carga metodos de la clase padre, metodo importante para no borrar
    lineCode = objectCreate + "."+ module +"('"+idObjet+"')";
		eval(lineCode);
	},
	
	focusByeElm : function(elm){ //coloca focus al elemento
	  elm = $(elm)
	  if(elm.nodeType == 1){
	    if(elm.nodeName == "TD"){
	      if(this.tagNameInputs.indexOf(elm.firstChild.nodeName) > -1){
	        elm.firstChild.focus();
	      }
	    }else{
	      if(elm.nodeName == "INPUT"){
	        elm.focus();
	      }
	    }
	  }
	},
	
	getElmentsValueByPos : function(elm, pos){ //extrae el valor de un elemento por posicion
	  cellPos  = elm.parentNode.cellIndex;
	  elmUse   = elm.parentNode.parentNode.cells[cellPos+pos];
	  if(elmUse.firstChild){
	    if(this.tagNameInputs.indexOf(elmUse.firstChild.tagName) > -1){
	      return (elmUse.firstChild.value);
	    }else{
	      return (elmUse.innerHTML);
	    }
	  }else{
	    return (elmUse.innerHTML);
	  }
	},
	
	getElmentsByPos : function(elm, pos){ //extrae el elemento por posicion
	  cellPos  = elm.parentNode.cellIndex;
	  elmUse   = elm.parentNode.parentNode.cells[cellPos+pos];
	  if(elmUse.firstChild){
	    if(this.tagNameInputs.indexOf(elmUse.firstChild.tagName) > -1){
	      return (elmUse.firstChild);
	    }else{
	      return (elmUse);
	    }
	  }else{
	    return (elmUse);
	  }
	},
	
	objectToJson : function(object){  //devuelve un objeto como un string
	  var results = [];
	  var h = $H(object);
    h.each(function(pair){
      results.push(pair.key+':"'+pair.value+'"');
    });
    return '{' + results.join(',') + '}';
	},
	
	arrayToJson : function(array){  //devuelve el array como un string
	  var results = [];
    array.each(function(val, i) {
      if(typeof(val) == 'object'){
        string = formItem.objectToJson(val);
        results.push(string);
      }else{
        results.push(val);
      }
    });
    return '[' + results.join(',') + ']';
	},
	
	/**
	  elm          = {primer parametro (Element)}[puede ser el elemento o el id];
	  arguments[1] = {segundo parametro (Bolean)}[true=>para eliminar la imagen de carga, false=>para colocar la imagen de proceso ]
	  arguments[2] = {tercer parametro (string)}[left, center, right => posicion del imagen a mostrar como carga pero solamente para INPUT]
	*/
	loadProcess : function(elm){  //da el efecto de colocar un imagen cargando
	  elm = $(elm);
	  if(typeof(arguments[2]) == 'undefined')
	    arguments[2] = "right";
	  if(elm){
	    if(elm.tagName == "TD"){
	      if(arguments[1])
	        $(elm).innerHTML = '&nbsp;';
	      else
	        $(elm).innerHTML = '<img src="/images/common/progress.gif">';
	    }else{
	        if(arguments[1])
	          $(elm).style.background = '';
	        else
	          $(elm).style.background = 'url(/images/common/indicator.gif) no-repeat '+arguments[2]+' center #FFFFFF;';
	    }
	  }
	}
  
});