/*
 Highcharts JS v7.2.1 (2019-10-31)

 Sonification module

 (c) 2012-2019 ystein Moseng

 License: www.highcharts.com/license
*/
(function(e){"object"===typeof module&&module.exports?(e["default"]=e,module.exports=e):"function"===typeof define&&define.amd?define("highcharts/modules/sonification",["highcharts"],function(m){e(m);e.Highcharts=m;return e}):e("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(e){function m(b,e,g,k){b.hasOwnProperty(e)||(b[e]=k.apply(null,g))}e=e?e._modules:{};m(e,"modules/sonification/Instrument.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(b,e){function g(c){this.init(c)}
var k=e.pick,h={type:"oscillator",playCallbackInterval:20,oscillator:{waveformShape:"sine"}};g.prototype.init=function(c){this.initAudioContext()?(this.options=b.merge(h,c),this.id=this.options.id=c&&c.id||b.uniqueKey(),c=b.audioContext,this.gainNode=c.createGain(),this.setGain(0),(this.panNode=c.createStereoPanner&&c.createStereoPanner())?(this.setPan(0),this.gainNode.connect(this.panNode),this.panNode.connect(c.destination)):this.gainNode.connect(c.destination),"oscillator"===this.options.type&&
this.initOscillator(this.options.oscillator),this.playCallbackTimers=[]):b.error(29)};g.prototype.copy=function(c){return new g(b.merge(this.options,{id:null},c))};g.prototype.initAudioContext=function(){var c=b.win.AudioContext||b.win.webkitAudioContext,d=!!b.audioContext;return c?(b.audioContext=b.audioContext||new c,!d&&b.audioContext&&"running"===b.audioContext.state&&b.audioContext.suspend(),!!(b.audioContext&&b.audioContext.createOscillator&&b.audioContext.createGain)):!1};g.prototype.initOscillator=
function(c){this.oscillator=b.audioContext.createOscillator();this.oscillator.type=c.waveformShape;this.oscillator.connect(this.gainNode);this.oscillatorStarted=!1};g.prototype.setPan=function(c){this.panNode&&this.panNode.pan.setValueAtTime(c,b.audioContext.currentTime)};g.prototype.setGain=function(c,d){this.gainNode&&(1.2<c&&(console.warn("Highcharts sonification warning: Volume of instrument set too high."),c=1.2),d?(this.gainNode.gain.setValueAtTime(this.gainNode.gain.value,b.audioContext.currentTime),
this.gainNode.gain.linearRampToValueAtTime(c,b.audioContext.currentTime+d/1E3)):this.gainNode.gain.setValueAtTime(c,b.audioContext.currentTime))};g.prototype.cancelGainRamp=function(){this.gainNode&&this.gainNode.gain.cancelScheduledValues(0)};g.prototype.getValidFrequency=function(c,d,a){var f=this.options.allowedFrequencies,b=k(a,Infinity),g=k(d,-Infinity);return f&&f.length?f.reduce(function(d,a){return Math.abs(a-c)<Math.abs(d-c)&&a<b&&a>g?a:d},Infinity):c};g.prototype.clearPlayCallbackTimers=
function(){this.playCallbackTimers.forEach(function(c){clearInterval(c)});this.playCallbackTimers=[]};g.prototype.setFrequency=function(c,d){d=d||{};c=this.getValidFrequency(c,d.min,d.max);"oscillator"===this.options.type&&this.oscillatorPlay(c)};g.prototype.oscillatorPlay=function(c){this.oscillatorStarted||(this.oscillator.start(),this.oscillatorStarted=!0);this.oscillator.frequency.setValueAtTime(c,b.audioContext.currentTime)};g.prototype.preparePlay=function(){this.setGain(.001);"suspended"===
b.audioContext.state&&b.audioContext.resume();this.oscillator&&!this.oscillatorStarted&&(this.oscillator.start(),this.oscillatorStarted=!0)};g.prototype.play=function(c){var d=this,a=c.duration||0,f=function(a,f,b){var g=c.duration,h=0,e=d.options.playCallbackInterval;if("function"===typeof a){var k=setInterval(function(){h++;var c=h*e/g;if(1<=c)d[f](a(1),b),clearInterval(k);else d[f](a(c),b)},e);d.playCallbackTimers.push(k)}else d[f](a,b)};if(d.id)if("suspended"===b.audioContext.state||this.oscillator&&
!this.oscillatorStarted)d.preparePlay(),setTimeout(function(){d.play(c)},10);else{d.playCallbackTimers.length&&d.clearPlayCallbackTimers();d.cancelGainRamp();d.stopOscillatorTimeout&&(clearTimeout(d.stopOscillatorTimeout),delete d.stopOscillatorTimeout);d.stopTimeout&&(clearTimeout(d.stopTimeout),delete d.stopTimeout,d.stopCallback&&(d._play=d.play,d.play=function(){},d.stopCallback("cancelled"),d.play=d._play));var g=a<b.sonification.fadeOutDuration+20;d.stopCallback=c.onEnd;var h=function(){delete d.stopTimeout;
d.stop(g)};a?(d.stopTimeout=setTimeout(h,g?a:a-b.sonification.fadeOutDuration),f(c.frequency,"setFrequency",null,{minFrequency:c.minFrequency,maxFrequency:c.maxFrequency}),f(k(c.volume,1),"setGain",4),f(k(c.pan,0),"setPan")):h()}};g.prototype.mute=function(){this.setGain(.0001,.8*b.sonification.fadeOutDuration)};g.prototype.stop=function(c,d,a){var f=this,g=function(){f.stopOscillatorTimeout&&delete f.stopOscillatorTimeout;try{f.oscillator.stop()}catch(n){}f.oscillator.disconnect(f.gainNode);f.initOscillator(f.options.oscillator);
d&&d(a);f.stopCallback&&f.stopCallback(a)};f.playCallbackTimers.length&&f.clearPlayCallbackTimers();f.stopTimeout&&clearTimeout(f.stopTimeout);c?(f.setGain(0),g()):(f.mute(),f.stopOscillatorTimeout=setTimeout(g,b.sonification.fadeOutDuration+100))};return g});m(e,"modules/sonification/musicalFrequencies.js",[],function(){return[16.351597831287414,17.323914436054505,18.354047994837977,19.445436482630058,20.601722307054366,21.826764464562746,23.12465141947715,24.499714748859326,25.956543598746574,27.5,
29.13523509488062,30.86770632850775,32.70319566257483,34.64782887210901,36.70809598967594,38.890872965260115,41.20344461410875,43.653528929125486,46.2493028389543,48.999429497718666,51.91308719749314,55,58.27047018976124,61.7354126570155,65.40639132514966,69.29565774421802,73.41619197935188,77.78174593052023,82.4068892282175,87.30705785825097,92.4986056779086,97.99885899543733,103.82617439498628,110,116.54094037952248,123.47082531403103,130.8127826502993,138.59131548843604,146.8323839587038,155.56349186104046,
164.81377845643496,174.61411571650194,184.9972113558172,195.99771799087463,207.65234878997256,220,233.08188075904496,246.94165062806206,261.6255653005986,277.1826309768721,293.6647679174076,311.1269837220809,329.6275569128699,349.2282314330039,369.9944227116344,391.99543598174927,415.3046975799451,440,466.1637615180899,493.8833012561241,523.2511306011972,554.3652619537442,587.3295358348151,622.2539674441618,659.2551138257398,698.4564628660078,739.9888454232688,783.9908719634985,830.6093951598903,
880,932.3275230361799,987.7666025122483,1046.5022612023945,1108.7305239074883,1174.6590716696303,1244.5079348883237,1318.5102276514797,1396.9129257320155,1479.9776908465376,1567.981743926997,1661.2187903197805,1760,1864.6550460723597,1975.533205024496,2093.004522404789,2217.4610478149766,2349.31814333926,2489.0158697766474,2637.02045530296,2793.825851464031,2959.955381693075,3135.9634878539946,3322.437580639561,3520,3729.3100921447194,3951.066410048992,4186.009044809578]});m(e,"modules/sonification/utilities.js",
[e["modules/sonification/musicalFrequencies.js"]],function(b){function e(b){this.init(b||[])}e.prototype.init=function(b){this.supportedSignals=b;this.signals={}};e.prototype.registerSignalCallbacks=function(b){var g=this;g.supportedSignals.forEach(function(h){b[h]&&(g.signals[h]=g.signals[h]||[]).push(b[h])})};e.prototype.clearSignalCallbacks=function(b){var g=this;b?b.forEach(function(b){g.signals[b]&&delete g.signals[b]}):g.signals={}};e.prototype.emitSignal=function(b,e){var g;this.signals[b]&&
this.signals[b].forEach(function(b){b=b(e);g=void 0!==b?b:g});return g};return{musicalFrequencies:b,SignalHandler:e,getMusicalScale:function(g){return b.filter(function(b,e){var c=e%12+1;return g.some(function(b){return b===c})})},calculateDataExtremes:function(b,e){return b.series.reduce(function(b,c){c.points.forEach(function(d){d=void 0!==d[e]?d[e]:d.options[e];b.min=Math.min(b.min,d);b.max=Math.max(b.max,d)});return b},{min:Infinity,max:-Infinity})},virtualAxisTranslate:function(b,e,h){var c=
e.max-e.min;b=h.min+(h.max-h.min)*(b-e.min)/c;return 0<c?Math.max(Math.min(b,h.max),h.min):h.min}}});m(e,"modules/sonification/instrumentDefinitions.js",[e["modules/sonification/Instrument.js"],e["modules/sonification/utilities.js"]],function(b,e){var g={};["sine","square","triangle","sawtooth"].forEach(function(k){g[k]=new b({oscillator:{waveformShape:k}});g[k+"Musical"]=new b({allowedFrequencies:e.musicalFrequencies,oscillator:{waveformShape:k}});g[k+"Major"]=new b({allowedFrequencies:e.getMusicalScale([1,
3,5,6,8,10,12]),oscillator:{waveformShape:k}})});return g});m(e,"modules/sonification/Earcon.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(b,e){function g(b){this.init(b||{})}var k=e.pick;g.prototype.init=function(e){this.options=e;this.options.id||(this.options.id=this.id=b.uniqueKey());this.instrumentsPlaying={}};g.prototype.sonify=function(e){var c=b.merge(this.options,e),d=k(c.volume,1),a=c.pan,f=this,g=e&&e.onEnd,h=f.options.onEnd;c.instruments.forEach(function(c){var e="string"===
typeof c.instrument?b.sonification.instruments[c.instrument]:c.instrument,l=b.merge(c.playOptions);if(e&&e.play){if(c.playOptions){"function"!==typeof c.playOptions.volume&&(l.volume=k(d,1)*k(c.playOptions.volume,1));l.pan=k(a,l.pan);var p=l.onEnd;l.onEnd=function(){delete f.instrumentsPlaying[n];p&&p.apply(this,arguments);Object.keys(f.instrumentsPlaying).length||(g&&g.apply(this,arguments),h&&h.apply(this,arguments))};c=e.copy();var n=c.id;f.instrumentsPlaying[n]=c;c.play(l)}}else b.error(30)})};
g.prototype.cancelSonify=function(b){var c=this.instrumentsPlaying,d=c&&Object.keys(c);d&&d.length&&(d.forEach(function(a){c[a].stop(!b,null,"cancelled")}),this.instrumentsPlaying={})};return g});m(e,"modules/sonification/pointSonify.js",[e["parts/Globals.js"],e["parts/Utilities.js"],e["modules/sonification/utilities.js"]],function(b,e,g){var k=e.pick,h={minDuration:20,maxDuration:2E3,minVolume:.1,maxVolume:1,minPan:-1,maxPan:1,minFrequency:220,maxFrequency:2200};return{pointSonify:function(c){var d=
this,a=d.series.chart,f=c.dataExtremes||{},e=function(b,a,c,e){if("number"===typeof b||void 0===b)return b;if("function"===typeof b)return a?function(a){return b(d,f,a)}:b(d,f);if("string"===typeof b)return f[b]=f[b]||g.calculateDataExtremes(d.series.chart,b),g.virtualAxisTranslate(k(d[b],d.options[b]),f[b],c,e)};a.sonification.currentlyPlayingPoint=d;d.sonification=d.sonification||{};d.sonification.instrumentsPlaying=d.sonification.instrumentsPlaying||{};var n=d.sonification.signalHandler=d.sonification.signalHandler||
new g.SignalHandler(["onEnd"]);n.clearSignalCallbacks();n.registerSignalCallbacks({onEnd:c.onEnd});!d.isNull&&d.visible&&d.series.visible?c.instruments.forEach(function(c){var f="string"===typeof c.instrument?b.sonification.instruments[c.instrument]:c.instrument,g=c.instrumentMapping||{},l=b.merge(h,c.instrumentOptions),k=f.id,p=function(b){c.onEnd&&c.onEnd.apply(this,arguments);a.sonification&&a.sonification.currentlyPlayingPoint&&delete a.sonification.currentlyPlayingPoint;d.sonification&&d.sonification.instrumentsPlaying&&
(delete d.sonification.instrumentsPlaying[k],Object.keys(d.sonification.instrumentsPlaying).length||n.emitSignal("onEnd",b))};f&&f.play?(d.sonification.instrumentsPlaying[f.id]=f,f.play({frequency:e(g.frequency,!0,{min:l.minFrequency,max:l.maxFrequency}),duration:e(g.duration,!1,{min:l.minDuration,max:l.maxDuration}),pan:e(g.pan,!0,{min:l.minPan,max:l.maxPan}),volume:e(g.volume,!0,{min:l.minVolume,max:l.maxVolume}),onEnd:p,minFrequency:l.minFrequency,maxFrequency:l.maxFrequency})):b.error(30)}):n.emitSignal("onEnd")},
pointCancelSonify:function(b){var c=this.sonification&&this.sonification.instrumentsPlaying,a=c&&Object.keys(c);a&&a.length&&(a.forEach(function(a){c[a].stop(!b,null,"cancelled")}),this.sonification.instrumentsPlaying={},this.sonification.signalHandler.emitSignal("onEnd","cancelled"))}}});m(e,"modules/sonification/chartSonify.js",[e["parts/Globals.js"],e["parts/Utilities.js"],e["modules/sonification/utilities.js"]],function(b,e,g){function k(b,a){return"function"===typeof a?a(b):r(b[a],b.options[a])}
function h(b,a){return b.points.reduce(function(b,c){c=k(c,a);b.min=Math.min(b.min,c);b.max=Math.max(b.max,c);return b},{min:Infinity,max:-Infinity})}function c(a,c,d){return(c||[]).reduce(function(b,c){Object.keys(c.instrumentMapping||{}).forEach(function(d){d=c.instrumentMapping[d];"string"!==typeof d||b[d]||(b[d]=g.calculateDataExtremes(a,d))});return b},b.merge(d))}function d(a,c){return c.reduce(function(c,d){var e=d.earcon;d.condition?(d=d.condition(a),d instanceof b.sonification.Earcon?c.push(d):
d&&c.push(e)):d.onPoint&&a.id===d.onPoint&&c.push(e);return c},[])}function a(c){return c.map(function(c){var a=c.instrument;a=("string"===typeof a?b.sonification.instruments[a]:a).copy();return b.merge(c,{instrument:a})})}function f(e,f){var x=f.timeExtremes||h(e,f.pointPlayTime,f.dataExtremes),l=c(e.chart,f.instruments,f.dataExtremes),y=a(f.instruments),n=e.points.reduce(function(c,a){var e=d(a,f.earcons||[]),h=g.virtualAxisTranslate(k(a,f.pointPlayTime),x,{min:0,max:f.duration});return c.concat(new b.sonification.TimelineEvent({eventObject:a,
time:h,id:a.id,playOptions:{instruments:y,dataExtremes:l}}),e.map(function(a){return new b.sonification.TimelineEvent({eventObject:a,time:h})}))},[]);return new b.sonification.TimelinePath({events:n,onStart:function(){if(f.onStart)f.onStart(e)},onEventStart:function(a){var c=a.options&&a.options.eventObject;if(c instanceof b.Point){if(!c.series.visible&&!c.series.chart.series.some(function(b){return b.visible}))return a.timelinePath.timeline.pause(),a.timelinePath.timeline.resetCursor(),!1;if(f.onPointStart)f.onPointStart(a,
c)}},onEventEnd:function(a){var c=a.event&&a.event.options&&a.event.options.eventObject;if(c instanceof b.Point&&f.onPointEnd)f.onPointEnd(a.event,c)},onEnd:function(){if(f.onEnd)f.onEnd(e)}})}function l(a,c,d){var f=d.seriesOptions||{};return b.merge({dataExtremes:c,timeExtremes:h(a,d.pointPlayTime),instruments:d.instruments,onStart:d.onSeriesStart,onEnd:d.onSeriesEnd,earcons:d.earcons},t(f)?b.find(f,function(b){return b.id===r(a.id,a.options.id)})||{}:f,{pointPlayTime:d.pointPlayTime})}function n(a,
c,d){if("sequential"===a||"simultaneous"===a){var f=c.series.reduce(function(b,a){a.visible&&b.push({series:a,seriesOptions:d(a)});return b},[]);"simultaneous"===a&&(f=[f])}else f=a.reduce(function(a,f){f=q(f).reduce(function(a,f){var e;if("string"===typeof f){var g=c.get(f);g.visible&&(e={series:g,seriesOptions:d(g)})}else f instanceof b.sonification.Earcon&&(e=new b.sonification.TimelinePath({events:[new b.sonification.TimelineEvent({eventObject:f})]}));f.silentWait&&(e=new b.sonification.TimelinePath({silentWait:f.silentWait}));
e&&a.push(e);return a},[]);f.length&&a.push(f);return a},[]);return f}function p(a,c){return c?a.reduce(function(f,d,e){d=q(d);f.push(d);e<a.length-1&&d.some(function(a){return a.series})&&f.push(new b.sonification.TimelinePath({silentWait:c}));return f},[]):a}function m(a){return a.reduce(function(a,b){b=q(b);return a+(1===b.length&&b[0].options&&b[0].options.silentWait||0)},0)}function u(a){var c=a.reduce(function(a,b){(b=b.events)&&b.length&&(a.min=Math.min(b[0].time,a.min),a.max=Math.max(b[b.length-
1].time,a.max));return a},{min:Infinity,max:-Infinity});a.forEach(function(a){var f=a.events,d=f&&f.length,e=[];d&&f[0].time<=c.min||e.push(new b.sonification.TimelineEvent({time:c.min}));d&&f[f.length-1].time>=c.max||e.push(new b.sonification.TimelineEvent({time:c.max}));e.length&&a.addTimelineEvents(e)})}function v(a){return a.reduce(function(a,b){return a+q(b).reduce(function(a,b){return(b=b.series&&b.seriesOptions&&b.seriesOptions.timeExtremes)?Math.max(a,b.max-b.min):a},0)},0)}function w(a,c){var d=
Math.max(c-m(a),0),e=v(a);return a.reduce(function(a,c){c=q(c).reduce(function(a,c){c instanceof b.sonification.TimelinePath?a.push(c):c.series&&(c.seriesOptions.duration=c.seriesOptions.duration||g.virtualAxisTranslate(c.seriesOptions.timeExtremes.max-c.seriesOptions.timeExtremes.min,{min:0,max:e},{min:0,max:d}),a.push(f(c.series,c.seriesOptions)));return a},[]);a.push(c);return a},[])}var t=e.isArray,r=e.pick,q=e.splat;return{chartSonify:function(a){this.sonification.timeline&&this.sonification.timeline.pause();
var f=c(this,a.instruments,a.dataExtremes),d=n(a.order,this,function(b){return l(b,f,a)});d=p(d,a.afterSeriesWait||0);d=w(d,a.duration);d.forEach(function(a){u(a)});this.sonification.timeline=new b.sonification.Timeline({paths:d,onEnd:a.onEnd});this.sonification.timeline.play()},seriesSonify:function(a){a=f(this,a);var c=this.chart.sonification;c.timeline&&c.timeline.pause();c.timeline=new b.sonification.Timeline({paths:[a]});c.timeline.play()},pause:function(a){this.sonification.timeline?this.sonification.timeline.pause(r(a,
!0)):this.sonification.currentlyPlayingPoint&&this.sonification.currentlyPlayingPoint.cancelSonify(a)},resume:function(a){this.sonification.timeline&&this.sonification.timeline.play(a)},rewind:function(a){this.sonification.timeline&&this.sonification.timeline.rewind(a)},cancel:function(a){this.pauseSonify(a);this.resetSonifyCursor()},getCurrentPoints:function(){if(this.sonification.timeline){var a=this.sonification.timeline.getCursor();return Object.keys(a).map(function(b){return a[b].eventObject}).filter(function(a){return a instanceof
b.Point})}return[]},setCursor:function(a){var b=this.sonification.timeline;b&&q(a).forEach(function(a){b.setCursor(a.id)})},resetCursor:function(){this.sonification.timeline&&this.sonification.timeline.resetCursor()},resetCursorEnd:function(){this.sonification.timeline&&this.sonification.timeline.resetCursorEnd()}}});m(e,"modules/sonification/Timeline.js",[e["parts/Globals.js"],e["parts/Utilities.js"],e["modules/sonification/utilities.js"]],function(b,e,g){function k(a){this.init(a||{})}function h(a){this.init(a)}
function c(a){this.init(a||{})}var d=e.splat;k.prototype.init=function(a){this.options=a;this.time=a.time||0;this.id=this.options.id=a.id||b.uniqueKey()};k.prototype.play=function(a){var c=this.options.eventObject,d=this.options.onEnd,e=a&&a.onEnd,g=this.options.playOptions&&this.options.playOptions.onEnd;a=b.merge(this.options.playOptions,a);c&&c.sonify?(a.onEnd=d||e||g?function(){var a=arguments;[d,e,g].forEach(function(b){b&&b.apply(this,a)})}:void 0,c.sonify(a)):(e&&e(),d&&d())};k.prototype.cancel=
function(a){this.options.eventObject.cancelSonify(a)};h.prototype.init=function(a){this.options=a;this.id=this.options.id=a.id||b.uniqueKey();this.cursor=0;this.eventsPlaying={};this.events=a.silentWait?[new k({time:0}),new k({time:a.silentWait})]:this.options.events;this.sortEvents();this.updateEventIdMap();this.signalHandler=new g.SignalHandler(["playOnEnd","masterOnEnd","onStart","onEventStart","onEventEnd"]);this.signalHandler.registerSignalCallbacks(b.merge(a,{masterOnEnd:a.onEnd}))};h.prototype.sortEvents=
function(){this.events=this.events.sort(function(a,b){return a.time-b.time})};h.prototype.updateEventIdMap=function(){this.eventIdMap=this.events.reduce(function(a,b,c){a[b.id]=c;return a},{})};h.prototype.addTimelineEvents=function(a){this.events=this.events.concat(a);this.sortEvents();this.updateEventIdMap()};h.prototype.getCursor=function(){return this.events[this.cursor]};h.prototype.setCursor=function(a){a=this.eventIdMap[a];return void 0!==a?(this.cursor=a,!0):!1};h.prototype.play=function(a){this.pause();
this.signalHandler.emitSignal("onStart");this.signalHandler.clearSignalCallbacks(["playOnEnd"]);this.signalHandler.registerSignalCallbacks({playOnEnd:a});this.playEvents(1)};h.prototype.rewind=function(a){this.pause();this.signalHandler.emitSignal("onStart");this.signalHandler.clearSignalCallbacks(["playOnEnd"]);this.signalHandler.registerSignalCallbacks({playOnEnd:a});this.playEvents(-1)};h.prototype.resetCursor=function(){this.cursor=0};h.prototype.resetCursorEnd=function(){this.cursor=this.events.length-
1};h.prototype.pause=function(a){var b=this;clearTimeout(b.nextScheduledPlay);Object.keys(b.eventsPlaying).forEach(function(c){b.eventsPlaying[c]&&b.eventsPlaying[c].cancel(a)});b.eventsPlaying={}};h.prototype.playEvents=function(a){var b=this,c=b.events[this.cursor],d=b.events[this.cursor+a],e=function(a){b.signalHandler.emitSignal("masterOnEnd",a);b.signalHandler.emitSignal("playOnEnd",a)};c.timelinePath=b;if(!1===b.signalHandler.emitSignal("onEventStart",c))e({event:c,cancelled:!0});else if(b.eventsPlaying[c.id]=
c,c.play({onEnd:function(a){a={event:c,cancelled:!!a};delete b.eventsPlaying[c.id];b.signalHandler.emitSignal("onEventEnd",a);d||e(a)}}),d){var g=Math.abs(d.time-c.time);1>g?(b.cursor+=a,b.playEvents(a)):this.nextScheduledPlay=setTimeout(function(){b.cursor+=a;b.playEvents(a)},g)}};c.prototype.init=function(a){this.options=a;this.cursor=0;this.paths=a.paths;this.pathsPlaying={};this.signalHandler=new g.SignalHandler(["playOnEnd","masterOnEnd","onPathStart","onPathEnd"]);this.signalHandler.registerSignalCallbacks(b.merge(a,
{masterOnEnd:a.onEnd}))};c.prototype.play=function(a){this.pause();this.signalHandler.clearSignalCallbacks(["playOnEnd"]);this.signalHandler.registerSignalCallbacks({playOnEnd:a});this.playPaths(1)};c.prototype.rewind=function(a){this.pause();this.signalHandler.clearSignalCallbacks(["playOnEnd"]);this.signalHandler.registerSignalCallbacks({playOnEnd:a});this.playPaths(-1)};c.prototype.playPaths=function(a){var c=d(this.paths[this.cursor]),e=this.paths[this.cursor+a],g=this,h=this.signalHandler,k=
0,m=function(b){h.emitSignal("onPathStart",b);g.pathsPlaying[b.id]=b;b[0<a?"play":"rewind"](function(f){f=f&&f.cancelled;var l={path:b,cancelled:f};delete g.pathsPlaying[b.id];h.emitSignal("onPathEnd",l);k++;k>=c.length&&(e&&!f?(g.cursor+=a,d(e).forEach(function(b){b[0<a?"resetCursor":"resetCursorEnd"]()}),g.playPaths(a)):(h.emitSignal("playOnEnd",l),h.emitSignal("masterOnEnd",l)))})};c.forEach(function(a){a&&(a.timeline=g,setTimeout(function(){m(a)},b.sonification.fadeOutTime))})};c.prototype.pause=
function(a){var b=this;Object.keys(b.pathsPlaying).forEach(function(c){b.pathsPlaying[c]&&b.pathsPlaying[c].pause(a)});b.pathsPlaying={}};c.prototype.resetCursor=function(){this.paths.forEach(function(a){d(a).forEach(function(a){a.resetCursor()})});this.cursor=0};c.prototype.resetCursorEnd=function(){this.paths.forEach(function(a){d(a).forEach(function(a){a.resetCursorEnd()})});this.cursor=this.paths.length-1};c.prototype.setCursor=function(a){return this.paths.some(function(b){return d(b).some(function(b){return b.setCursor(a)})})};
c.prototype.getCursor=function(){return this.getCurrentPlayingPaths().reduce(function(a,b){a[b.id]=b.getCursor();return a},{})};c.prototype.atStart=function(){return!this.getCurrentPlayingPaths().some(function(a){return a.cursor})};c.prototype.getCurrentPlayingPaths=function(){return d(this.paths[this.cursor])};return{TimelineEvent:k,TimelinePath:h,Timeline:c}});m(e,"modules/sonification/sonification.js",[e["parts/Globals.js"],e["parts/Utilities.js"],e["modules/sonification/Instrument.js"],e["modules/sonification/instrumentDefinitions.js"],
e["modules/sonification/Earcon.js"],e["modules/sonification/pointSonify.js"],e["modules/sonification/chartSonify.js"],e["modules/sonification/utilities.js"],e["modules/sonification/Timeline.js"]],function(b,e,g,k,h,c,d,a,f){e=e.extend;b.sonification={fadeOutDuration:20,utilities:a,Instrument:g,instruments:k,Earcon:h,TimelineEvent:f.TimelineEvent,TimelinePath:f.TimelinePath,Timeline:f.Timeline};b.Point.prototype.sonify=c.pointSonify;b.Point.prototype.cancelSonify=c.pointCancelSonify;b.Series.prototype.sonify=
d.seriesSonify;e(b.Chart.prototype,{sonify:d.chartSonify,pauseSonify:d.pause,resumeSonify:d.resume,rewindSonify:d.rewind,cancelSonify:d.cancel,getCurrentSonifyPoints:d.getCurrentPoints,setSonifyCursor:d.setCursor,resetSonifyCursor:d.resetCursor,resetSonifyCursorEnd:d.resetCursorEnd,sonification:{}})});m(e,"masters/modules/sonification.src.js",[],function(){})});
//# sourceMappingURL=sonification.js.map