/*
 Highcharts JS v7.2.1 (2019-10-31)

 Boost module

 (c) 2010-2019 Highsoft AS
 Author: Torstein Honsi

 License: www.highcharts.com/license

 This is a Highcharts module that draws long data series on a canvas in order
 to increase performance of the initial load time and tooltip responsiveness.

 Compatible with WebGL compatible browsers (not IE < 11).

 If this module is taken in as part of the core
 - All the loading logic should be merged with core. Update styles in the
   core.
 - Most of the method wraps should probably be added directly in parent
   methods.

 Notes for boost mode
 - Area lines are not drawn
 - Lines are not drawn on scatter charts
 - Zones and negativeColor don't work
 - Dash styles are not rendered on lines.
 - Columns are always one pixel wide. Don't set the threshold too low.
 - Disable animations
 - Marker shapes are not supported: markers will always be circles

 Optimizing tips for users
 - Set extremes (min, max) explicitly on the axes in order for Highcharts to
   avoid computing extremes.
 - Set enableMouseTracking to false on the series to improve total rendering
      time.
 - The default threshold is set based on one series. If you have multiple,
   dense series, the combined number of points drawn gets higher, and you may
   want to set the threshold lower in order to use optimizations.
 - If drawing large scatter charts, it's beneficial to set the marker radius
   to a value less than 1. This is to add additional spacing to make the chart
   more readable.
 - If the value increments on both the X and Y axis aren't small, consider
   setting useGPUTranslations to true on the boost settings object. If you do
   this and the increments are small (e.g. datetime axis with small time
   increments) it may cause rendering issues due to floating point rounding
   errors, so your millage may vary.

 Settings
    There are two ways of setting the boost threshold:
    - Per series: boost based on number of points in individual series
    - Per chart: boost based on the number of series

  To set the series boost threshold, set seriesBoostThreshold on the chart
  object.
  To set the series-specific threshold, set boostThreshold on the series
  object.

  In addition, the following can be set in the boost object:
  {
      //Wether or not to use alpha blending
      useAlpha: boolean - default: true
      //Set to true to perform translations on the GPU.
      //Much faster, but may cause rendering issues
      //when using values far from 0 due to floating point
      //rounding issues
      useGPUTranslations: boolean - default: false
      //Use pre-allocated buffers, much faster,
      //but may cause rendering issues with some data sets
      usePreallocated: boolean - default: false
  }
*/
(function(c){"object"===typeof module&&module.exports?(c["default"]=c,module.exports=c):"function"===typeof define&&define.amd?define("highcharts/modules/boost",["highcharts"],function(n){c(n);c.Highcharts=n;return c}):c("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(c){function n(e,c,d,H){e.hasOwnProperty(c)||(e[c]=H.apply(null,d))}c=c?c._modules:{};n(c,"modules/boost/boostables.js",[],function(){return"area arearange column columnrange bar line scatter heatmap bubble treemap".split(" ")});
n(c,"modules/boost/boostable-map.js",[c["modules/boost/boostables.js"]],function(e){var c={};e.forEach(function(d){c[d]=1});return c});n(c,"modules/boost/wgl-shader.js",[c["parts/Globals.js"]],function(e){var c=e.pick;return function(d){function y(){E.length&&e.error("[highcharts boost] shader error - "+E.join("\n"))}function h(b,f){var a=d.createShader("vertex"===f?d.VERTEX_SHADER:d.FRAGMENT_SHADER);d.shaderSource(a,b);d.compileShader(a);return d.getShaderParameter(a,d.COMPILE_STATUS)?a:(E.push("when compiling "+
f+" shader:\n"+d.getShaderInfoLog(a)),!1)}function v(){function e(g){return d.getUniformLocation(b,g)}var k=h("#version 100\n#define LN10 2.302585092994046\nprecision highp float;\nattribute vec4 aVertexPosition;\nattribute vec4 aColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform mat4 uPMatrix;\nuniform float pSize;\nuniform float translatedThreshold;\nuniform bool hasThreshold;\nuniform bool skipTranslation;\nuniform float xAxisTrans;\nuniform float xAxisMin;\nuniform float xAxisMinPad;\nuniform float xAxisPointRange;\nuniform float xAxisLen;\nuniform bool  xAxisPostTranslate;\nuniform float xAxisOrdinalSlope;\nuniform float xAxisOrdinalOffset;\nuniform float xAxisPos;\nuniform bool  xAxisCVSCoord;\nuniform bool  xAxisIsLog;\nuniform bool  xAxisReversed;\nuniform float yAxisTrans;\nuniform float yAxisMin;\nuniform float yAxisMinPad;\nuniform float yAxisPointRange;\nuniform float yAxisLen;\nuniform bool  yAxisPostTranslate;\nuniform float yAxisOrdinalSlope;\nuniform float yAxisOrdinalOffset;\nuniform float yAxisPos;\nuniform bool  yAxisCVSCoord;\nuniform bool  yAxisIsLog;\nuniform bool  yAxisReversed;\nuniform bool  isBubble;\nuniform bool  bubbleSizeByArea;\nuniform float bubbleZMin;\nuniform float bubbleZMax;\nuniform float bubbleZThreshold;\nuniform float bubbleMinSize;\nuniform float bubbleMaxSize;\nuniform bool  bubbleSizeAbs;\nuniform bool  isInverted;\nfloat bubbleRadius(){\nfloat value = aVertexPosition.w;\nfloat zMax = bubbleZMax;\nfloat zMin = bubbleZMin;\nfloat radius = 0.0;\nfloat pos = 0.0;\nfloat zRange = zMax - zMin;\nif (bubbleSizeAbs){\nvalue = value - bubbleZThreshold;\nzMax = max(zMax - bubbleZThreshold, zMin - bubbleZThreshold);\nzMin = 0.0;\n}\nif (value < zMin){\nradius = bubbleZMin / 2.0 - 1.0;\n} else {\npos = zRange > 0.0 ? (value - zMin) / zRange : 0.5;\nif (bubbleSizeByArea && pos > 0.0){\npos = sqrt(pos);\n}\nradius = ceil(bubbleMinSize + pos * (bubbleMaxSize - bubbleMinSize)) / 2.0;\n}\nreturn radius * 2.0;\n}\nfloat translate(float val,\nfloat pointPlacement,\nfloat localA,\nfloat localMin,\nfloat minPixelPadding,\nfloat pointRange,\nfloat len,\nbool  cvsCoord,\nbool  isLog,\nbool  reversed\n){\nfloat sign = 1.0;\nfloat cvsOffset = 0.0;\nif (cvsCoord) {\nsign *= -1.0;\ncvsOffset = len;\n}\nif (isLog) {\nval = log(val) / LN10;\n}\nif (reversed) {\nsign *= -1.0;\ncvsOffset -= sign * len;\n}\nreturn sign * (val - localMin) * localA + cvsOffset + \n(sign * minPixelPadding);\n}\nfloat xToPixels(float value) {\nif (skipTranslation){\nreturn value;// + xAxisPos;\n}\nreturn translate(value, 0.0, xAxisTrans, xAxisMin, xAxisMinPad, xAxisPointRange, xAxisLen, xAxisCVSCoord, xAxisIsLog, xAxisReversed);// + xAxisPos;\n}\nfloat yToPixels(float value, float checkTreshold) {\nfloat v;\nif (skipTranslation){\nv = value;// + yAxisPos;\n} else {\nv = translate(value, 0.0, yAxisTrans, yAxisMin, yAxisMinPad, yAxisPointRange, yAxisLen, yAxisCVSCoord, yAxisIsLog, yAxisReversed);// + yAxisPos;\nif (v > yAxisLen) {\nv = yAxisLen;\n}\n}\nif (checkTreshold > 0.0 && hasThreshold) {\nv = min(v, translatedThreshold);\n}\nreturn v;\n}\nvoid main(void) {\nif (isBubble){\ngl_PointSize = bubbleRadius();\n} else {\ngl_PointSize = pSize;\n}\nvColor = aColor;\nif (skipTranslation && isInverted) {\ngl_Position = uPMatrix * vec4(aVertexPosition.y + yAxisPos, aVertexPosition.x + xAxisPos, 0.0, 1.0);\n} else if (isInverted) {\ngl_Position = uPMatrix * vec4(yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, xToPixels(aVertexPosition.x) + xAxisPos, 0.0, 1.0);\n} else {\ngl_Position = uPMatrix * vec4(xToPixels(aVertexPosition.x) + xAxisPos, yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, 0.0, 1.0);\n}\n}",
"vertex"),c=h("precision highp float;\nuniform vec4 fillColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform sampler2D uSampler;\nuniform bool isCircle;\nuniform bool hasColor;\nvoid main(void) {\nvec4 col = fillColor;\nvec4 tcol;\nif (hasColor) {\ncol = vColor;\n}\nif (isCircle) {\ntcol = texture2D(uSampler, gl_PointCoord.st);\ncol *= tcol;\nif (tcol.r < 0.0) {\ndiscard;\n} else {\ngl_FragColor = col;\n}\n} else {\ngl_FragColor = col;\n}\n}","fragment");if(!k||!c)return b=!1,
y(),!1;b=d.createProgram();d.attachShader(b,k);d.attachShader(b,c);d.linkProgram(b);if(!d.getProgramParameter(b,d.LINK_STATUS))return E.push(d.getProgramInfoLog(b)),y(),b=!1;d.useProgram(b);d.bindAttribLocation(b,0,"aVertexPosition");t=e("uPMatrix");M=e("pSize");B=e("fillColor");l=e("isBubble");r=e("bubbleSizeAbs");f=e("bubbleSizeByArea");A=e("uSampler");a=e("skipTranslation");I=e("isCircle");m=e("isInverted");return!0}function q(a,f){d&&b&&(a=p[a]=p[a]||d.getUniformLocation(b,a),d.uniform1f(a,f))}
var p={},b,t,M,B,l,r,f,a,I,m,E=[],A;return d&&!v()?!1:{psUniform:function(){return M},pUniform:function(){return t},fillColorUniform:function(){return B},setBubbleUniforms:function(a,e,m){var g=a.options,k=Number.MAX_VALUE,h=-Number.MAX_VALUE;d&&b&&"bubble"===a.type&&(k=c(g.zMin,Math.min(k,Math.max(e,!1===g.displayNegative?g.zThreshold:-Number.MAX_VALUE))),h=c(g.zMax,Math.max(h,m)),d.uniform1i(l,1),d.uniform1i(I,1),d.uniform1i(f,"width"!==a.options.sizeBy),d.uniform1i(r,a.options.sizeByAbsoluteValue),
q("bubbleZMin",k),q("bubbleZMax",h),q("bubbleZThreshold",a.options.zThreshold),q("bubbleMinSize",a.minPxSize),q("bubbleMaxSize",a.maxPxSize))},bind:function(){d&&b&&d.useProgram(b)},program:function(){return b},create:v,setUniform:q,setPMatrix:function(a){d&&b&&d.uniformMatrix4fv(t,!1,a)},setColor:function(a){d&&b&&d.uniform4f(B,a[0]/255,a[1]/255,a[2]/255,a[3])},setPointSize:function(a){d&&b&&d.uniform1f(M,a)},setSkipTranslation:function(f){d&&b&&d.uniform1i(a,!0===f?1:0)},setTexture:function(a){d&&
b&&d.uniform1i(A,a)},setDrawAsCircle:function(a){d&&b&&d.uniform1i(I,a?1:0)},reset:function(){d&&b&&(d.uniform1i(l,0),d.uniform1i(I,0))},setInverted:function(a){d&&b&&d.uniform1i(m,a)},destroy:function(){d&&b&&(d.deleteProgram(b),b=!1)}}}});n(c,"modules/boost/wgl-vbuffer.js",[],function(){return function(e,c,d){function y(){h&&(e.deleteBuffer(h),v=h=!1);b=0;q=d||2;t=[]}var h=!1,v=!1,q=d||2,p=!1,b=0,t;return{destroy:y,bind:function(){if(!h)return!1;e.vertexAttribPointer(v,q,e.FLOAT,!1,0,0)},data:t,
build:function(b,d,l){var r;t=b||[];if(!(t&&0!==t.length||p))return y(),!1;q=l||q;h&&e.deleteBuffer(h);p||(r=new Float32Array(t));h=e.createBuffer();e.bindBuffer(e.ARRAY_BUFFER,h);e.bufferData(e.ARRAY_BUFFER,p||r,e.STATIC_DRAW);v=e.getAttribLocation(c.program(),d);e.enableVertexAttribArray(v);return!0},render:function(b,d,l){var c=p?p.length:t.length;if(!h||!c)return!1;if(!b||b>c||0>b)b=0;if(!d||d>c)d=c;e.drawArrays(e[(l||"points").toUpperCase()],b/q,(d-b)/q);return!0},allocate:function(d){b=-1;p=
new Float32Array(4*d)},push:function(d,e,c,h){p&&(p[++b]=d,p[++b]=e,p[++b]=c,p[++b]=h)}}}});n(c,"modules/boost/wgl-renderer.js",[c["parts/Globals.js"],c["modules/boost/wgl-shader.js"],c["modules/boost/wgl-vbuffer.js"],c["parts/Utilities.js"]],function(e,c,d,n){var h=n.isNumber,v=n.objectEach,q=e.win.document,p=e.merge,b=e.some,t=e.Color,y=e.pick;return function(n){function l(b){if(b.isSeriesBoosting){var a=!!b.options.stacking;var f=b.xData||b.options.xData||b.processedXData;a=(a?b.data:f||b.options.data).length;
"treemap"===b.type?a*=12:"heatmap"===b.type?a*=6:W[b.type]&&(a*=2);return a}return 0}function r(){g.clear(g.COLOR_BUFFER_BIT|g.DEPTH_BUFFER_BIT)}function f(a,f){function d(a){a&&(f.colorData.push(a[0]),f.colorData.push(a[1]),f.colorData.push(a[2]),f.colorData.push(a[3]))}function g(a,b,f,g,e){d(e);w.usePreallocated?L.push(a,b,f?1:0,g||1):(N.push(a),N.push(b),N.push(f?1:0),N.push(g||1))}function m(){f.segments.length&&(f.segments[f.segments.length-1].to=N.length)}function c(){f.segments.length&&f.segments[f.segments.length-
1].from===N.length||(m(),f.segments.push({from:N.length}))}function k(a,b,f,e,m){d(m);g(a+f,b);d(m);g(a,b);d(m);g(a,b+e);d(m);g(a,b+e);d(m);g(a+f,b+e);d(m);g(a+f,b)}function l(a,b){w.useGPUTranslations||(f.skipTranslation=!0,a.x=n.toPixels(a.x,!0),a.y=y.toPixels(a.y,!0));b?N=[a.x,a.y,0,2].concat(N):g(a.x,a.y,0,2)}var I=a.pointArrayMap&&"low,high"===a.pointArrayMap.join(","),T=a.chart,C=a.options,h=!!C.stacking,r=C.data,A=a.xAxis.getExtremes(),q=A.min;A=A.max;var p=a.yAxis.getExtremes(),X=p.min;p=
p.max;var E=a.xData||C.xData||a.processedXData,v=a.yData||C.yData||a.processedYData,t=a.zData||C.zData||a.processedZData,y=a.yAxis,n=a.xAxis,qa=a.chart.plotWidth,M=!E||0===E.length,K=C.connectNulls,u=a.points||!1,H=!1,B=!1,z,F;r=h?a.data:E||r;E={x:Number.MAX_VALUE,y:0};var J={x:-Number.MAX_VALUE,y:0},ja=0,S=!1,G=-1,Q=!1,U=!1,R="undefined"===typeof T.index,ea=!1,fa=!1,O=!1,ya=W[a.type],ha=!1,ra=!0,sa=!0,Y=C.zones||!1,V=!1,ta=C.threshold,ia=!1;if(!(C.boostData&&0<C.boostData.length)){C.gapSize&&(ia=
"value"!==C.gapUnit?C.gapSize*a.closestPointRange:C.gapSize);Y&&(b(Y,function(a){if("undefined"===typeof a.value)return V=new e.Color(a.color),!0}),V||(V=a.pointAttribs&&a.pointAttribs().fill||a.color,V=new e.Color(V)));T.inverted&&(qa=a.chart.plotHeight);a.closestPointRangePx=Number.MAX_VALUE;c();if(u&&0<u.length)f.skipTranslation=!0,f.drawMode="triangles",u[0].node&&u[0].node.levelDynamic&&u.sort(function(a,b){if(a.node){if(a.node.levelDynamic>b.node.levelDynamic)return 1;if(a.node.levelDynamic<
b.node.levelDynamic)return-1}return 0}),u.forEach(function(b){var f=b.plotY;if("undefined"!==typeof f&&!isNaN(f)&&null!==b.y){f=b.shapeArgs;var g=T.styledMode?b.series.colorAttribs(b):g=b.series.pointAttribs(b);b=g["stroke-width"]||0;z=e.color(g.fill).rgba;z[0]/=255;z[1]/=255;z[2]/=255;"treemap"===a.type&&(b=b||1,F=e.color(g.stroke).rgba,F[0]/=255,F[1]/=255,F[2]/=255,k(f.x,f.y,f.width,f.height,F),b/=2);"heatmap"===a.type&&T.inverted&&(f.x=n.len-f.x,f.y=y.len-f.y,f.width=-f.width,f.height=-f.height);
k(f.x+b,f.y+b,f.width-2*b,f.height-2*b,z)}});else{for(;G<r.length-1;){var D=r[++G];if(R)break;if(M){u=D[0];var x=D[1];r[G+1]&&(U=r[G+1][0]);r[G-1]&&(Q=r[G-1][0]);if(3<=D.length){var ua=D[2];D[2]>f.zMax&&(f.zMax=D[2]);D[2]<f.zMin&&(f.zMin=D[2])}}else u=D,x=v[G],r[G+1]&&(U=r[G+1]),r[G-1]&&(Q=r[G-1]),t&&t.length&&(ua=t[G],t[G]>f.zMax&&(f.zMax=t[G]),t[G]<f.zMin&&(f.zMin=t[G]));if(K||null!==u&&null!==x){U&&U>=q&&U<=A&&(ea=!0);Q&&Q>=q&&Q<=A&&(fa=!0);if(I){M&&(x=D.slice(1,3));var aa=x[0];x=x[1]}else h&&
(u=D.x,x=D.stackY,aa=x-D.y);null!==X&&"undefined"!==typeof X&&null!==p&&"undefined"!==typeof p&&(ra=x>=X&&x<=p);u>A&&J.x<A&&(J.x=u,J.y=x);u<q&&E.x>q&&(E.x=u,E.y=x);if(null!==x||!K)if(null!==x&&(ra||ea||fa)){if((U>=q||u>=q)&&(Q<=A||u<=A)&&(ha=!0),ha||ea||fa){ia&&u-Q>ia&&c();Y&&(O=V.rgba,b(Y,function(a,b){b=Y[b-1];if("undefined"!==typeof a.value&&x<=a.value){if(!b||x>=b.value)O=e.color(a.color).rgba;return!0}}),O[0]/=255,O[1]/=255,O[2]/=255);if(!w.useGPUTranslations&&(f.skipTranslation=!0,u=n.toPixels(u,
!0),x=y.toPixels(x,!0),u>qa&&"points"===f.drawMode))continue;if(ya){D=aa;if(!1===aa||"undefined"===typeof aa)D=0>x?x:0;I||h||(D=Math.max(null===ta?X:ta,X));w.useGPUTranslations||(D=y.toPixels(D,!0));g(u,D,0,0,O)}f.hasMarkers&&ha&&!1!==H&&(a.closestPointRangePx=Math.min(a.closestPointRangePx,Math.abs(u-H)));!w.useGPUTranslations&&!w.usePreallocated&&H&&1>Math.abs(u-H)&&B&&1>Math.abs(x-B)?w.debug.showSkipSummary&&++ja:(C.step&&!sa&&g(u,B,0,2,O),g(u,x,0,"bubble"===a.type?ua||1:2,O),H=u,B=x,S=!0,sa=!1)}}else c()}else c()}w.debug.showSkipSummary&&
console.log("skipped points:",ja);S||!1===K||"line_strip"!==a.drawMode||(E.x<Number.MAX_VALUE&&l(E,!0),J.x>-Number.MAX_VALUE&&l(J))}m()}}function a(){z=[];B.data=N=[];H=[];L&&L.destroy()}function I(a){k&&(k.setUniform("xAxisTrans",a.transA),k.setUniform("xAxisMin",a.min),k.setUniform("xAxisMinPad",a.minPixelPadding),k.setUniform("xAxisPointRange",a.pointRange),k.setUniform("xAxisLen",a.len),k.setUniform("xAxisPos",a.pos),k.setUniform("xAxisCVSCoord",!a.horiz),k.setUniform("xAxisIsLog",a.isLog),k.setUniform("xAxisReversed",
!!a.reversed))}function m(a){k&&(k.setUniform("yAxisTrans",a.transA),k.setUniform("yAxisMin",a.min),k.setUniform("yAxisMinPad",a.minPixelPadding),k.setUniform("yAxisPointRange",a.pointRange),k.setUniform("yAxisLen",a.len),k.setUniform("yAxisPos",a.pos),k.setUniform("yAxisCVSCoord",!a.horiz),k.setUniform("yAxisIsLog",a.isLog),k.setUniform("yAxisReversed",!!a.reversed))}function E(a,b){k.setUniform("hasThreshold",a);k.setUniform("translatedThreshold",b)}function A(b){if(b)K=b.chartWidth||800,F=b.chartHeight||
400;else return!1;if(!(g&&K&&F&&k))return!1;w.debug.timeRendering&&console.time("gl rendering");g.canvas.width=K;g.canvas.height=F;k.bind();g.viewport(0,0,K,F);k.setPMatrix([2/K,0,0,0,0,-(2/F),0,0,0,0,-2,0,-1,1,-1,1]);1<w.lineWidth&&!e.isMS&&g.lineWidth(w.lineWidth);L.build(B.data,"aVertexPosition",4);L.bind();k.setInverted(b.inverted);z.forEach(function(a,f){var c=a.series.options,l=c.marker;var r="undefined"!==typeof c.lineWidth?c.lineWidth:1;var A=c.threshold,q=h(A),p=a.series.yAxis.getThreshold(A);
A=y(c.marker?c.marker.enabled:null,a.series.xAxis.isRadial?!0:null,a.series.closestPointRangePx>2*((c.marker?c.marker.radius:10)||10));l=J[l&&l.symbol||a.series.symbol]||J.circle;if(!(0===a.segments.length||a.segmentslength&&a.segments[0].from===a.segments[0].to)){l.isReady&&(g.bindTexture(g.TEXTURE_2D,l.handle),k.setTexture(l.handle));b.styledMode?l=a.series.markerGroup&&a.series.markerGroup.getStyle("fill"):(l=a.series.pointAttribs&&a.series.pointAttribs().fill||a.series.color,c.colorByPoint&&(l=
a.series.chart.options.colors[f]));a.series.fillOpacity&&c.fillOpacity&&(l=(new t(l)).setOpacity(y(c.fillOpacity,1)).get());l=e.color(l).rgba;w.useAlpha||(l[3]=1);"lines"===a.drawMode&&w.useAlpha&&1>l[3]&&(l[3]/=10);"add"===c.boostBlending?(g.blendFunc(g.SRC_ALPHA,g.ONE),g.blendEquation(g.FUNC_ADD)):"mult"===c.boostBlending||"multiply"===c.boostBlending?g.blendFunc(g.DST_COLOR,g.ZERO):"darken"===c.boostBlending?(g.blendFunc(g.ONE,g.ONE),g.blendEquation(g.FUNC_MIN)):g.blendFuncSeparate(g.SRC_ALPHA,
g.ONE_MINUS_SRC_ALPHA,g.ONE,g.ONE_MINUS_SRC_ALPHA);k.reset();0<a.colorData.length&&(k.setUniform("hasColor",1),f=d(g,k),f.build(a.colorData,"aColor",4),f.bind());k.setColor(l);I(a.series.xAxis);m(a.series.yAxis);E(q,p);"points"===a.drawMode&&(c.marker&&c.marker.radius?k.setPointSize(2*c.marker.radius):k.setPointSize(1));k.setSkipTranslation(a.skipTranslation);"bubble"===a.series.type&&k.setBubbleUniforms(a.series,a.zMin,a.zMax);k.setDrawAsCircle(R[a.series.type]||!1);if(0<r||"line_strip"!==a.drawMode)for(r=
0;r<a.segments.length;r++)L.render(a.segments[r].from,a.segments[r].to,a.drawMode);if(a.hasMarkers&&A)for(c.marker&&c.marker.radius?k.setPointSize(2*c.marker.radius):k.setPointSize(10),k.setDrawAsCircle(!0),r=0;r<a.segments.length;r++)L.render(a.segments[r].from,a.segments[r].to,"POINTS")}});w.debug.timeRendering&&console.timeEnd("gl rendering");n&&n();a()}function M(a){r();if(a.renderer.forExport)return A(a);S?A(a):setTimeout(function(){M(a)},1)}var k=!1,L=!1,g=!1,K=0,F=0,N=!1,H=!1,B={},S=!1,z=[],
J={},W={column:!0,columnrange:!0,bar:!0,area:!0,arearange:!0},R={scatter:!0,bubble:!0},w={pointSize:1,lineWidth:1,fillColor:"#AA00AA",useAlpha:!0,usePreallocated:!1,useGPUTranslations:!1,debug:{timeRendering:!1,timeSeriesProcessing:!1,timeSetup:!1,timeBufferCopy:!1,timeKDTree:!1,showSkipSummary:!1}};return B={allocateBufferForSingleSeries:function(a){var b=0;w.usePreallocated&&(a.isSeriesBoosting&&(b=l(a)),L.allocate(b))},pushSeries:function(a){0<z.length&&z[z.length-1].hasMarkers&&(z[z.length-1].markerTo=
H.length);w.debug.timeSeriesProcessing&&console.time("building "+a.type+" series");z.push({segments:[],markerFrom:H.length,colorData:[],series:a,zMin:Number.MAX_VALUE,zMax:-Number.MAX_VALUE,hasMarkers:a.options.marker?!1!==a.options.marker.enabled:!1,showMarkers:!0,drawMode:{area:"lines",arearange:"lines",areaspline:"line_strip",column:"lines",columnrange:"lines",bar:"lines",line:"line_strip",scatter:"points",heatmap:"triangles",treemap:"triangles",bubble:"points"}[a.type]||"line_strip"});f(a,z[z.length-
1]);w.debug.timeSeriesProcessing&&console.timeEnd("building "+a.type+" series")},setSize:function(a,b){K===a&&F===b||!k||(K=a,F=b,k.bind(),k.setPMatrix([2/K,0,0,0,0,-(2/F),0,0,0,0,-2,0,-1,1,-1,1]))},inited:function(){return S},setThreshold:E,init:function(b,f){function e(a,b){var f={isReady:!1,texture:q.createElement("canvas"),handle:g.createTexture()},c=f.texture.getContext("2d");J[a]=f;f.texture.width=512;f.texture.height=512;c.mozImageSmoothingEnabled=!1;c.webkitImageSmoothingEnabled=!1;c.msImageSmoothingEnabled=
!1;c.imageSmoothingEnabled=!1;c.strokeStyle="rgba(255, 255, 255, 0)";c.fillStyle="#FFF";b(c);try{g.activeTexture(g.TEXTURE0),g.bindTexture(g.TEXTURE_2D,f.handle),g.texImage2D(g.TEXTURE_2D,0,g.RGBA,g.RGBA,g.UNSIGNED_BYTE,f.texture),g.texParameteri(g.TEXTURE_2D,g.TEXTURE_WRAP_S,g.CLAMP_TO_EDGE),g.texParameteri(g.TEXTURE_2D,g.TEXTURE_WRAP_T,g.CLAMP_TO_EDGE),g.texParameteri(g.TEXTURE_2D,g.TEXTURE_MAG_FILTER,g.LINEAR),g.texParameteri(g.TEXTURE_2D,g.TEXTURE_MIN_FILTER,g.LINEAR),g.bindTexture(g.TEXTURE_2D,
null),f.isReady=!0}catch(P){}}var m=0,l=["webgl","experimental-webgl","moz-webgl","webkit-3d"];S=!1;if(!b)return!1;for(w.debug.timeSetup&&console.time("gl setup");m<l.length&&!(g=b.getContext(l[m],{}));m++);if(g)f||a();else return!1;g.enable(g.BLEND);g.blendFunc(g.SRC_ALPHA,g.ONE_MINUS_SRC_ALPHA);g.disable(g.DEPTH_TEST);g.depthFunc(g.LESS);k=c(g);if(!k)return!1;L=d(g,k);e("circle",function(a){a.beginPath();a.arc(256,256,256,0,2*Math.PI);a.stroke();a.fill()});e("square",function(a){a.fillRect(0,0,
512,512)});e("diamond",function(a){a.beginPath();a.moveTo(256,0);a.lineTo(512,256);a.lineTo(256,512);a.lineTo(0,256);a.lineTo(256,0);a.fill()});e("triangle",function(a){a.beginPath();a.moveTo(0,512);a.lineTo(256,0);a.lineTo(512,512);a.lineTo(0,512);a.fill()});e("triangle-down",function(a){a.beginPath();a.moveTo(0,0);a.lineTo(256,512);a.lineTo(512,0);a.lineTo(0,0);a.fill()});S=!0;w.debug.timeSetup&&console.timeEnd("gl setup");return!0},render:M,settings:w,valid:function(){return!1!==g},clear:r,flush:a,
setXAxis:I,setYAxis:m,data:N,gl:function(){return g},allocateBuffer:function(a){var b=0;w.usePreallocated&&(a.series.forEach(function(a){a.isSeriesBoosting&&(b+=l(a))}),L.allocate(b))},destroy:function(){a();L.destroy();k.destroy();g&&(v(J,function(a){J[a].handle&&g.deleteTexture(J[a].handle)}),g.canvas.width=1,g.canvas.height=1)},setOptions:function(a){p(!0,w,a)}}}});n(c,"modules/boost/boost-attach.js",[c["parts/Globals.js"],c["modules/boost/wgl-renderer.js"]],function(c,y){var d=c.win.document,
e=d.createElement("canvas");return function(h,v){var q=h.chartWidth,p=h.chartHeight,b=h,t=h.seriesGroup||v.group,n=d.implementation.hasFeature("www.http://w3.org/TR/SVG11/feature#Extensibility","1.1");b=h.isChartSeriesBoosting()?h:v;n=!1;b.renderTarget||(b.canvas=e,h.renderer.forExport||!n?(b.renderTarget=h.renderer.image("",0,0,q,p).addClass("highcharts-boost-canvas").add(t),b.boostClear=function(){b.renderTarget.attr({href:""})},b.boostCopy=function(){b.boostResizeTarget();b.renderTarget.attr({href:b.canvas.toDataURL("image/png")})}):
(b.renderTargetFo=h.renderer.createElement("foreignObject").add(t),b.renderTarget=d.createElement("canvas"),b.renderTargetCtx=b.renderTarget.getContext("2d"),b.renderTargetFo.element.appendChild(b.renderTarget),b.boostClear=function(){b.renderTarget.width=b.canvas.width;b.renderTarget.height=b.canvas.height},b.boostCopy=function(){b.renderTarget.width=b.canvas.width;b.renderTarget.height=b.canvas.height;b.renderTargetCtx.drawImage(b.canvas,0,0)}),b.boostResizeTarget=function(){q=h.chartWidth;p=h.chartHeight;
(b.renderTargetFo||b.renderTarget).attr({x:0,y:0,width:q,height:p}).css({pointerEvents:"none",mixedBlendMode:"normal",opacity:1});b instanceof c.Chart&&b.markerGroup.translate(h.plotLeft,h.plotTop)},b.boostClipRect=h.renderer.clipRect(),(b.renderTargetFo||b.renderTarget).clip(b.boostClipRect),b instanceof c.Chart&&(b.markerGroup=b.renderer.g().add(t),b.markerGroup.translate(v.xAxis.pos,v.yAxis.pos)));b.canvas.width=q;b.canvas.height=p;b.boostClipRect.attr(h.getBoostClipRect(b));b.boostResizeTarget();
b.boostClear();b.ogl||(b.ogl=y(function(){b.ogl.settings.debug.timeBufferCopy&&console.time("buffer copy");b.boostCopy();b.ogl.settings.debug.timeBufferCopy&&console.timeEnd("buffer copy")}),b.ogl.init(b.canvas)||c.error("[highcharts boost] - unable to init WebGL renderer"),b.ogl.setOptions(h.options.boost||{}),b instanceof c.Chart&&b.ogl.allocateBuffer(h));b.ogl.setSize(q,p);return b.ogl}});n(c,"modules/boost/boost-utils.js",[c["parts/Globals.js"],c["modules/boost/boostable-map.js"],c["modules/boost/boost-attach.js"]],
function(c,y,d){function e(){for(var b=[],c=0;c<arguments.length;c++)b[c]=arguments[c];var f=-Number.MAX_VALUE;b.forEach(function(a){if("undefined"!==typeof a&&null!==a&&"undefined"!==typeof a.length&&0<a.length)return f=a.length,!0});return f}function h(b,c,f){b&&c.renderTarget&&c.canvas&&!(f||c.chart).isChartSeriesBoosting()&&b.render(f||c.chart)}function v(b,c){b&&c.renderTarget&&c.canvas&&!c.chart.isChartSeriesBoosting()&&b.allocateBufferForSingleSeries(c)}function q(c,d,f,a,e,m){e=e||0;a=a||
3E3;for(var l=e+a,h=!0;h&&e<l&&e<c.length;)h=d(c[e],e),++e;h&&(e<c.length?m?q(c,d,f,a,e,m):b.requestAnimationFrame?b.requestAnimationFrame(function(){q(c,d,f,a,e)}):setTimeout(function(){q(c,d,f,a,e)}):f&&f())}function p(){var c=0,e,f=["webgl","experimental-webgl","moz-webgl","webkit-3d"],a=!1;if("undefined"!==typeof b.WebGLRenderingContext)for(e=t.createElement("canvas");c<f.length;c++)try{if(a=e.getContext(f[c]),"undefined"!==typeof a&&null!==a)return!0}catch(I){}return!1}var b=c.win,t=b.document,
n=c.pick,B={patientMax:e,boostEnabled:function(b){return n(b&&b.options&&b.options.boost&&b.options.boost.enabled,!0)},shouldForceChartSeriesBoosting:function(b){var c=0,f=0,a=n(b.options.boost&&b.options.boost.allowForce,!0);if("undefined"!==typeof b.boostForceChartBoost)return b.boostForceChartBoost;if(1<b.series.length)for(var d=0;d<b.series.length;d++){var m=b.series[d];0!==m.options.boostThreshold&&!1!==m.visible&&"heatmap"!==m.type&&(y[m.type]&&++f,e(m.processedXData,m.options.data,m.points)>=
(m.options.boostThreshold||Number.MAX_VALUE)&&++c)}b.boostForceChartBoost=a&&(f===b.series.length&&0<c||5<c);return b.boostForceChartBoost},renderIfNotSeriesBoosting:h,allocateIfNotSeriesBoosting:v,eachAsync:q,hasWebGLSupport:p,pointDrawHandler:function(b){var c=!0;this.chart.options&&this.chart.options.boost&&(c="undefined"===typeof this.chart.options.boost.enabled?!0:this.chart.options.boost.enabled);if(!c||!this.isSeriesBoosting)return b.call(this);this.chart.isBoosting=!0;if(b=d(this.chart,this))v(b,
this),b.pushSeries(this);h(b,this)}};c.hasWebGLSupport=p;return B});n(c,"modules/boost/boost-init.js",[c["parts/Globals.js"],c["parts/Utilities.js"],c["modules/boost/boost-utils.js"],c["modules/boost/boost-attach.js"]],function(c,n,d,H){var e=n.extend,v=c.addEvent,q=c.fireEvent,p=c.Series,b=c.seriesTypes,t=c.wrap,y=function(){},B=d.eachAsync,l=d.pointDrawHandler,r=d.allocateIfNotSeriesBoosting,f=d.renderIfNotSeriesBoosting,a=d.shouldForceChartSeriesBoosting,I;return function(){e(p.prototype,{renderCanvas:function(){function a(a,
b){var c=!1,f="undefined"===typeof h.index,e=!0;if(!f){if(na){var d=a[0];var m=a[1]}else d=a,m=t[b];ka?(na&&(m=a.slice(1,3)),c=m[0],m=m[1]):la&&(d=a.x,m=a.stackY,c=m-a.y);va||(e=m>=z&&m<=J);if(null!==m&&d>=v&&d<=M&&e)if(a=g.toPixels(d,!0),w){if(void 0===P||a===R){ka||(c=m);if(void 0===Z||m>ca)ca=m,Z=b;if(void 0===P||c<ba)ba=c,P=b}a!==R&&(void 0!==P&&(m=l.toPixels(ca,!0),C=l.toPixels(ba,!0),da(a,m,Z),C!==m&&da(a,C,P)),P=Z=void 0,R=a)}else m=Math.ceil(l.toPixels(m,!0)),da(a,m,b)}return!f}function b(){q(c,
"renderedCanvas");delete c.buildKDTree;c.buildKDTree();pa.debug.timeKDTree&&console.timeEnd("kd tree building")}var c=this,d=c.options||{},e=!1,h=c.chart,g=this.xAxis,l=this.yAxis,p=d.xData||c.processedXData,t=d.yData||c.processedYData,n=d.data;e=g.getExtremes();var v=e.min,M=e.max;e=l.getExtremes();var z=e.min,J=e.max,W={},R,w=!!c.sampling,T=!1!==d.enableMouseTracking,C=l.getThreshold(d.threshold),ka=c.pointArrayMap&&"low,high"===c.pointArrayMap.join(","),la=!!d.stacking,ma=c.cropStart||0,va=c.requireSorting,
na=!p,ba,ca,P,Z,wa="x"===d.findNearestPointBy,oa=this.xData||this.options.xData||this.processedXData||!1,da=function(a,b,c){a=Math.ceil(a);I=wa?a:a+","+b;T&&!W[I]&&(W[I]=!0,h.inverted&&(a=g.len-a,b=l.len-b),xa.push({x:oa?oa[ma+c]:!1,clientX:a,plotX:a,plotY:b,i:ma+c}))};e=H(h,c);h.isBoosting=!0;var pa=e.settings;if(this.visible){if(this.points||this.graph)this.animate=null,this.destroyGraphics();h.isChartSeriesBoosting()?(this.markerGroup&&this.markerGroup!==h.markerGroup&&this.markerGroup.destroy(),
this.markerGroup=h.markerGroup,this.renderTarget&&(this.renderTarget=this.renderTarget.destroy())):(this.markerGroup===h.markerGroup&&(this.markerGroup=void 0),this.markerGroup=c.plotGroup("markerGroup","markers",!0,1,h.seriesGroup));var xa=this.points=[];c.buildKDTree=y;e&&(r(e,this),e.pushSeries(c),f(e,this,h));h.renderer.forExport||(pa.debug.timeKDTree&&console.time("kd tree building"),B(la?c.data:p||n,a,b))}}});["heatmap","treemap"].forEach(function(a){b[a]&&t(b[a].prototype,"drawPoints",l)});
b.bubble&&(delete b.bubble.prototype.buildKDTree,t(b.bubble.prototype,"markerAttribs",function(a){return this.isSeriesBoosting?!1:a.apply(this,[].slice.call(arguments,1))}));b.scatter.prototype.fill=!0;e(b.area.prototype,{fill:!0,fillOpacity:!0,sampling:!0});e(b.column.prototype,{fill:!0,sampling:!0});c.Chart.prototype.callbacks.push(function(b){v(b,"predraw",function(){b.boostForceChartBoost=void 0;b.boostForceChartBoost=a(b);b.isBoosting=!1;!b.isChartSeriesBoosting()&&b.didBoost&&(b.didBoost=!1);
b.boostClear&&b.boostClear();b.canvas&&b.ogl&&b.isChartSeriesBoosting()&&(b.didBoost=!0,b.ogl.allocateBuffer(b));b.markerGroup&&b.xAxis&&0<b.xAxis.length&&b.yAxis&&0<b.yAxis.length&&b.markerGroup.translate(b.xAxis[0].pos,b.yAxis[0].pos)});v(b,"render",function(){b.ogl&&b.isChartSeriesBoosting()&&b.ogl.render(b)})})}});n(c,"modules/boost/boost-overrides.js",[c["parts/Globals.js"],c["parts/Utilities.js"],c["modules/boost/boost-utils.js"],c["modules/boost/boostables.js"],c["modules/boost/boostable-map.js"]],
function(c,n,d,H,h){var e=n.isNumber,q=d.boostEnabled,p=d.shouldForceChartSeriesBoosting;n=c.Chart;var b=c.Series;d=c.Point;var t=c.seriesTypes,y=c.addEvent,B=c.pick,l=c.wrap,r=c.getOptions().plotOptions;n.prototype.isChartSeriesBoosting=function(){return B(this.options.boost&&this.options.boost.seriesThreshold,50)<=this.series.length||p(this)};n.prototype.getBoostClipRect=function(b){var a={x:this.plotLeft,y:this.plotTop,width:this.plotWidth,height:this.plotHeight};b===this&&this.yAxis.forEach(function(b){a.y=
Math.min(b.pos,a.y);a.height=Math.max(b.pos-this.plotTop+b.len,a.height)},this);return a};b.prototype.getPoint=function(b){var a=b,c=this.xData||this.options.xData||this.processedXData||!1;!b||b instanceof this.pointClass||(a=(new this.pointClass).init(this,this.options.data[b.i],c?c[b.i]:void 0),a.category=B(this.xAxis.categories?this.xAxis.categories[a.x]:a.x,a.x),a.dist=b.dist,a.distX=b.distX,a.plotX=b.plotX,a.plotY=b.plotY,a.index=b.i);return a};l(b.prototype,"searchPoint",function(b){return this.getPoint(b.apply(this,
[].slice.call(arguments,1)))});l(d.prototype,"haloPath",function(b){var a=this.series,c=this.plotX,f=this.plotY,d=a.chart.inverted;a.isSeriesBoosting&&d&&(this.plotX=a.yAxis.len-f,this.plotY=a.xAxis.len-c);var e=b.apply(this,Array.prototype.slice.call(arguments,1));a.isSeriesBoosting&&d&&(this.plotX=c,this.plotY=f);return e});l(b.prototype,"markerAttribs",function(b,a){var c=a.plotX,f=a.plotY,d=this.chart.inverted;this.isSeriesBoosting&&d&&(a.plotX=this.yAxis.len-f,a.plotY=this.xAxis.len-c);var e=
b.apply(this,Array.prototype.slice.call(arguments,1));this.isSeriesBoosting&&d&&(a.plotX=c,a.plotY=f);return e});y(b,"destroy",function(){var b=this,a=b.chart;a.markerGroup===b.markerGroup&&(b.markerGroup=null);a.hoverPoints&&(a.hoverPoints=a.hoverPoints.filter(function(a){return a.series===b}));a.hoverPoint&&a.hoverPoint.series===b&&(a.hoverPoint=null)});l(b.prototype,"getExtremes",function(b){if(!this.isSeriesBoosting||!this.hasExtremes||!this.hasExtremes())return b.apply(this,Array.prototype.slice.call(arguments,
1))});["translate","generatePoints","drawTracker","drawPoints","render"].forEach(function(c){function a(a){var b=this.options.stacking&&("translate"===c||"generatePoints"===c);if(!this.isSeriesBoosting||b||!q(this.chart)||"heatmap"===this.type||"treemap"===this.type||!h[this.type]||0===this.options.boostThreshold)a.call(this);else if(this[c+"Canvas"])this[c+"Canvas"]()}l(b.prototype,c,a);"translate"===c&&"column bar arearange columnrange heatmap treemap".split(" ").forEach(function(b){t[b]&&l(t[b].prototype,
c,a)})});l(b.prototype,"processData",function(b){function a(a){return f.chart.isChartSeriesBoosting()||(a?a.length:0)>=(f.options.boostThreshold||Number.MAX_VALUE)}var f=this,d=this.options.data;q(this.chart)&&h[this.type]?(a(d)&&"heatmap"!==this.type&&"treemap"!==this.type&&!this.options.stacking&&this.hasExtremes&&this.hasExtremes(!0)||(b.apply(this,Array.prototype.slice.call(arguments,1)),d=this.processedXData),(this.isSeriesBoosting=a(d))?(d=this.getFirstValidPoint(this.options.data),e(d)||c.isArray(d)||
c.error(12,!1,this.chart),this.enterBoost()):this.exitBoost&&this.exitBoost()):b.apply(this,Array.prototype.slice.call(arguments,1))});y(b,"hide",function(){this.canvas&&this.renderTarget&&(this.ogl&&this.ogl.clear(),this.boostClear())});b.prototype.enterBoost=function(){this.alteredByBoost=[];["allowDG","directTouch","stickyTracking"].forEach(function(b){this.alteredByBoost.push({prop:b,val:this[b],own:Object.hasOwnProperty.call(this,b)})},this);this.directTouch=this.allowDG=!1;this.stickyTracking=
!0;this.animate=null;this.labelBySeries&&(this.labelBySeries=this.labelBySeries.destroy())};b.prototype.exitBoost=function(){(this.alteredByBoost||[]).forEach(function(b){b.own?this[b.prop]=b.val:delete this[b.prop]},this);this.boostClear&&this.boostClear()};b.prototype.hasExtremes=function(b){var a=this.options,c=this.xAxis&&this.xAxis.options,d=this.yAxis&&this.yAxis.options,f=this.colorAxis&&this.colorAxis.options;return a.data.length>(a.boostThreshold||Number.MAX_VALUE)&&e(d.min)&&e(d.max)&&(!b||
e(c.min)&&e(c.max))&&(!f||e(f.min)&&e(f.max))};b.prototype.destroyGraphics=function(){var b=this,a=this.points,c,d;if(a)for(d=0;d<a.length;d+=1)(c=a[d])&&c.destroyElements&&c.destroyElements();["graph","area","tracker"].forEach(function(a){b[a]&&(b[a]=b[a].destroy())})};H.forEach(function(b){r[b]&&(r[b].boostThreshold=5E3,r[b].boostData=[],t[b].prototype.fillOpacity=!0)})});n(c,"modules/boost/named-colors.js",[c["parts/Globals.js"]],function(c){var e={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",
aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",
darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1e90ff",feldspar:"#d19275",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",
honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslateblue:"#8470ff",lightslategray:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",
lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",
orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",
springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",violetred:"#d02090",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"};return c.Color.prototype.names=e});n(c,"modules/boost/boost.js",[c["parts/Globals.js"],c["modules/boost/boost-utils.js"],c["modules/boost/boost-init.js"]],function(c,n,d){n=n.hasWebGLSupport;n()?d():"undefined"!==typeof c.initCanvasBoost?c.initCanvasBoost():
c.error(26)});n(c,"masters/modules/boost.src.js",[],function(){})});
//# sourceMappingURL=boost.js.map