<?php
/**
 * Clase util arrays
 *
 * @author     Willy
 * @version    SVN: $Id: arrayClass.class.php,v 1.7 2007/11/26 17:29:36 william.taype Exp $
 */
class arrayClass{
  
  /**
   * Devuelve un array, como Key = valor del array1; value = value del array2
   *
   * @param Array $array1
   * @param Array $array2
   * @return Array
   * 
   * @example 
   *  
   *  $a_Lista1 = arrayClass::arrayIntersecMap($a_Items, array("cantidad"=>$a_CantidadItems, "costoFinanciero"=>$a_CostoFinancieroItems, "costoContable"=>$a_CostoContableItems));
   *  $a_lista2 = arrayClass::arrayIntersecMap($a_Items, $a_CantidadItems);
   * 
   */
	public static function arrayIntersecMap($indiceArray, $valores){

    $array = array();
	  $valorTmp = array();
	  
	  if(!is_array($indiceArray)) : return false; endif;

	  foreach ($indiceArray as $indice => $valor){
	    
	    $control = true;
	    $arrayTmp = array();
	    foreach ($valores as $indice2 => $valor2){
	      if(!is_array($valor2)){
	        $control = false;
	        break;
	      }
	      if( sizeof($valor2) > 0 ){
	        $arrayTmp[$indice2] = $valor2[$indice];
	      }
	    }
	    $valorTmp = $arrayTmp;
	    
	    if(!$control){
	      $valorTmp = key_exists($indice,$valores)?$valores[$indice]:null;
	    }

      $array += array($valor => $valorTmp);
	    
	  }
	  
	  return $array;
	  
	}
	
	public static function implode_keys($char=",", $array){
	  if(is_array($array)){
	    $a_keys = array();
	    foreach ($array as $iKey => $values){
	      array_push($a_keys, $iKey);
	    }
	    return implode($char, $a_keys);
	  }
	}
	
	public static function implode_key_value($char=",", $array){
	  if(is_array($array)){
	    $a_keys = array();
	    foreach ($array as $iKey => $values){
	      array_push($a_keys, $iKey."='".$values."'");
	    }
	    return implode($char, $a_keys);
	  }
	}
  
}