<?php
/**
 * Clase Base FN para BaseCrUtilidadFN
 *
 * @package    
 * @subpackage BaseCrUtilidadFN
 * @author     Willy
 * @version    SVN:: BaseCrUtilidadFN.class.php,v 1.1 2016-11-11 13:29:08 william.taype Exp $
 */
class BaseCrUtilidadFN extends CrUtilidadBN
{
  private static $fieldNames = array (
    'IdSucursal'=>'IdSucursal', 'IdMercado'=>'IdMercado', 'IdRepresentante'=>'IdRepresentante', 'IdPrestamo'=>'IdPrestamo', 'FechaCancelacion'=>'FechaCancelacion', 'FechaInicio'=>'FechaInicio', 'FechaVencimiento'=>'FechaVencimiento', 'IdCliente'=>'IdCliente', 'MontoTotal'=>'MontoTotal', 'Ganancia'=>'Ganancia', 'Sucursal'=>'Sucursal', 'Mercado'=>'Mercado', 'Representante'=>'Representante', 'Cliente'=>'Cliente', 'GastoAdministrativo'=>'GastoAdministrativo'  
  );

  public function select()
  {
    try
    {
      $tamPag = !property_exists($this, 'tamPag')?9999:$this->tamPag;
      $pagina = !property_exists($this, 'page')||$this->page==""?1:$this->page;
      $numeroRegistros = $this->selectNumRows();
      $limitInf = ($pagina-1)*$tamPag;

      $where = $this->buildConsult();
      $orden = $this->buildOrderByField();

      $con = Conexion::getConexion();
      $sql = "SELECT IdSucursal, IdMercado, IdRepresentante, IdPrestamo, FechaCancelacion, FechaInicio, FechaVencimiento, IdCliente, MontoTotal, Ganancia, Utilidad, Sucursal, Mercado, Representante, Cliente, GastoAdministrativo FROM cr_utilidad WHERE 1 ".$where." ".$orden."  LIMIT ".$limitInf.",".$tamPag;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
      $num_rows = mysql_num_rows($result);
      $a_tmp = array();
      if($num_rows>0){
        while ($o_valor = mysql_fetch_object($result)) {
          $a_tmp[] = $this->insertObjectBN($o_valor);
        }
      }
      
      return count($a_tmp)>0?$a_tmp:null;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function selectNumRows()
  {
    try
    {
      $where = $this->buildConsult();

      $con = Conexion::getConexion();
      $sql = "SELECT IdSucursal, IdMercado, IdRepresentante, IdPrestamo, FechaCancelacion, FechaInicio, FechaVencimiento, IdCliente, MontoTotal,MontoMora, Ganancia, Sucursal, Mercado, Representante, Cliente, GastoAdministrativo FROM cr_utilidad WHERE 1 ".$where;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
      $num_rows = mysql_num_rows($result);
      
      return $num_rows;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildConsult()
  {
    try
    {
      $where = "";

      if($this->getIdSucursal()){ $where .= " AND idsucursal = '".$this->getIdSucursal()."'"; }
      if($this->getIdMercado()){ $where .= " AND idmercado = '".$this->getIdMercado()."'"; }
      if($this->getIdRepresentante()){ $where .= " AND idrepresentante = '".$this->getIdRepresentante()."'"; }
      if($this->getIdPrestamo()){ $where .= " AND idprestamo = '".$this->getIdPrestamo()."'"; }
      if($this->getFechaCancelacion()){ $where .= " AND fechacancelacion = '".$this->getFechaCancelacion()."'"; }
      if($this->getFechaInicio()){ $where .= " AND fechainicio = '".$this->getFechaInicio()."'"; }
      if($this->getFechaVencimiento()){ $where .= " AND fechavencimiento = '".$this->getFechaVencimiento()."'"; }
      if($this->getIdCliente()){ $where .= " AND idcliente = '".$this->getIdCliente()."'"; }
      if($this->getMontoTotal()){ $where .= " AND montototal = '".$this->getMontoTotal()."'"; }
      if($this->getGanancia()){ $where .= " AND ganancia = '".$this->getGanancia()."'"; }
      if($this->getSucursal()){ $where .= " AND sucursal = '".$this->getSucursal()."'"; }
      if($this->getMercado()){ $where .= " AND mercado = '".$this->getMercado()."'"; }
      if($this->getRepresentante()){ $where .= " AND representante = '".$this->getRepresentante()."'"; }
      if($this->getCliente()){ $where .= " AND cliente = '".$this->getCliente()."'"; }
      if($this->getGastoAdministrativo()){ $where .= " AND gastoadministrativo = '".$this->getGastoAdministrativo()."'"; }
      return $where;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildOrderByField()
  {
    try
    {
      $order_by = "";

      if(property_exists($this,'sortCampos')){
      if($this->sortCampos != ""){
        $a_valCampos = explode(";", $this->sortCampos);
        $a_valtype   = explode(";", $this->sortType);
        $order_by = " ORDER BY ";
        $a_order = array();
        foreach ($a_valCampos as $key => $val){
          $sTmpOrder = "";
          if(array_key_exists($val, self::$fieldNames)){
            $sTmpOrder .= self::$fieldNames[$val];
            switch ($a_valtype[$key]){
              case 1: $sTmpOrder .= " ASC"; break;
              case 2: $sTmpOrder .= " DESC"; break;
            }
            $a_order[] = $sTmpOrder;
          }
        }
        $order_by .= implode(", ", $a_order);
      }
      }
      return $order_by;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* B�squeda del registro por la llave primaria */
  public function selectByPK()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IdSucursal, IdMercado, IdRepresentante, IdPrestamo, FechaCancelacion, FechaInicio, FechaVencimiento, IdCliente, MontoTotal, Ganancia, Sucursal, Mercado, Representante, Cliente, GastoAdministrativo FROM cr_utilidad WHERE 1 AND IdSucursal='".$this->getIdSucursal()."' AND IdMercado='".$this->getIdMercado()."' AND IdRepresentante='".$this->getIdRepresentante()."' AND IdPrestamo='".$this->getIdPrestamo()."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
      $o_Propel = $result ? mysql_fetch_object($result) : null;
      

      return $o_Propel?$this->insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  public function insertObjectBN($o_propel){
    $o_BaseCrUtilidadFN = new BaseCrUtilidadFN();
    $o_BaseCrUtilidadFN->setIdSucursal($o_propel->IdSucursal);
    $o_BaseCrUtilidadFN->setIdMercado($o_propel->IdMercado);
    $o_BaseCrUtilidadFN->setIdRepresentante($o_propel->IdRepresentante);
    $o_BaseCrUtilidadFN->setIdPrestamo($o_propel->IdPrestamo);
    $o_BaseCrUtilidadFN->setFechaCancelacion($o_propel->FechaCancelacion);
    $o_BaseCrUtilidadFN->setFechaInicio($o_propel->FechaInicio);
    $o_BaseCrUtilidadFN->setFechaVencimiento($o_propel->FechaVencimiento);
    $o_BaseCrUtilidadFN->setIdCliente($o_propel->IdCliente);
    $o_BaseCrUtilidadFN->setMontoTotal($o_propel->MontoTotal);
    $o_BaseCrUtilidadFN->setMontoMora($o_propel->MontoMora);
    $o_BaseCrUtilidadFN->setGanancia($o_propel->Ganancia);
    $o_BaseCrUtilidadFN->setUtilidad($o_propel->Utilidad);
    $o_BaseCrUtilidadFN->setSucursal($o_propel->Sucursal);
    $o_BaseCrUtilidadFN->setMercado($o_propel->Mercado);
    $o_BaseCrUtilidadFN->setRepresentante($o_propel->Representante);
    $o_BaseCrUtilidadFN->setCliente($o_propel->Cliente);
    $o_BaseCrUtilidadFN->setGastoAdministrativo($o_propel->GastoAdministrativo);
    return $o_BaseCrUtilidadFN;
  }
}