<?php
/**
 * Clase Base DP para BaseCrUtilidadSucMerDP
 *
 * @package    
 * @subpackage BaseCrUtilidadSucMerDP
 * @author     Willy
 * @version    SVN:: BaseCrUtilidadSucMerDP.class.php,v 1.1 2016-11-11 13:29:27 william.taype Exp $
 */
abstract class BaseCrUtilidadSucMerDP extends CrUtilidadSucMerBN
{
  /* Nmero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof CrUtilidadSucMerBN )
    {
      $o_CrUtilidadSucMerBN = $bSetDefault;
      if($o_CrUtilidadSucMerBN->getIdSucursal()) : $this->setIdSucursal($o_CrUtilidadSucMerBN->getIdSucursal()); endif;
      if($o_CrUtilidadSucMerBN->getIdMercado()) : $this->setIdMercado($o_CrUtilidadSucMerBN->getIdMercado()); endif;
    }
  }

  /* Obtiene el nmero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IF(MAX(IdSucursal),(MAX(IdSucursal)+1), 1) AS Maximo FROM cr_utilidad_suc_mer;";
      $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
      $result = mysql_query($sql, $oLink);
      $row = mysql_fetch_array($result);
      $this->setIdSucursal($row[0]);

      if($this->getIdSucursal() && $this->getIdMercado()){
        $a_Fields = array();

        if($this->getIdSucursal()) : $a_Fields['IdSucursal'] = ($this->getIdSucursal()); endif;
        if($this->getIdMercado()) : $a_Fields['IdMercado'] = ($this->getIdMercado()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO cr_utilidad_suc_mer (".$sStringField.") VALUES (".$sStringValue.");";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdSucursal() && $this->getIdMercado())
      {
        $a_Fields = array();

        if($this->getIdSucursal()) : $a_Fields['IdSucursal'] = ($this->getIdSucursal()); endif;
        if($this->getIdMercado()) : $a_Fields['IdMercado'] = ($this->getIdMercado()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE cr_utilidad_suc_mer SET ".$sStringField." WHERE 1 AND IdSucursal='".$this->getIdSucursal()."' AND IdMercado='".$this->getIdMercado()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdSucursal() && $this->getIdMercado())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM cr_utilidad_suc_mer WHERE 1 AND IdSucursal='".$this->getIdSucursal()."' AND IdMercado='".$this->getIdMercado()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* Bsqueda del registro por la llave primaria */
  public static function selectByPK($vIdSucursal, $vIdMercado)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IdSucursal, IdMercado FROM cr_utilidad_suc_mer WHERE 1 AND IdSucursal='".$vIdSucursal."' AND IdMercado='".$vIdMercado."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
      $o_Propel = $result ? mysql_fetch_object($result) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con mtodos de acceso */
  private function insertObjectBN($o_propel){
    $o_CrUtilidadSucMerDP = new CrUtilidadSucMerDP();
    $o_CrUtilidadSucMerDP->setIdSucursal($o_propel->IdSucursal);
    $o_CrUtilidadSucMerDP->setIdMercado($o_propel->IdMercado);
    return $o_CrUtilidadSucMerDP;
  }
}