<?php
/**
 * Clase Base DP para BaseCrUtilidadMerRepDP
 *
 * @package    
 * @subpackage BaseCrUtilidadMerRepDP
 * @author     Willy
 * @version    SVN:: BaseCrUtilidadMerRepDP.class.php,v 1.1 2016-11-11 13:29:27 william.taype Exp $
 */
abstract class BaseCrUtilidadMerRepDP extends CrUtilidadMerRepBN
{
  /* Nmero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof CrUtilidadMerRepBN )
    {
      $o_CrUtilidadMerRepBN = $bSetDefault;
      if($o_CrUtilidadMerRepBN->getIdMercado()) : $this->setIdMercado($o_CrUtilidadMerRepBN->getIdMercado()); endif;
      if($o_CrUtilidadMerRepBN->getIdColaborador()) : $this->setIdColaborador($o_CrUtilidadMerRepBN->getIdColaborador()); endif;
    }
  }

  /* Obtiene el nmero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IF(MAX(IdMercado),(MAX(IdMercado)+1), 1) AS Maximo FROM cr_utilidad_mer_rep;";
      $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
      $result = mysql_query($sql, $oLink);
      $row = mysql_fetch_array($result);
      $this->setIdMercado($row[0]);

      if($this->getIdMercado() && $this->getIdColaborador()){
        $a_Fields = array();

        if($this->getIdMercado()) : $a_Fields['IdMercado'] = ($this->getIdMercado()); endif;
        if($this->getIdColaborador()) : $a_Fields['IdColaborador'] = ($this->getIdColaborador()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO cr_utilidad_mer_rep (".$sStringField.") VALUES (".$sStringValue.");";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdMercado() && $this->getIdColaborador())
      {
        $a_Fields = array();

        if($this->getIdMercado()) : $a_Fields['IdMercado'] = ($this->getIdMercado()); endif;
        if($this->getIdColaborador()) : $a_Fields['IdColaborador'] = ($this->getIdColaborador()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE cr_utilidad_mer_rep SET ".$sStringField." WHERE 1 AND IdMercado='".$this->getIdMercado()."' AND IdColaborador='".$this->getIdColaborador()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdMercado() && $this->getIdColaborador())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM cr_utilidad_mer_rep WHERE 1 AND IdMercado='".$this->getIdMercado()."' AND IdColaborador='".$this->getIdColaborador()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* Bsqueda del registro por la llave primaria */
  public static function selectByPK($vIdMercado, $vIdColaborador)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IdMercado, IdColaborador FROM cr_utilidad_mer_rep WHERE 1 AND IdMercado='".$vIdMercado."' AND IdColaborador='".$vIdColaborador."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
      $o_Propel = $result ? mysql_fetch_object($result) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con mtodos de acceso */
  private function insertObjectBN($o_propel){
    $o_CrUtilidadMerRepDP = new CrUtilidadMerRepDP();
    $o_CrUtilidadMerRepDP->setIdMercado($o_propel->IdMercado);
    $o_CrUtilidadMerRepDP->setIdColaborador($o_propel->IdColaborador);
    return $o_CrUtilidadMerRepDP;
  }
}