<?php

/**
 * Clase Dispacher para Rol
 *
 * @package    IM
 * @subpackage RolDP
 * @author     Willy
 * @version    SVN: $Id: RolDP.class.php,v 1.1 2008/02/07 17:43:32 william.taype Exp $
 */
class RolDP implements interfaceDP {

  protected $o_Bean;
  
  /**
  * Constructor donde asigna a un atributo el objeto RolBean
  *
  * @param RolBean $o_RolBean
  */
  public function __construct(RolBean $o_RolBean){
  
    $this->o_Bean = $o_RolBean;
    
  }
  
  /**
  * Retorna el objeto RolBean
  *
  * @return Object
  */
  protected function getObjetoBean(){
  
    if(!$this->o_Bean){
        $this->o_Bean = new RolBean();
    }        
    return $this->o_Bean;
    
  }
  
  /**
  * Ingresa un nuevo registro
  *
  * @return IdGenerado
  */
  public function save(){

    if($this->getObjetoBean()->getRolId()){
      
      $a_Fields = array();

      if($this->getObjetoBean()->getRolId()) : $a_Fields['role_id'] = ($this->getObjetoBean()->getRolId()); endif;
      if($this->getObjetoBean()->getDescripcion()) : $a_Fields['role_desc'] = ($this->getObjetoBean()->getDescripcion()); endif;
      if($this->getObjetoBean()->getTareaId()) : $a_Fields['start_task_id'] = ($this->getObjetoBean()->getTareaId()); endif;
      if($this->getObjetoBean()->getAccesoGlobal()) : $a_Fields['global_access'] = ($this->getObjetoBean()->getAccesoGlobal()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['created_date'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['created_user'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaActualizacion()) : $a_Fields['revised_date'] = ($this->getObjetoBean()->getFechaActualizacion()); endif;
      if($this->getObjetoBean()->getUsuarioActualizacion()) : $a_Fields['revised_user'] = ($this->getObjetoBean()->getUsuarioActualizacion()); endif;
      
      $sStringField = arrayClass::implode_keys(',', $a_Fields);
      $sStringValue = "'".implode("','", $a_Fields)."'";
      
      $sql = "INSERT INTO mnu_role (".$sStringField.") 
                            VALUES (".$sStringValue.")";
      $result   = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      
      $iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

    }else{
      return false;
    }
    
  }
  
  /**
  * Modifica un nuevo registro
  *
  * @return IdGenerado
  */
  public function update() {

    if($this->getObjetoBean()->getRolId()){

      $a_Fields = array();

      if($this->getObjetoBean()->getRolId()) : $a_Fields['role_id'] = ($this->getObjetoBean()->getRolId()); endif;
      if($this->getObjetoBean()->getDescripcion()) : $a_Fields['role_desc'] = ($this->getObjetoBean()->getDescripcion()); endif;
      if($this->getObjetoBean()->getTareaId()) : $a_Fields['start_task_id'] = ($this->getObjetoBean()->getTareaId()); endif;
      if($this->getObjetoBean()->getAccesoGlobal()) : $a_Fields['global_access'] = ($this->getObjetoBean()->getAccesoGlobal()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['created_date'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['created_user'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaActualizacion()) : $a_Fields['revised_date'] = ($this->getObjetoBean()->getFechaActualizacion()); endif;
      if($this->getObjetoBean()->getUsuarioActualizacion()) : $a_Fields['revised_user'] = ($this->getObjetoBean()->getUsuarioActualizacion()); endif;
      
      $sString = arrayClass::implode_key_value(",", $a_Fields);
      
      $sql = "UPDATE mnu_role SET 
                    ".$sString."
              WHERE role_id = '".$this->getObjetoBean()->getRolId()."'";
      $result   = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      
      $iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

    }else{
      return false;
    }
    
  }
  
  /**
  * Elimina registro
  *
  * @return Boolean
  */
  public function delete(){
    /*
      $o_Rol = new Rol();
      
      if($this->getObjetoBean()->getTransfId()){
          $o_Rol->setTransfId($this->getObjetoBean()->getTransfId());
      }
      $iResultDelete = $o_Rol->delete();
      if($iResultDelete > 0){
          return true;
      }else{
          return false;
      }    
    */
  }
  /**
  * Selecciona un nuevo registro
  *
  * @return IdGenerado
  */
  public function select(){
      
    $where = "";
    
    if($this->getObjetoBean()->getDescripcion()){
      $where .= " AND role_desc LIKE '%".$this->getObjetoBean()->getDescripcion()."%'";
    }
    
    if($this->getObjetoBean()->getAccesoGlobal()){
      $where .= " AND global_access = '".$this->getObjetoBean()->getAccesoGlobal()."'";
    }
    
    if($this->getObjetoBean()->getDateBegin()){
      $where .= " AND created_date >= '".$this->getObjetoBean()->getDateBegin()."'";
    }
    
    if($this->getObjetoBean()->getDateEnd()){
      $where .= " AND created_date <= '".$this->getObjetoBean()->getDateEnd()."'";
    }
      
    $con = Conexion::getConexion();
		$sql = "SELECT * FROM mnu_role WHERE 1 ".$where;
		$result   = mysql_db_query(Conexion::getNameDb(), $sql, $con);
		$num_rows = mysql_num_rows($result);
		
    $a_tmp = array();
    
		if($num_rows>0){
			while ($o_valor = mysql_fetch_object($result)) {
        $a_tmp[] = $this->insertarObjetoBean($o_valor);
			}
		}
		
		return count($a_tmp)>0?$a_tmp:null;
      
  }
  
  /**
  * Retorna un objeto RolBean
  *
  * @return Object
  */
  public function selectByPk(){
  
    $con = Conexion::getConexion();
    $sql  = "SELECT * FROM mnu_role WHERE role_id = '".$this->getObjetoBean()->getRolId()."'";
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    $o_Propel = $result ? mysql_fetch_object($result) : null;
    
    return $o_Propel?$this->insertarObjetoBean($o_Propel):null;
  
  }
  
  /**
  * Reasigna valores retornados del propel a un objeto RolBean
  *
  * @param Object $o_Propel
  * @return RolBean
  */
  private function insertarObjetoBean($o_Propel){

    $o_RolBean = new RolBean();
    $o_RolBean->setRolId($o_Propel->role_id);
    $o_RolBean->setDescripcion($o_Propel->role_desc);
    $o_RolBean->setTareaId($o_Propel->start_task_id);
    $o_RolBean->setAccesoGlobal($o_Propel->global_access);
    $o_RolBean->setFechaCreacion($o_Propel->created_date);
    $o_RolBean->setUsuarioCreacion($o_Propel->created_user);
    $o_RolBean->setFechaActualizacion($o_Propel->revised_date);
    $o_RolBean->setUsuarioActualizacion($o_Propel->revised_user);
    return $o_RolBean;
    
  }
    
  
}