<?php
/**
 * Clase Controler para Usuario
 *
 * @package    IM
 * @subpackage UsuarioCT
 * @author     Willy
 * @version    SVN: $Id: UsuarioCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class UsuarioCT implements interfaceCT{
  /**
  * Funcin para Guardar el  Usuario
  *
  * @param $o_UsuarioBean, objeto bean de Usuario
  * @return booleam
  */
  public function guardar(&$o_UsuarioBean){
    
    $o_UsuarioDP = new UsuarioDP($o_UsuarioBean);
    $iResultado = $o_UsuarioDP->save();        
    if($iResultado){
        return true;
    }else{
        $o_UsuarioBean = null;
        return false;
    }
    
  }
  
  /**
  * Funcin para Modificar el  Usuario
  *
  * @param $o_UsuarioBean, objeto bean de Usuario
  * @return booleam
  */
  public function modificar(&$o_UsuarioBean){
   
    $o_UsuarioDP = new UsuarioDP($o_UsuarioBean);
    return $o_UsuarioDP->update();
  }
  
  /**
  * Funcin para Eliminar el  Usuario
  *
  * @param $o_UsuarioBean, objeto bean de Usuario
  * @return booleam
  */
  public function eliminar($o_UsuarioBean){ 
    $o_UsuarioDP = new UsuarioDP($o_UsuarioBean);
    return $o_UsuarioDP->delete();
  }
  
  /**
  * Funcin para Seleccionar el  Usuario
  *
  * @param $o_UsuarioBeans, objeto bean de Usuario
  * @return booleam
  * 
  */
 
  public function seleccionar($o_UsuarioBean){
    $o_UsuarioDP = new UsuarioDP($o_UsuarioBean);        
    if($o_UsuarioBean->getUsuarioId()){
      return $o_UsuarioDP->selectByPk();
    }else{
      return $o_UsuarioDP->select();
    }
  }
  
  public function totalRegistros($o_UsuarioBean){
    $o_UsuarioDP = new UsuarioDP($o_UsuarioBean);
    return $o_UsuarioDP->selectNumRows();
    
  }
  
}