<?php
/**
 * Clase Base FN para BaseRhPensionDevengueFN
 *
 * @package    
 * @subpackage BaseRhPensionDevengueFN
 * @author     Willy
 * @version    SVN:: BaseRhPensionDevengueFN.class.php,v 1.1 2015-01-25 15:09:49 william.taype Exp $
 */
class BaseRhPensionDevengueFN extends RhPensionDevengueBN
{
  private static $fieldNames = array (
    'IdPeriodo'=>'IdPeriodo', 'IdPension'=>'IdPension', 'ComisionFija'=>'ComisionFija', 'ComisionFlujo'=>'ComisionFlujo', 'ComisionMixtaFlujo'=>'ComisionMixtaFlujo', 'ComisionAnualSaldo'=>'ComisionMixtaASaldo', 'Seguro'=>'Seguro', 'PorcentajeAporteObligatorio'=>'PorcentajeAporteObligatorio', 'RMA'=>'RMA', 'FechaRegistro'=>'FechaRegistro', 'UsuarioRegistro'=>'UsuarioRegistro'  
  );

  public function select()
  {
    try
    {
      $tamPag = !property_exists($this, 'tamPag')?9999:$this->tamPag;
      $pagina = !property_exists($this, 'page')||$this->page==""?1:$this->page;
      $numeroRegistros = $this->selectNumRows();
      $limitInf = ($pagina-1)*$tamPag;

      $where = $this->buildConsult();
      $orden = $this->buildOrderByField();

      $con = Conexion::getConexion();
      $sql = "SELECT IdPeriodo, IdPension, ComisionFija, ComisionFlujo, ComisionMixtaFlujo, ComisionMixtaASaldo, Seguro, PorcentajeAporteObligatorio, RMA, FechaRegistro, UsuarioRegistro FROM rh_pension_devengue WHERE 1 ".$where." ".$orden."  LIMIT ".$limitInf.",".$tamPag;
      
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
      $num_rows = mysql_num_rows($result);
      $a_tmp = array();
      if($num_rows>0){
        while ($o_valor = mysql_fetch_object($result)) {
          $a_tmp[] = $this->insertObjectBN($o_valor);
        }
      }
      
      return count($a_tmp)>0?$a_tmp:null;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function selectNumRows()
  {
    try
    {
      $where = $this->buildConsult();

      $con = Conexion::getConexion();
      $sql = "SELECT IdPeriodo, IdPension, ComisionFija, ComisionFlujo, ComisionMixtaFlujo, ComisionMixtaASaldo, Seguro, PorcentajeAporteObligatorio, RMA, FechaRegistro, UsuarioRegistro FROM rh_pension_devengue WHERE 1 ".$where;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
      $num_rows = mysql_num_rows($result);
      
      return $num_rows;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildConsult()
  {
    try
    {
      $where = "";

      if($this->getIdPeriodo()){ $where .= " AND idperiodo = '".$this->getIdPeriodo()."'"; }
      if($this->getIdPension()){ $where .= " AND idpension = '".$this->getIdPension()."'"; }
      if($this->getComisionFija()){ $where .= " AND comisionfija = '".$this->getComisionFija()."'"; }
      if($this->getComisionFlujo()){ $where .= " AND comisionflujo = '".$this->getComisionFlujo()."'"; }
      if($this->getComisionMixtaFlujo()){ $where .= " AND comisionmixtaflujo = '".$this->getComisionMixtaFlujo()."'"; }
      if($this->getComisionAnualSaldo()){ $where .= " AND comisionmixtaasaldo = '".$this->getComisionAnualSaldo()."'"; }
      if($this->getSeguro()){ $where .= " AND seguro = '".$this->getSeguro()."'"; }
      if($this->getPorcentajeAporteObligatorio()){ $where .= " AND porcentajeaporteobligatorio = '".$this->getPorcentajeAporteObligatorio()."'"; }
      if($this->getRMA()){ $where .= " AND rma = '".$this->getRMA()."'"; }
      if($this->getFechaRegistro()){ $where .= " AND fecharegistro = '".$this->getFechaRegistro()."'"; }
      if($this->getUsuarioRegistro()){ $where .= " AND usuarioregistro = '".$this->getUsuarioRegistro()."'"; }
      return $where;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildOrderByField()
  {
    try
    {
      $order_by = "";

      if(property_exists($this,'sortCampos')){
      if($this->sortCampos != ""){
        $a_valCampos = explode(";", $this->sortCampos);
        $a_valtype   = explode(";", $this->sortType);
        $order_by = " ORDER BY ";
        $a_order = array();
        foreach ($a_valCampos as $key => $val){
          $sTmpOrder = "";
          if(array_key_exists($val, self::$fieldNames)){
            $sTmpOrder .= self::$fieldNames[$val];
            switch ($a_valtype[$key]){
              case 1: $sTmpOrder .= " ASC"; break;
              case 2: $sTmpOrder .= " DESC"; break;
            }
            $a_order[] = $sTmpOrder;
          }
        }
        $order_by .= implode(", ", $a_order);
      }
      }
      return $order_by;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* B�squeda del registro por la llave primaria */
  public function selectByPK()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IdPeriodo, IdPension, ComisionFija, ComisionFlujo, ComisionMixtaFlujo, ComisionMixtaASaldo, Seguro, PorcentajeAporteObligatorio, RMA, FechaRegistro, UsuarioRegistro FROM rh_pension_devengue WHERE 1 AND IdPeriodo='".$this->getIdPeriodo()."' AND IdPension='".$this->getIdPension()."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
      $o_Propel = $result ? mysql_fetch_object($result) : null;
      

      return $o_Propel?$this->insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_BaseRhPensionDevengueFN = new BaseRhPensionDevengueFN();
    $o_BaseRhPensionDevengueFN->setIdPeriodo($o_propel->IdPeriodo);
    $o_BaseRhPensionDevengueFN->setIdPension($o_propel->IdPension);
    $o_BaseRhPensionDevengueFN->setComisionFija($o_propel->ComisionFija);
    $o_BaseRhPensionDevengueFN->setComisionFlujo($o_propel->ComisionFlujo);
    $o_BaseRhPensionDevengueFN->setComisionMixtaFlujo($o_propel->ComisionMixtaFlujo);
    $o_BaseRhPensionDevengueFN->setComisionAnualSaldo($o_propel->ComisionMixtaASaldo);
    $o_BaseRhPensionDevengueFN->setSeguro($o_propel->Seguro);
    $o_BaseRhPensionDevengueFN->setPorcentajeAporteObligatorio($o_propel->PorcentajeAporteObligatorio);
    $o_BaseRhPensionDevengueFN->setRMA($o_propel->RMA);
    $o_BaseRhPensionDevengueFN->setFechaRegistro($o_propel->FechaRegistro);
    $o_BaseRhPensionDevengueFN->setUsuarioRegistro($o_propel->UsuarioRegistro);
    return $o_BaseRhPensionDevengueFN;
  }
}