<?php
/**
 * Clase Base DP para BaseRhPensionDevengueDP
 *
 * @package    
 * @subpackage BaseRhPensionDevengueDP
 * @author     Willy
 * @version    SVN:: BaseRhPensionDevengueDP.class.php,v 1.1 2015-01-25 15:09:55 william.taype Exp $
 */
abstract class BaseRhPensionDevengueDP extends RhPensionDevengueBN
{
  /* N�mero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof RhPensionDevengueBN )
    {
      $o_RhPensionDevengueBN = $bSetDefault;
      if($o_RhPensionDevengueBN->getIdPeriodo()) : $this->setIdPeriodo($o_RhPensionDevengueBN->getIdPeriodo()); endif;
      if($o_RhPensionDevengueBN->getIdPension()) : $this->setIdPension($o_RhPensionDevengueBN->getIdPension()); endif;
      if($o_RhPensionDevengueBN->getComisionFija()) : $this->setComisionFija($o_RhPensionDevengueBN->getComisionFija()); endif;
      if($o_RhPensionDevengueBN->getComisionFlujo()) : $this->setComisionFlujo($o_RhPensionDevengueBN->getComisionFlujo()); endif;
      if($o_RhPensionDevengueBN->getComisionMixtaFlujo()) : $this->setComisionMixtaFlujo($o_RhPensionDevengueBN->getComisionMixtaFlujo()); endif;
      if($o_RhPensionDevengueBN->getComisionAnualSaldo()) : $this->setComisionAnualSaldo($o_RhPensionDevengueBN->getComisionAnualSaldo()); endif;
      if($o_RhPensionDevengueBN->getSeguro()) : $this->setSeguro($o_RhPensionDevengueBN->getSeguro()); endif;
      if($o_RhPensionDevengueBN->getPorcentajeAporteObligatorio()) : $this->setPorcentajeAporteObligatorio($o_RhPensionDevengueBN->getPorcentajeAporteObligatorio()); endif;
      if($o_RhPensionDevengueBN->getRMA()) : $this->setRMA($o_RhPensionDevengueBN->getRMA()); endif;
      if($o_RhPensionDevengueBN->getFechaRegistro()) : $this->setFechaRegistro($o_RhPensionDevengueBN->getFechaRegistro()); endif;
      if($o_RhPensionDevengueBN->getUsuarioRegistro()) : $this->setUsuarioRegistro($o_RhPensionDevengueBN->getUsuarioRegistro()); endif;
    }
  }

  /* Obtiene el n�mero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IF(MAX(IdPeriodo),(MAX(IdPeriodo)+1), 1) AS Maximo FROM rh_pension_devengue;";
      $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
      $result = mysql_query($sql, $oLink);
      $row = mysql_fetch_array($result);
      $this->setIdPeriodo($row[0]);

      if($this->getIdPeriodo() && $this->getIdPension()){
        $a_Fields = array();

        if($this->getIdPeriodo()) : $a_Fields['IdPeriodo'] = ($this->getIdPeriodo()); endif;
        if($this->getIdPension()) : $a_Fields['IdPension'] = ($this->getIdPension()); endif;
        if($this->getComisionFija()) : $a_Fields['ComisionFija'] = ($this->getComisionFija()); endif;
        if($this->getComisionFlujo()) : $a_Fields['ComisionFlujo'] = ($this->getComisionFlujo()); endif;
        if($this->getComisionMixtaFlujo()) : $a_Fields['ComisionMixtaFlujo'] = ($this->getComisionMixtaFlujo()); endif;
        if($this->getComisionAnualSaldo()) : $a_Fields['ComisionMixtaASaldo'] = ($this->getComisionAnualSaldo()); endif;
        if($this->getSeguro()) : $a_Fields['Seguro'] = ($this->getSeguro()); endif;
        if($this->getPorcentajeAporteObligatorio()) : $a_Fields['PorcentajeAporteObligatorio'] = ($this->getPorcentajeAporteObligatorio()); endif;
        if($this->getRMA()) : $a_Fields['RMA'] = ($this->getRMA()); endif;
        if($this->getFechaRegistro()) : $a_Fields['FechaRegistro'] = ($this->getFechaRegistro()); endif;
        if($this->getUsuarioRegistro()) : $a_Fields['UsuarioRegistro'] = ($this->getUsuarioRegistro()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO rh_pension_devengue (".$sStringField.") VALUES (".$sStringValue.");";
        
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdPeriodo() && $this->getIdPension())
      {
        $a_Fields = array();

        if($this->getIdPeriodo()) : $a_Fields['IdPeriodo'] = ($this->getIdPeriodo()); endif;
        if($this->getIdPension()) : $a_Fields['IdPension'] = ($this->getIdPension()); endif;
        if($this->getComisionFija()) : $a_Fields['ComisionFija'] = ($this->getComisionFija()); endif;
        if($this->getComisionFlujo()) : $a_Fields['ComisionFlujo'] = ($this->getComisionFlujo()); endif;
        if($this->getComisionMixtaFlujo()) : $a_Fields['ComisionMixtaFlujo'] = ($this->getComisionMixtaFlujo()); endif;
        if($this->getComisionAnualSaldo()) : $a_Fields['ComisionMixtaASaldo'] = ($this->getComisionAnualSaldo()); endif;
        if($this->getSeguro()) : $a_Fields['Seguro'] = ($this->getSeguro()); endif;
        if($this->getPorcentajeAporteObligatorio()) : $a_Fields['PorcentajeAporteObligatorio'] = ($this->getPorcentajeAporteObligatorio()); endif;
        if($this->getRMA()) : $a_Fields['RMA'] = ($this->getRMA()); endif;
        if($this->getFechaRegistro()) : $a_Fields['FechaRegistro'] = ($this->getFechaRegistro()); endif;
        if($this->getUsuarioRegistro()) : $a_Fields['UsuarioRegistro'] = ($this->getUsuarioRegistro()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE rh_pension_devengue SET ".$sStringField." WHERE 1 AND IdPeriodo='".$this->getIdPeriodo()."' AND IdPension='".$this->getIdPension()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdPeriodo() && $this->getIdPension())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM rh_pension_devengue WHERE 1 AND IdPeriodo='".$this->getIdPeriodo()."' AND IdPension='".$this->getIdPension()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* B�squeda del registro por la llave primaria */
  public static function selectByPK($vIdPeriodo, $vIdPension)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IdPeriodo, IdPension, ComisionFija, ComisionFlujo, ComisionMixtaFlujo, ComisionMixtaASaldo, Seguro, PorcentajeAporteObligatorio, RMA, FechaRegistro, UsuarioRegistro FROM rh_pension_devengue WHERE 1 AND IdPeriodo='".$vIdPeriodo."' AND IdPension='".$vIdPension."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
      $o_Propel = $result ? mysql_fetch_object($result) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_RhPensionDevengueDP = new RhPensionDevengueDP();
    $o_RhPensionDevengueDP->setIdPeriodo($o_propel->IdPeriodo);
    $o_RhPensionDevengueDP->setIdPension($o_propel->IdPension);
    $o_RhPensionDevengueDP->setComisionFija($o_propel->ComisionFija);
    $o_RhPensionDevengueDP->setComisionFlujo($o_propel->ComisionFlujo);
    $o_RhPensionDevengueDP->setComisionMixtaFlujo($o_propel->ComisionMixtaFlujo);
    $o_RhPensionDevengueDP->setComisionAnualSaldo($o_propel->ComisionMixtaASaldo);
    $o_RhPensionDevengueDP->setSeguro($o_propel->Seguro);
    $o_RhPensionDevengueDP->setPorcentajeAporteObligatorio($o_propel->PorcentajeAporteObligatorio);
    $o_RhPensionDevengueDP->setRMA($o_propel->RMA);
    $o_RhPensionDevengueDP->setFechaRegistro($o_propel->FechaRegistro);
    $o_RhPensionDevengueDP->setUsuarioRegistro($o_propel->UsuarioRegistro);
    return $o_RhPensionDevengueDP;
  }
}