<?php
/**
 * Clase Base DP para BaseRhPensionDP
 *
 * @package    
 * @subpackage BaseRhPensionDP
 * @author     Willy
 * @version    SVN:: BaseRhPensionDP.class.php,v 1.1 2015-01-25 15:09:55 william.taype Exp $
 */
abstract class BaseRhPensionDP extends RhPensionBN
{
  /* Nmero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof RhPensionBN )
    {
      $o_RhPensionBN = $bSetDefault;
      if($o_RhPensionBN->getIdPension()) : $this->setIdPension($o_RhPensionBN->getIdPension()); endif;
      if($o_RhPensionBN->getDescripcion()) : $this->setDescripcion($o_RhPensionBN->getDescripcion()); endif;
      if($o_RhPensionBN->getTipo()) : $this->setTipo($o_RhPensionBN->getTipo()); endif;
      if($o_RhPensionBN->getEstado()) : $this->setEstado($o_RhPensionBN->getEstado()); endif;
      if($o_RhPensionBN->getFecharegistro()) : $this->setFecharegistro($o_RhPensionBN->getFecharegistro()); endif;
      if($o_RhPensionBN->getUsuarioregistro()) : $this->setUsuarioregistro($o_RhPensionBN->getUsuarioregistro()); endif;
      if($o_RhPensionBN->getEliminado()) : $this->setEliminado($o_RhPensionBN->getEliminado()); endif;
      if($o_RhPensionBN->getFechaeliminado()) : $this->setFechaeliminado($o_RhPensionBN->getFechaeliminado()); endif;
      if($o_RhPensionBN->getUsuarioeliminado()) : $this->setUsuarioeliminado($o_RhPensionBN->getUsuarioeliminado()); endif;
      if($o_RhPensionBN->getFechaModificacion()) : $this->setFechaModificacion($o_RhPensionBN->getFechaModificacion()); endif;
      if($o_RhPensionBN->getUsuarioModificacion()) : $this->setUsuarioModificacion($o_RhPensionBN->getUsuarioModificacion()); endif;
    }
  }

  /* Obtiene el nmero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IF(MAX(IdPension),(MAX(IdPension)+1), 1) AS Maximo FROM rh_pension;";
      $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
      $result = mysql_query($sql, $oLink);
      $row = mysql_fetch_array($result);
      $this->setIdPension($row[0]);

      if($this->getIdPension()){
        $a_Fields = array();

        if($this->getIdPension()) : $a_Fields['IdPension'] = ($this->getIdPension()); endif;
        if($this->getDescripcion()) : $a_Fields['Descripcion'] = ($this->getDescripcion()); endif;
        if($this->getTipo()) : $a_Fields['Tipo'] = ($this->getTipo()); endif;
        if($this->getEstado()) : $a_Fields['Estado'] = ($this->getEstado()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;
        if($this->getEliminado()) : $a_Fields['Eliminado'] = ($this->getEliminado()); endif;
        if($this->getFechaeliminado()) : $a_Fields['fechaeliminado'] = ($this->getFechaeliminado()); endif;
        if($this->getUsuarioeliminado()) : $a_Fields['usuarioeliminado'] = ($this->getUsuarioeliminado()); endif;
        if($this->getFechaModificacion()) : $a_Fields['fechaModificacion'] = ($this->getFechaModificacion()); endif;
        if($this->getUsuarioModificacion()) : $a_Fields['usuarioModificacion'] = ($this->getUsuarioModificacion()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO rh_pension (".$sStringField.") VALUES (".$sStringValue.");";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdPension())
      {
        $a_Fields = array();

        if($this->getIdPension()) : $a_Fields['IdPension'] = ($this->getIdPension()); endif;
        if($this->getDescripcion()) : $a_Fields['Descripcion'] = ($this->getDescripcion()); endif;
        if($this->getTipo()) : $a_Fields['Tipo'] = ($this->getTipo()); endif;
        if($this->getEstado()) : $a_Fields['Estado'] = ($this->getEstado()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;
        if($this->getEliminado()) : $a_Fields['Eliminado'] = ($this->getEliminado()); endif;
        if($this->getFechaeliminado()) : $a_Fields['fechaeliminado'] = ($this->getFechaeliminado()); endif;
        if($this->getUsuarioeliminado()) : $a_Fields['usuarioeliminado'] = ($this->getUsuarioeliminado()); endif;
        if($this->getFechaModificacion()) : $a_Fields['fechaModificacion'] = ($this->getFechaModificacion()); endif;
        if($this->getUsuarioModificacion()) : $a_Fields['usuarioModificacion'] = ($this->getUsuarioModificacion()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE rh_pension SET ".$sStringField." WHERE 1 AND IdPension='".$this->getIdPension()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdPension())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM rh_pension WHERE 1 AND IdPension='".$this->getIdPension()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* Bsqueda del registro por la llave primaria */
  public static function selectByPK($vIdPension)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IdPension, Descripcion, Tipo, Estado, fecharegistro, usuarioregistro, Eliminado, fechaeliminado, usuarioeliminado, fechaModificacion, usuarioModificacion FROM rh_pension WHERE 1 AND IdPension='".$vIdPension."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
      $o_Propel = $result ? mysql_fetch_object($result) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con mtodos de acceso */
  private function insertObjectBN($o_propel){
    $o_RhPensionDP = new RhPensionDP();
    $o_RhPensionDP->setIdPension($o_propel->IdPension);
    $o_RhPensionDP->setDescripcion($o_propel->Descripcion);
    $o_RhPensionDP->setTipo($o_propel->Tipo);
    $o_RhPensionDP->setEstado($o_propel->Estado);
    $o_RhPensionDP->setFecharegistro($o_propel->fecharegistro);
    $o_RhPensionDP->setUsuarioregistro($o_propel->usuarioregistro);
    $o_RhPensionDP->setEliminado($o_propel->Eliminado);
    $o_RhPensionDP->setFechaeliminado($o_propel->fechaeliminado);
    $o_RhPensionDP->setUsuarioeliminado($o_propel->usuarioeliminado);
    $o_RhPensionDP->setFechaModificacion($o_propel->fechaModificacion);
    $o_RhPensionDP->setUsuarioModificacion($o_propel->usuarioModificacion);
    return $o_RhPensionDP;
  }
}