<?php
/**
 * Clase Base FN para BaseCrPlanillaFN
 *
 * @package    
 * @subpackage BaseCrPlanillaFN
 * @author     Willy
 * @version    SVN:: BaseCrPlanillaFN.class.php,v 1.1 2014-03-13 15:05:46 william.taype Exp $
 */
class BaseCrPlanillaFN extends CrPlanillaBN
{
  private static $fieldNames = array (
    'IdColaborador'=>'IdColaborador', 'Periodo'=>'Periodo', 'IdConcepto'=>'IdConcepto', 'Valor'=>'Valor', 'FechaCreacion'=>'FechaCreacion', 'UsuarioCreacion'=>'UsuarioCreacion'  
  );

  public function select()
  {
    try
    {
      $tamPag = !property_exists($this, 'tamPag')?9999:$this->tamPag;
      $pagina = !property_exists($this, 'page')||$this->page==""?1:$this->page;
      $numeroRegistros = $this->selectNumRows();
      $limitInf = ($pagina-1)*$tamPag;

      $where = $this->buildConsult();
      $orden = $this->buildOrderByField();

      $con = Conexion::getConexion();
      $sql = "SELECT IdColaborador, Periodo, IdConcepto, Valor, FechaCreacion, UsuarioCreacion 
     			FROM 	cr_planilla p
      			LEFT JOIN cr_colaborador c on c.IdColaborador = p.IdColaborador 
      		 WHERE 1 ".$where." ".$orden."  LIMIT ".$limitInf.",".$tamPag;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
      $num_rows = mysql_num_rows($result);
      $a_tmp = array();
      if($num_rows>0){
        while ($o_valor = mysql_fetch_object($result)) {
          $a_tmp[] = $this->insertObjectBN($o_valor);
        }
      }
      
      return count($a_tmp)>0?$a_tmp:null;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function selectNumRows()
  {
    try
    {
      $where = $this->buildConsult();

      $con = Conexion::getConexion();
      $sql = "SELECT * 
      			FROM 	cr_planilla p
      			LEFT JOIN cr_colaborador c on c.IdColaborador = p.IdColaborador 
      			LEFT JOIN cr_sucursal_per s on s.Periodo = p.Periodo and c.IdPadre = s.IdAdministrador 
      			WHERE 1 ".$where;
      //echo $sql;
	 $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      $num_rows = mysql_num_rows($result);
      
      return $num_rows;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildConsult()
  {
    try
    {
      $where = "";

      if($this->getIdColaborador()){ $where .= " AND p.idcolaborador = '".$this->getIdColaborador()."'"; }
      if($this->getPeriodo()){ $where .= " AND p.periodo = '".$this->getPeriodo()."'"; }
      
      if(is_array($this->getIdColaboradores())){
      	 $where .= " AND p.idcolaborador in ('".implode("','",$this->getIdColaboradores())."')";
      }
      if($this->getIdPadre()){
      	 $where .= " AND c.idpadre ='".$this->getIdPadre()."'";
      } 
      if($this->getIdSucursal()){
      	 $where .= " AND s.idsucursal ='".$this->getIdSucursal()."'";
      } 
      if($this->getIdPadreRes()){
      	 $where .= " AND (c.idpadre ='".$this->getIdPadreRes()."' OR c.idcolaborador ='".$this->getIdPadreRes()."')";
      }
      if($this->getIdConcepto()){ $where .= " AND idconcepto = '".$this->getIdConcepto()."'"; }
      if($this->getValor()){ $where .= " AND valor = '".$this->getValor()."'"; }
      if($this->getFechaCreacion()){ $where .= " AND fechacreacion = '".$this->getFechaCreacion()."'"; }
      if($this->getUsuarioCreacion()){ $where .= " AND usuariocreacion = '".$this->getUsuarioCreacion()."'"; }
      return $where;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildOrderByField()
  {
    try
    {
      $order_by = "";

      if(property_exists($this,'sortCampos')){
      if($this->sortCampos != ""){
        $a_valCampos = explode(";", $this->sortCampos);
        $a_valtype   = explode(";", $this->sortType);
        $order_by = " ORDER BY ";
        $a_order = array();
        foreach ($a_valCampos as $key => $val){
          $sTmpOrder = "";
          if(array_key_exists($val, self::$fieldNames)){
            $sTmpOrder .= self::$fieldNames[$val];
            switch ($a_valtype[$key]){
              case 1: $sTmpOrder .= " ASC"; break;
              case 2: $sTmpOrder .= " DESC"; break;
            }
            $a_order[] = $sTmpOrder;
          }
        }
        $order_by .= implode(", ", $a_order);
      }
      }
      return $order_by;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Búsqueda del registro por la llave primaria */
  public function selectByPK()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IdColaborador, Periodo, IdConcepto, Valor, FechaCreacion, UsuarioCreacion FROM cr_planilla WHERE 1 AND IdColaborador='".$this->getIdColaborador()."' AND Periodo='".$this->getPeriodo()."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
      $o_Propel = $result ? mysql_fetch_object($result) : null;
      

      return $o_Propel?$this->insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con métodos de acceso */
  public function insertObjectBN($o_propel){
    $o_BaseCrPlanillaFN = new BaseCrPlanillaFN();
    $o_BaseCrPlanillaFN->setIdColaborador($o_propel->IdColaborador);
    $o_BaseCrPlanillaFN->setPeriodo($o_propel->Periodo);
    $o_BaseCrPlanillaFN->setIdConcepto($o_propel->IdConcepto);
    $o_BaseCrPlanillaFN->setValor($o_propel->Valor);
    $o_BaseCrPlanillaFN->setFechaCreacion($o_propel->FechaCreacion);
    $o_BaseCrPlanillaFN->setUsuarioCreacion($o_propel->UsuarioCreacion);
    return $o_BaseCrPlanillaFN;
  }
}