<?php
/**
 * Clase Base FN para BaseCrPlanillaConceptoPerFN
 *
 * @package    
 * @subpackage BaseCrPlanillaConceptoPerFN
 * @author     Willy
 * @version    SVN:: BaseCrPlanillaConceptoPerFN.class.php,v 1.1 2014-03-16 11:18:21 william.taype Exp $
 */
class BaseCrPlanillaConceptoPerFN extends CrPlanillaConceptoPerBN
{
  private static $fieldNames = array (
    'Periodo'=>'Periodo', 'IdConcepto'=>'IdConcepto', 'Codigo'=>'Codigo', 'Tipo'=>'Tipo', 'Ubicacion'=>'Ubicacion', 'VisualizarPlanilla'=>'VisualizarPlanilla', 'PosicionPlanilla'=>'PosicionPlanilla', 'Descripcion'=>'Descripcion', 'DescripcionPlanilla'=>'DescripcionPlanilla', 'DescripcionBoleta'=>'DescripcionBoleta', 'Estado'=>'Estado', 'FechaCreacion'=>'FechaCreacion', 'UsuarioCreacion'=>'UsuarioCreacion'  
  );

  public function select()
  {
    try
    {
      $tamPag = !property_exists($this, 'tamPag')?9999:$this->tamPag;
      $pagina = !property_exists($this, 'page')||$this->page==""?1:$this->page;
      $numeroRegistros = $this->selectNumRows();
      $limitInf = ($pagina-1)*$tamPag;

      $where = $this->buildConsult();
      $orden = $this->buildOrderByField();

      $con = Conexion::getConexion();
      $sql = "SELECT Periodo, IdConcepto, Codigo, Tipo, Ubicacion, VisualizarPlanilla, PosicionPlanilla, Descripcion, DescripcionPlanilla, DescripcionBoleta, Estado, FechaCreacion, UsuarioCreacion FROM cr_planilla_concepto_per WHERE 1 ".$where." ".$orden."  LIMIT ".$limitInf.",".$tamPag;
	 // echo $sql;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      $num_rows = mysql_num_rows($result);
      $a_tmp = array();
      if($num_rows>0){
        while ($o_valor = mysql_fetch_object($result)) {
          $a_tmp[] = $this->insertObjectBN($o_valor);
        }
      }
      
      return count($a_tmp)>0?$a_tmp:null;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function selectNumRows()
  {
    try
    {
      $where = $this->buildConsult();

      $con = Conexion::getConexion();
      $sql = "SELECT Periodo, IdConcepto, Codigo, Tipo, Ubicacion, VisualizarPlanilla, PosicionPlanilla, Descripcion, DescripcionPlanilla, DescripcionBoleta, Estado, FechaCreacion, UsuarioCreacion FROM cr_planilla_concepto_per WHERE 1 ".$where;
	  //echo $sql;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      $num_rows = mysql_num_rows($result);
      
      return $num_rows;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildConsult()
  {
    try
    {
      $where = "";

      if($this->getPeriodo()){ $where .= " AND periodo = '".$this->getPeriodo()."'"; }
      if($this->getIdConcepto()){ $where .= " AND idconcepto = '".$this->getIdConcepto()."'"; }
      if($this->getCodigo()){ $where .= " AND codigo = '".$this->getCodigo()."'"; }
      if($this->getTipo()){ $where .= " AND tipo = '".$this->getTipo()."'"; }
      if($this->getUbicacion()){ $where .= " AND ubicacion = '".$this->getUbicacion()."'"; }
      if($this->getVisualizarPlanilla()){ $where .= " AND visualizarplanilla = '".$this->getVisualizarPlanilla()."'"; }
      if($this->getPosicionPlanilla()){ $where .= " AND posicionplanilla = '".$this->getPosicionPlanilla()."'"; }
      if($this->getDescripcion()){ $where .= " AND descripcion = '".$this->getDescripcion()."'"; }
      if($this->getDescripcionPlanilla()){ $where .= " AND descripcionplanilla = '".$this->getDescripcionPlanilla()."'"; }
      if($this->getDescripcionBoleta()){ $where .= " AND descripcionboleta = '".$this->getDescripcionBoleta()."'"; }
      if($this->getEstado()){ $where .= " AND estado = '".$this->getEstado()."'"; }
      if($this->getFechaCreacion()){ $where .= " AND fechacreacion = '".$this->getFechaCreacion()."'"; }
      if($this->getUsuarioCreacion()){ $where .= " AND usuariocreacion = '".$this->getUsuarioCreacion()."'"; }
      return $where;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildOrderByField()
  {
    try
    {
      $order_by = "";

      if(property_exists($this,'sortCampos')){
      if($this->sortCampos != ""){
        $a_valCampos = explode(";", $this->sortCampos);
        $a_valtype   = explode(";", $this->sortType);
        $order_by = " ORDER BY ";
        $a_order = array();
        foreach ($a_valCampos as $key => $val){
          $sTmpOrder = "";
          if(array_key_exists($val, self::$fieldNames)){
            $sTmpOrder .= self::$fieldNames[$val];
            switch ($a_valtype[$key]){
              case 1: $sTmpOrder .= " ASC"; break;
              case 2: $sTmpOrder .= " DESC"; break;
            }
            $a_order[] = $sTmpOrder;
          }
        }
        $order_by .= implode(", ", $a_order);
      }
      }
      return $order_by;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Bsqueda del registro por la llave primaria */
  public function selectByPK()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT Periodo, IdConcepto, Codigo, Tipo, Ubicacion, VisualizarPlanilla, PosicionPlanilla, Descripcion, DescripcionPlanilla, DescripcionBoleta, Estado, FechaCreacion, UsuarioCreacion FROM cr_planilla_concepto_per WHERE 1 AND Periodo='".$this->getPeriodo()."' AND IdConcepto='".$this->getIdConcepto()."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
      $o_Propel = $result ? mysql_fetch_object($result) : null;
      

      return $o_Propel?$this->insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con mtodos de acceso */
  private function insertObjectBN($o_propel){
    $o_BaseCrPlanillaConceptoPerFN = new BaseCrPlanillaConceptoPerFN();
    $o_BaseCrPlanillaConceptoPerFN->setPeriodo($o_propel->Periodo);
    $o_BaseCrPlanillaConceptoPerFN->setIdConcepto($o_propel->IdConcepto);
    $o_BaseCrPlanillaConceptoPerFN->setCodigo($o_propel->Codigo);
    $o_BaseCrPlanillaConceptoPerFN->setTipo($o_propel->Tipo);
    $o_BaseCrPlanillaConceptoPerFN->setUbicacion($o_propel->Ubicacion);
    $o_BaseCrPlanillaConceptoPerFN->setVisualizarPlanilla($o_propel->VisualizarPlanilla);
    $o_BaseCrPlanillaConceptoPerFN->setPosicionPlanilla($o_propel->PosicionPlanilla);
    $o_BaseCrPlanillaConceptoPerFN->setDescripcion($o_propel->Descripcion);
    $o_BaseCrPlanillaConceptoPerFN->setDescripcionPlanilla($o_propel->DescripcionPlanilla);
    $o_BaseCrPlanillaConceptoPerFN->setDescripcionBoleta($o_propel->DescripcionBoleta);
    $o_BaseCrPlanillaConceptoPerFN->setEstado($o_propel->Estado);
    $o_BaseCrPlanillaConceptoPerFN->setFechaCreacion($o_propel->FechaCreacion);
    $o_BaseCrPlanillaConceptoPerFN->setUsuarioCreacion($o_propel->UsuarioCreacion);
    return $o_BaseCrPlanillaConceptoPerFN;
  }
}