<?php
/**
 * Clase Base DP para BaseCrPlanillaDP
 *
 * @package    
 * @subpackage BaseCrPlanillaDP
 * @author     Willy
 * @version    SVN:: BaseCrPlanillaDP.class.php,v 1.1 2014-03-13 15:06:05 william.taype Exp $
 */
abstract class BaseCrPlanillaDP extends CrPlanillaBN
{
  /* Número de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof CrPlanillaBN )
    {
      $o_CrPlanillaBN = $bSetDefault;
      if($o_CrPlanillaBN->getIdColaborador()) : $this->setIdColaborador($o_CrPlanillaBN->getIdColaborador()); endif;
      if($o_CrPlanillaBN->getPeriodo()) : $this->setPeriodo($o_CrPlanillaBN->getPeriodo()); endif;
      if($o_CrPlanillaBN->getIdConcepto()) : $this->setIdConcepto($o_CrPlanillaBN->getIdConcepto()); endif;
      if($o_CrPlanillaBN->getValor()) : $this->setValor($o_CrPlanillaBN->getValor()); endif;
      if($o_CrPlanillaBN->getFechaCreacion()) : $this->setFechaCreacion($o_CrPlanillaBN->getFechaCreacion()); endif;
      if($o_CrPlanillaBN->getUsuarioCreacion()) : $this->setUsuarioCreacion($o_CrPlanillaBN->getUsuarioCreacion()); endif;
    }
  }

  /* Obtiene el número de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
     
      if($this->getIdColaborador() && $this->getPeriodo()){
        $a_Fields = array();

        if($this->getIdColaborador()) : $a_Fields['IdColaborador'] = ($this->getIdColaborador()); endif;
        if($this->getPeriodo()) : $a_Fields['Periodo'] = ($this->getPeriodo()); endif;
        if($this->getIdConcepto()) : $a_Fields['IdConcepto'] = ($this->getIdConcepto()); endif;
        if($this->getValor()) : $a_Fields['Valor'] = ($this->getValor()); endif;
        if($this->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getFechaCreacion()); endif;
        if($this->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getUsuarioCreacion()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO cr_planilla (".$sStringField.") VALUES (".$sStringValue.");";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdColaborador() && $this->getPeriodo())
      {
        $a_Fields = array();

        if($this->getIdColaborador()) : $a_Fields['IdColaborador'] = ($this->getIdColaborador()); endif;
        if($this->getPeriodo()) : $a_Fields['Periodo'] = ($this->getPeriodo()); endif;
        if($this->getIdConcepto()) : $a_Fields['IdConcepto'] = ($this->getIdConcepto()); endif;
        if($this->getValor()) : $a_Fields['Valor'] = ($this->getValor()); endif;
        if($this->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getFechaCreacion()); endif;
        if($this->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getUsuarioCreacion()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE cr_planilla SET ".$sStringField." WHERE 1 AND IdColaborador='".$this->getIdColaborador()."' AND Periodo='".$this->getPeriodo()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdColaborador() && $this->getPeriodo())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM cr_planilla WHERE 1 AND IdColaborador='".$this->getIdColaborador()."' AND Periodo='".$this->getPeriodo()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* Búsqueda del registro por la llave primaria */
  public static function selectByPK($vIdColaborador, $vPeriodo)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IdColaborador, Periodo, IdConcepto, Valor, FechaCreacion, UsuarioCreacion FROM cr_planilla WHERE 1 AND IdColaborador='".$vIdColaborador."' AND Periodo='".$vPeriodo."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
      $o_Propel = $result ? mysql_fetch_object($result) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con métodos de acceso */
  private function insertObjectBN($o_propel){
    $o_CrPlanillaDP = new CrPlanillaDP();
    $o_CrPlanillaDP->setIdColaborador($o_propel->IdColaborador);
    $o_CrPlanillaDP->setPeriodo($o_propel->Periodo);
    $o_CrPlanillaDP->setIdConcepto($o_propel->IdConcepto);
    $o_CrPlanillaDP->setValor($o_propel->Valor);
    $o_CrPlanillaDP->setFechaCreacion($o_propel->FechaCreacion);
    $o_CrPlanillaDP->setUsuarioCreacion($o_propel->UsuarioCreacion);
    return $o_CrPlanillaDP;
  }
}