<?php
/**
 * Clase Base DP para BaseCrPlanillaConceptoPerDP
 *
 * @package    
 * @subpackage BaseCrPlanillaConceptoPerDP
 * @author     Willy
 * @version    SVN:: BaseCrPlanillaConceptoPerDP.class.php,v 1.1 2014-03-16 11:18:18 william.taype Exp $
 */
abstract class BaseCrPlanillaConceptoPerDP extends CrPlanillaConceptoPerBN
{
  /* Nmero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof CrPlanillaConceptoPerBN )
    {
      $o_CrPlanillaConceptoPerBN = $bSetDefault;
      if($o_CrPlanillaConceptoPerBN->getPeriodo()) : $this->setPeriodo($o_CrPlanillaConceptoPerBN->getPeriodo()); endif;
      if($o_CrPlanillaConceptoPerBN->getIdConcepto()) : $this->setIdConcepto($o_CrPlanillaConceptoPerBN->getIdConcepto()); endif;
      if($o_CrPlanillaConceptoPerBN->getCodigo()) : $this->setCodigo($o_CrPlanillaConceptoPerBN->getCodigo()); endif;
      if($o_CrPlanillaConceptoPerBN->getTipo()) : $this->setTipo($o_CrPlanillaConceptoPerBN->getTipo()); endif;
      if($o_CrPlanillaConceptoPerBN->getUbicacion()) : $this->setUbicacion($o_CrPlanillaConceptoPerBN->getUbicacion()); endif;
      if($o_CrPlanillaConceptoPerBN->getVisualizarPlanilla()) : $this->setVisualizarPlanilla($o_CrPlanillaConceptoPerBN->getVisualizarPlanilla()); endif;
      if($o_CrPlanillaConceptoPerBN->getPosicionPlanilla()) : $this->setPosicionPlanilla($o_CrPlanillaConceptoPerBN->getPosicionPlanilla()); endif;
      if($o_CrPlanillaConceptoPerBN->getDescripcion()) : $this->setDescripcion($o_CrPlanillaConceptoPerBN->getDescripcion()); endif;
      if($o_CrPlanillaConceptoPerBN->getDescripcionPlanilla()) : $this->setDescripcionPlanilla($o_CrPlanillaConceptoPerBN->getDescripcionPlanilla()); endif;
      if($o_CrPlanillaConceptoPerBN->getDescripcionBoleta()) : $this->setDescripcionBoleta($o_CrPlanillaConceptoPerBN->getDescripcionBoleta()); endif;
      if($o_CrPlanillaConceptoPerBN->getEstado()) : $this->setEstado($o_CrPlanillaConceptoPerBN->getEstado()); endif;
      if($o_CrPlanillaConceptoPerBN->getFechaCreacion()) : $this->setFechaCreacion($o_CrPlanillaConceptoPerBN->getFechaCreacion()); endif;
      if($o_CrPlanillaConceptoPerBN->getUsuarioCreacion()) : $this->setUsuarioCreacion($o_CrPlanillaConceptoPerBN->getUsuarioCreacion()); endif;
    }
  }

  /* Obtiene el nmero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IF(MAX(Periodo),(MAX(Periodo)+1), 1) AS Maximo FROM cr_planilla_concepto_per;";
      $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
      $result = mysql_query($sql, $oLink);
      $row = mysql_fetch_array($result);
      $this->setPeriodo($row[0]);

      if($this->getPeriodo() && $this->getIdConcepto()){
        $a_Fields = array();

        if($this->getPeriodo()) : $a_Fields['Periodo'] = ($this->getPeriodo()); endif;
        if($this->getIdConcepto()) : $a_Fields['IdConcepto'] = ($this->getIdConcepto()); endif;
        if($this->getCodigo()) : $a_Fields['Codigo'] = ($this->getCodigo()); endif;
        if($this->getTipo()) : $a_Fields['Tipo'] = ($this->getTipo()); endif;
        if($this->getUbicacion()) : $a_Fields['Ubicacion'] = ($this->getUbicacion()); endif;
        if($this->getVisualizarPlanilla()) : $a_Fields['VisualizarPlanilla'] = ($this->getVisualizarPlanilla()); endif;
        if($this->getPosicionPlanilla()) : $a_Fields['PosicionPlanilla'] = ($this->getPosicionPlanilla()); endif;
        if($this->getDescripcion()) : $a_Fields['Descripcion'] = ($this->getDescripcion()); endif;
        if($this->getDescripcionPlanilla()) : $a_Fields['DescripcionPlanilla'] = ($this->getDescripcionPlanilla()); endif;
        if($this->getDescripcionBoleta()) : $a_Fields['DescripcionBoleta'] = ($this->getDescripcionBoleta()); endif;
        if($this->getEstado()) : $a_Fields['Estado'] = ($this->getEstado()); endif;
        if($this->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getFechaCreacion()); endif;
        if($this->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getUsuarioCreacion()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO cr_planilla_concepto_per (".$sStringField.") VALUES (".$sStringValue.");";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getPeriodo() && $this->getIdConcepto())
      {
        $a_Fields = array();

        if($this->getPeriodo()) : $a_Fields['Periodo'] = ($this->getPeriodo()); endif;
        if($this->getIdConcepto()) : $a_Fields['IdConcepto'] = ($this->getIdConcepto()); endif;
        if($this->getCodigo()) : $a_Fields['Codigo'] = ($this->getCodigo()); endif;
        if($this->getTipo()) : $a_Fields['Tipo'] = ($this->getTipo()); endif;
        if($this->getUbicacion()) : $a_Fields['Ubicacion'] = ($this->getUbicacion()); endif;
        if($this->getVisualizarPlanilla()) : $a_Fields['VisualizarPlanilla'] = ($this->getVisualizarPlanilla()); endif;
        if($this->getPosicionPlanilla()) : $a_Fields['PosicionPlanilla'] = ($this->getPosicionPlanilla()); endif;
        if($this->getDescripcion()) : $a_Fields['Descripcion'] = ($this->getDescripcion()); endif;
        if($this->getDescripcionPlanilla()) : $a_Fields['DescripcionPlanilla'] = ($this->getDescripcionPlanilla()); endif;
        if($this->getDescripcionBoleta()) : $a_Fields['DescripcionBoleta'] = ($this->getDescripcionBoleta()); endif;
        if($this->getEstado()) : $a_Fields['Estado'] = ($this->getEstado()); endif;
        if($this->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getFechaCreacion()); endif;
        if($this->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getUsuarioCreacion()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE cr_planilla_concepto_per SET ".$sStringField." WHERE 1 AND Periodo='".$this->getPeriodo()."' AND IdConcepto='".$this->getIdConcepto()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getPeriodo() && $this->getIdConcepto())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM cr_planilla_concepto_per WHERE 1 AND Periodo='".$this->getPeriodo()."' AND IdConcepto='".$this->getIdConcepto()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* Bsqueda del registro por la llave primaria */
  public static function selectByPK($vPeriodo, $vIdConcepto)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT Periodo, IdConcepto, Codigo, Tipo, Ubicacion, VisualizarPlanilla, PosicionPlanilla, Descripcion, DescripcionPlanilla, DescripcionBoleta, Estado, FechaCreacion, UsuarioCreacion FROM cr_planilla_concepto_per WHERE 1 AND Periodo='".$vPeriodo."' AND IdConcepto='".$vIdConcepto."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
      $o_Propel = $result ? mysql_fetch_object($result) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con mtodos de acceso */
  private function insertObjectBN($o_propel){
    $o_CrPlanillaConceptoPerDP = new CrPlanillaConceptoPerDP();
    $o_CrPlanillaConceptoPerDP->setPeriodo($o_propel->Periodo);
    $o_CrPlanillaConceptoPerDP->setIdConcepto($o_propel->IdConcepto);
    $o_CrPlanillaConceptoPerDP->setCodigo($o_propel->Codigo);
    $o_CrPlanillaConceptoPerDP->setTipo($o_propel->Tipo);
    $o_CrPlanillaConceptoPerDP->setUbicacion($o_propel->Ubicacion);
    $o_CrPlanillaConceptoPerDP->setVisualizarPlanilla($o_propel->VisualizarPlanilla);
    $o_CrPlanillaConceptoPerDP->setPosicionPlanilla($o_propel->PosicionPlanilla);
    $o_CrPlanillaConceptoPerDP->setDescripcion($o_propel->Descripcion);
    $o_CrPlanillaConceptoPerDP->setDescripcionPlanilla($o_propel->DescripcionPlanilla);
    $o_CrPlanillaConceptoPerDP->setDescripcionBoleta($o_propel->DescripcionBoleta);
    $o_CrPlanillaConceptoPerDP->setEstado($o_propel->Estado);
    $o_CrPlanillaConceptoPerDP->setFechaCreacion($o_propel->FechaCreacion);
    $o_CrPlanillaConceptoPerDP->setUsuarioCreacion($o_propel->UsuarioCreacion);
    return $o_CrPlanillaConceptoPerDP;
  }
}