<?php
/**
 * Clase Base DP para BaseCrCovid19paramDP
 *
 * @package    
 * @subpackage BaseCrCovid19paramDP
 * @author     Willy
 * @version    SVN:: BaseCrCovid19paramDP.class.php,v 1.1 2020-04-15 14:48:12 william.taype Exp $
 */
abstract class BaseCrCovid19paramDP extends CrCovid19paramBN
{
  /* Nmero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof CrCovid19paramBN )
    {
      $o_CrCovid19paramBN = $bSetDefault;
      if($o_CrCovid19paramBN->getFechapara()) : $this->setFechapara($o_CrCovid19paramBN->getFechapara()); endif;
      if($o_CrCovid19paramBN->getFechareinicio()) : $this->setFechareinicio($o_CrCovid19paramBN->getFechareinicio()); endif;
    }
  }

  /* Obtiene el nmero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();

      if($this->getFechapara() && $this->getFechareinicio()){
        $a_Fields = array();

        if($this->getFechapara()) : $a_Fields['fechapara'] = ($this->getFechapara()); endif;
        if($this->getFechareinicio()) : $a_Fields['fechareinicio'] = ($this->getFechareinicio()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO cr_covid19param (".$sStringField.") VALUES (".$sStringValue.");";
        $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getFechapara() && $this->getFechareinicio())
      {
        $a_Fields = array();

        if($this->getFechapara()) : $a_Fields['fechapara'] = ($this->getFechapara()); endif;
        if($this->getFechareinicio()) : $a_Fields['fechareinicio'] = ($this->getFechareinicio()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE cr_covid19param SET ".$sStringField." WHERE 1 AND fechapara='".$this->getFechapara()."' AND fechareinicio='".$this->getFechareinicio()."';";
        $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getFechapara() && $this->getFechareinicio())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM cr_covid19param WHERE 1 AND fechapara='".$this->getFechapara()."' AND fechareinicio='".$this->getFechareinicio()."';"; 
        $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* Bsqueda del registro por la llave primaria */
  public static function selectByPK($vFechapara, $vFechareinicio)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT fechapara, fechareinicio FROM cr_covid19param WHERE 1 AND fechapara='".$vFechapara."' AND fechareinicio='".$vFechareinicio."'; ";
        $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      $o_Propel = $result ? mysql_fetch_object($result) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con mtodos de acceso */
  private function insertObjectBN($o_propel){
    $o_CrCovid19paramDP = new CrCovid19paramDP();
    $o_CrCovid19paramDP->setFechapara($o_propel->fechapara);
    $o_CrCovid19paramDP->setFechareinicio($o_propel->fechareinicio);
    return $o_CrCovid19paramDP;
  }
}