<?php
/**
 * Clase Base DP para BaseCrCovid19cabeceraDP
 *
 * @package    
 * @subpackage BaseCrCovid19cabeceraDP
 * @author     Willy
 * @version    SVN:: BaseCrCovid19cabeceraDP.class.php,v 1.1 2020-04-15 14:48:12 william.taype Exp $
 */
abstract class BaseCrCovid19cabeceraDP extends CrCovid19cabeceraBN
{
  /* N�mero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof CrCovid19cabeceraBN )
    {
      $o_CrCovid19cabeceraBN = $bSetDefault;
      if($o_CrCovid19cabeceraBN->getIdsucursal()) : $this->setIdsucursal($o_CrCovid19cabeceraBN->getIdsucursal()); endif;
      if($o_CrCovid19cabeceraBN->getIdmercado()) : $this->setIdmercado($o_CrCovid19cabeceraBN->getIdmercado()); endif;
      if($o_CrCovid19cabeceraBN->getFecharegistro()) : $this->setFecharegistro($o_CrCovid19cabeceraBN->getFecharegistro()); endif;
      if($o_CrCovid19cabeceraBN->getUsuarioregistro()) : $this->setUsuarioregistro($o_CrCovid19cabeceraBN->getUsuarioregistro()); endif;
    }
  }

  /* Obtiene el n�mero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      
      if($this->getIdsucursal() && $this->getIdmercado()){
        $a_Fields = array();

        if($this->getIdsucursal()) : $a_Fields['idsucursal'] = ($this->getIdsucursal()); endif;
        if($this->getIdmercado()) : $a_Fields['idmercado'] = ($this->getIdmercado()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO cr_covid19cabecera (".$sStringField.") VALUES (".$sStringValue.");";
        $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($con);
        }
        else
        {
          throw new Exception( mysql_error($con) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdsucursal() && $this->getIdmercado())
      {
        $a_Fields = array();

        if($this->getIdsucursal()) : $a_Fields['idsucursal'] = ($this->getIdsucursal()); endif;
        if($this->getIdmercado()) : $a_Fields['idmercado'] = ($this->getIdmercado()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE cr_covid19cabecera SET ".$sStringField." WHERE 1 AND idsucursal='".$this->getIdsucursal()."' AND idmercado='".$this->getIdmercado()."';";
        $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($con);
        }
        else
        {
          throw new Exception( mysql_error($con) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdsucursal() && $this->getIdmercado())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM cr_covid19cabecera WHERE 1 AND idsucursal='".$this->getIdsucursal()."' AND idmercado='".$this->getIdmercado()."';"; 
        $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($con);
        }
        else
        {
          throw new Exception( mysql_error($con) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* B�squeda del registro por la llave primaria */
  public static function selectByPK($vIdsucursal, $vIdmercado)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idsucursal, idmercado, fecharegistro, usuarioregistro FROM cr_covid19cabecera WHERE 1 AND idsucursal='".$vIdsucursal."' AND idmercado='".$vIdmercado."'; ";
        $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      $o_Propel = $result ? mysql_fetch_object($result) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_CrCovid19cabeceraDP = new CrCovid19cabeceraDP();
    $o_CrCovid19cabeceraDP->setIdsucursal($o_propel->idsucursal);
    $o_CrCovid19cabeceraDP->setIdmercado($o_propel->idmercado);
    $o_CrCovid19cabeceraDP->setFecharegistro($o_propel->fecharegistro);
    $o_CrCovid19cabeceraDP->setUsuarioregistro($o_propel->usuarioregistro);
    return $o_CrCovid19cabeceraDP;
  }
}