<?php
/**
 * Clase ContCapitalInicialer para CapitalInicial
 *
 * @package    IM
 * @subpackage CapitalInicialCT
 * @author     Willy
 * @version    SVN: $Id: CapitalInicialCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class CapitalInicialCT implements interfaceCT{
  /**
  * Funcin para Guardar el  CapitalInicial
  *
  * @param $o_CapitalInicialBean, objeto bean de CapitalInicial
  * @return booleam
  */
  public function guardar(&$o_CapitalInicialBean){ 
    
    $o_CapitalInicialDP = new CapitalInicialDP($o_CapitalInicialBean);
    return $o_CapitalInicialDP->save();
    
  }
  
  /**
  * Funcin para Modificar el  CapitalInicial
  *
  * @param $o_CapitalInicialBean, objeto bean de CapitalInicial
  * @return booleam
  */
  public function modificar(&$o_CapitalInicialBean){
    
    $o_CapitalInicialDP = new CapitalInicialDP($o_CapitalInicialBean);
    return $o_CapitalInicialDP->update();
    
  }
  
  /**
  * Funcin para Eliminar el  CapitalInicial
  *
  * @param $o_CapitalInicialBean, objeto bean de CapitalInicial
  * @return booleam
  */
  public function eliminar($o_CapitalInicialBean){ 
    $o_CapitalInicialDP = new CapitalInicialDP($o_CapitalInicialBean);
    return $o_CapitalInicialDP->delete();
  }
  
  
  public function totalRegistros($o_CapitalInicialBean){
    $o_CapitalInicialBeanDP = new CapitalInicialDP($o_CapitalInicialBean);
    return $o_CapitalInicialBeanDP->selectNumRows();
    
  }
  
   public function totalMonto($o_CapitalInicialBean){
    $o_CapitalInicialBeanDP = new CapitalInicialDP($o_CapitalInicialBean);
    return $o_CapitalInicialBeanDP->selectTotalMonto();
    
  }
  
  
  /**
  * Funcin para Seleccionar el  CapitalInicial
  *
  * @param $o_CapitalInicialBeans, objeto bean de CapitalInicial
  * @return booleam
  */
  public function seleccionar($o_CapitalInicialBean){
  
    $o_CapitalInicialDP = new CapitalInicialDP($o_CapitalInicialBean);
    if($o_CapitalInicialBean->getIdCapitalInicial()){
      return $o_CapitalInicialDP->selectByPk();
    }else{
      return $o_CapitalInicialDP->select();
    }
      
  }
  
}