<?php
/**
 * Clase ContIngresoDiversoser para IngresoDiversos
 *
 * @package    IM
 * @subpackage IngresoDiversosCT
 * @author     Willy
 * @version    SVN: $Id: IngresoDiversosCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class IngresoDiversosCT implements interfaceCT{
  /**
  * Funcin para Guardar el  IngresoDiversos
  *
  * @param $o_IngresoDiversosBean, objeto bean de IngresoDiversos
  * @return booleam
  */
  public function guardar(&$o_IngresoDiversosBean){ 
    
    $o_IngresoDiversosDP = new IngresoDiversosDP($o_IngresoDiversosBean);
    return $o_IngresoDiversosDP->save();
    
  }
  
  /**
  * Funcin para Modificar el  IngresoDiversos
  *
  * @param $o_IngresoDiversosBean, objeto bean de IngresoDiversos
  * @return booleam
  */
  public function modificar(&$o_IngresoDiversosBean){
    
    $o_IngresoDiversosDP = new IngresoDiversosDP($o_IngresoDiversosBean);
    return $o_IngresoDiversosDP->update();
    
  }
  
  /**
  * Funcin para Eliminar el  IngresoDiversos
  *
  * @param $o_IngresoDiversosBean, objeto bean de IngresoDiversos
  * @return booleam
  */
  public function eliminar($o_IngresoDiversosBean){ 
    $o_IngresoDiversosDP = new IngresoDiversosDP($o_IngresoDiversosBean);
    return $o_IngresoDiversosDP->delete();
  }
  
  
  public function totalRegistros($o_IngresoDiversosBean){
    $o_IngresoDiversosBeanDP = new IngresoDiversosDP($o_IngresoDiversosBean);
    return $o_IngresoDiversosBeanDP->selectNumRows();
    
  }
  
  
  /**
  * Funcin para Seleccionar el  IngresoDiversos
  *
  * @param $o_IngresoDiversosBeans, objeto bean de IngresoDiversos
  * @return booleam
  */
  public function seleccionar($o_IngresoDiversosBean){
  
    $o_IngresoDiversosDP = new IngresoDiversosDP($o_IngresoDiversosBean);
    if($o_IngresoDiversosBean->getIdIngreso()){
      return $o_IngresoDiversosDP->selectByPk();
    }else{
      return $o_IngresoDiversosDP->select();
    }
      
  }
  
}