
<?php

/**
* Clase Dispacher para Adelanto
*
* @package IM
* @subpackage AdelantoDP
* @author Willy
* @version SVN: : AdelantoDP.class.php,v 1.1 2009/06/01 13:16:53 Exp $
*/
class CierrePedidoDP implements interfaceDP {
	private static $fieldNames = array (
    'IdSucursal' => 'pf.idsucursal', 
    'Fecha' => 'pf.fecha',
    'Idcolaborador' => 'pcf.idcolaborador',
    'DescripcionSucursal' => 'su.descripcion',
    'Montototal' => 'pc.montototal',
    'Montoaprobado' => 'pc.montoaprobado',
    'Montorechazado' => 'pc.montorechazado',
    'Estado' => 'pf.Estado'
	);
	
  protected $o_Bean;

  /**
  * Constructor donde asigna a un atributo el objeto AdelantoBean
  *
  * @param AdelantoBean $o_AdelantoBean
  */
  public function __construct(CierrePedidoBean $o_CierrePedidoBean){
  
    $this->o_Bean = $o_CierrePedidoBean;
    
  }
  
  /**
  * Retorna el objeto AdelantoBean
  *
  * @return Object
  */
  protected function getObjetoBean(){
  
    if(!$this->o_Bean){
        $this->o_Bean = new CierrePedidoBean();
    }        
    return $this->o_Bean;
    
  }
  
  /**
  * Ingresa un nuevo registro
  * Gurada en la tabla cr_pedidofecha y cr_pedidoFecha
  * @return IdGenerado
  */
  public function save(){
    $con = Conexion::getConexion();
      $a_Fields = array();
      
      
      if($this->getObjetoBean()->getIdSucursal()) : $a_Fields['idsucursal'] = ($this->getObjetoBean()->getIdSucursal()); endif;
      if($this->getObjetoBean()->getFecha()) : $a_Fields['fecha'] = ($this->getObjetoBean()->getFecha()); endif;
      if($this->getObjetoBean()->getComentario()) : $a_Fields['comentario'] = ($this->getObjetoBean()->getDescripcion()); endif;
      if($this->getObjetoBean()->getEstado()) : $a_Fields['Estado'] = ($this->getObjetoBean()->getEstado()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['usuariocreacion'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['fechacreacion'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getUsuarioModificacion()) : $a_Fields['usuariomodificacion'] = ($this->getObjetoBean()->getUsuarioModificacion()); endif;
      if($this->getObjetoBean()->getFechaModificacion()) : $a_Fields['fechamodificacion'] = ($this->getObjetoBean()->getFechaModificacion()); endif;
            
      $sStringField = arrayClass::implode_keys(',', $a_Fields);
      $sStringValue = "'".implode("','", $a_Fields)."'";

      $sql = "INSERT INTO cr_pedidofecha 
      				(".$sStringField.")
              VALUES 
              		(".$sStringValue.");";
      
      $iResult = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      
      $iResultSave = mysql_insert_id($iResult);
      
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }
  
  }
  
  /**
  * Ingresa un nuevo registro
  * Gurada en la tabla cr_pedidofecha y cr_pedidoFecha
  * @return IdGenerado
  */
  public function saveCierre(){
    $con = Conexion::getConexion();
      $a_Fields = array();
      
      
      if($this->getObjetoBean()->getIdPedidoFecha()) : $a_Fields['IdPedidoFecha'] = ($this->getObjetoBean()->getIdPedidoFecha()); endif;
      if($this->getObjetoBean()->getFechaCierre()) : $a_Fields['fecha'] = ($this->getObjetoBean()->getFechaCierre()); endif;
      if($this->getObjetoBean()->getIdColaborador()) : $a_Fields['idcolaborador'] = ($this->getObjetoBean()->getIdColaborador()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['usuariocreacioncierre'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaCreacionCierre()) : $a_Fields['FechaCreacion'] = ($this->getObjetoBean()->getFechaCreacionCierre()); endif;
      if($this->getObjetoBean()->getUsuarioModificacionCierre()) : $a_Fields['UsuarioModificacion'] = ($this->getObjetoBean()->getUsuarioModificacionCierre()); endif;
      if($this->getObjetoBean()->getFechaModificacionCierre()) : $a_Fields['FechaModificacion'] = ($this->getObjetoBean()->getFechaModificacionCierre()); endif;
            
      $sStringField = arrayClass::implode_keys(',', $a_Fields);
      $sStringValue = "'".implode("','", $a_Fields)."'";

      $sql = "INSERT INTO 
      						cr_pedidocierrefecha (".$sStringField.")
               VALUES 
                      (".$sStringValue.");";
      
      $iResultSave = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }
  
  }
  /**
  * Modifica un nuevo registro
  *
  * @return IdGenerado
  */
  public function update() {

    if($this->getObjetoBean()->getIdPedidoFecha()){
      $con = Conexion::getConexion();
      $a_Fields = array();
      if($this->getObjetoBean()->getIdPedidoFecha()) : $a_Fields['IdPedidoFecha'] = ($this->getObjetoBean()->getIdPedidoFecha()); endif;
      if($this->getObjetoBean()->getIdSucursal()) : $a_Fields['idsucursal'] = ($this->getObjetoBean()->getIdSucursal()); endif;
      if($this->getObjetoBean()->getFecha()) : $a_Fields['fecha'] = ($this->getObjetoBean()->getFecha()); endif;
      if($this->getObjetoBean()->getComentario()) : $a_Fields['comentario'] = ($this->getObjetoBean()->getDescripcion()); endif;
      if($this->getObjetoBean()->getEstado()) : $a_Fields['Estado'] = ($this->getObjetoBean()->getEstado()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['usuariocreacion'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['fechacreacion'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getUsuarioModificacion()) : $a_Fields['usuariomodificacion'] = ($this->getObjetoBean()->getUsuarioModificacion()); endif;
      if($this->getObjetoBean()->getFechaModificacion()) : $a_Fields['fechamodificacion'] = ($this->getObjetoBean()->getFechaModificacion()); endif;
      
      
      $sString = arrayClass::implode_key_value(",", $a_Fields);

      $sql = "UPDATE cr_pedidofecha  SET
                  ".$sString."
            WHERE 1 AND IdPedidoFecha= '".$this->getObjetoBean()->getIdPedidoFecha()."' ";
      
      $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
     
      
      
      $iResultSave = $result;
      if($iResultSave){
        return $iResultSave;
      }else{
        return false;
      }

    }else{
      return false;
    }

  }
    
  
  /**
  * Elimina registro
  *
  * @return Boolean
  */
  public function delete(){
    
      $o_CierrePedido = new CierrePedidoBean();
      
      $con = Conexion::getConexion();
      
      if($this->getObjetoBean()->getIdPedidoFecha()){
          $o_CierrePedido->setIdGasto($this->getObjetoBean()->getIdGasto());
      }
            
      $sql = "UPDATE cr_pedidofecha 
              SET
                Eliminado = '1',
                FechaEliminado = '".date('Y-m-d H:i:s')."',
                UsuarioEliminado = '".$this->getObjetoBean()->getUsuarioEliminado()."'
            WHERE IdPedidoFecha= '".$this->getObjetoBean()->getIdPedidoFecha()."' ";
      
      $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      
      $num_rows = mysql_affected_rows($con);
      
                  
      $iResultDelete = $num_rows;
      if($iResultDelete){
          return 1;
      }else{
          return false;
      }    
    
  }
  
 
  /**
  * Selecciona un nuevo registro
  *
  * @return IdGenerado
  */
  public function select(){
    $tamPag           = is_null($this->getObjetoBean()->tamPag)?1:$this->getObjetoBean()->tamPag;
    $pagina           = is_null($this->getObjetoBean()->page)?1:$this->getObjetoBean()->page;
    $numeroRegistros  = $this->selectNumRows();
    $limitInf         = ($pagina-1)*$tamPag;
    
    $where = $this->buildConsult();
    $orden = $this->buildOrderByField();
    
    $con = Conexion::getConexion();
    /*
    	--pcf.fecha as fechacierre,pcf.fecha as fechacierre,pcf.idcolaborador,pcf.fechacreacion as fechacreacioncierre,pcf.usuariocreacion as usauriocreacioncierre,
    				--pc.numeropedidos ,pc.numeropedidosaprobados ,pc.numeropedidosdesaprobados ,pc.montototal ,pc.montoaprobado ,pc.montorechazado ,pc.montoentregado ,pc.montonoentregado,
    */
    $sql = "
    		
    		SELECT pf.idpedidofecha,pf.idsucursal,pf.fecha,pf.estado,pf.comentario,pf.fechacreacion,pf.usuariocreacion,
    			
    				su.descripcion as decripcionsucursal
            FROM cr_pedidofecha pf
             LEFT JOIN cr_pedidocierrefecha pcf ON pcf.idpedidofecha = pf.idpedidofecha 	
             LEFT JOIN cr_pedidocabecera pc ON pc.idcolaboradorrepresentante = pcf.idcolaborador	
             LEFT JOIN cr_sucursal su ON pf.IdSucursal = su.IdSucursal 
             
            WHERE  1 ".
            $where." GROUP BY  pf.idpedidofecha,pf.idsucursal,pf.fecha,pf.estado,pf.comentario,pf.fechacreacion,pf.usuariocreacion,su.descripcion ".$orden." 
             
            LIMIT ".$limitInf.",".$tamPag;
    
    //echo $sql;
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    $num_rows = mysql_num_rows($result);

    $a_tmp = array();

    if($num_rows>0){
      while ($o_valor = mysql_fetch_object($result)) {
      $a_tmp[] = $this->insertarObjetoBean($o_valor);
      }
    }

    
   
    return count($a_tmp)>0?$a_tmp:null;
      
  }
  
  public function selectReport(){
    $tamPag           = is_null($this->getObjetoBean()->tamPag)?1:$this->getObjetoBean()->tamPag;
    $pagina           = is_null($this->getObjetoBean()->page)?1:$this->getObjetoBean()->page;
    $numeroRegistros  = $this->selectNumRows();
    $limitInf         = ($pagina-1)*$tamPag;
    
    $where = $this->buildConsult();
    $orden = $this->buildOrderByField();
    
    $con = Conexion::getConexion();
    $sql = "SELECT pf.idpedidofecha, concat(co.ApellidoPaterno,' ', co.ApellidoMaterno,', ',co.Nombres) as nombreRep, pf.idsucursal, su.descripcion as decripcionsucursal, pf.fecha, pf.estado, pf.comentario, pf.fechacreacion, pf.usuariocreacion, pcf.fecha AS fechacierre, pcf.fecha AS fechacierre, pcf.idcolaborador, pcf.fechacreacion AS fechacreacioncierre, pcf.usuariocreacion AS usauriocreacioncierre, pc.numeropedidos, pc.numeropedidosaprobados, pc.numeropedidosdesaprobados, pc.montototal, pc.montoaprobado, pc.montorechazado, pc.montoentregado, pc.montonoentregado,pc.idpedidocabecera 
			FROM cr_pedidofecha pf
			INNER JOIN cr_pedidocierrefecha pcf ON pcf.idpedidofecha = pf.idpedidofecha
			INNER JOIN cr_pedidocabecera pc ON pc.idcolaboradorrepresentante = pcf.idcolaborador
			INNER JOIN cr_colaborador co ON co.idcolaborador = pc.idcolaboradorrepresentante
			AND pc.fechaoperacion = pf.fecha
			INNER JOIN cr_sucursal su ON pf.IdSucursal = su.IdSucursal
             
            WHERE  1 ".
            $where." ".$orden." LIMIT ".$limitInf.",".$tamPag;
    
    //echo $sql;
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    $num_rows = mysql_num_rows($result);

    $a_tmp = array();

    if($num_rows>0){
      while ($o_valor = mysql_fetch_object($result)) {
      $a_tmp[] = $this->insertarObjetoBean($o_valor);
      }
    }

    
   
    return count($a_tmp)>0?$a_tmp:null;
      
  }
  
   public function selectNumRowsReport(){
    
    $where = $this->buildConsult();
    
    $con = Conexion::getConexion();
    $sql = " SELECT *
            FROM cr_pedidofecha pf
			INNER JOIN cr_pedidocierrefecha pcf ON pcf.idpedidofecha = pf.idpedidofecha
			INNER JOIN cr_pedidocabecera pc ON pc.idcolaboradorrepresentante = pcf.idcolaborador
			AND pc.fechaoperacion = pf.fecha
			INNER JOIN cr_sucursal su ON pf.IdSucursal = su.IdSucursal
     		WHERE 1 ".$where;
	//echo $sql;	   
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    $num_rows = mysql_num_rows($result);
    
    
   
    return $num_rows;
    
  }
  
  
  
   public function buildOrderByField(){
    $order_by = "";
    if($this->getObjetoBean()->sortCampos || $this->getObjetoBean()->sortCampos != ""){
      $a_valCampos = explode(";", $this->getObjetoBean()->sortCampos);
      $a_valtype   = explode(";", $this->getObjetoBean()->sortType);
      $order_by = " ORDER BY ";
      $a_order = array();
      foreach ($a_valCampos as $key => $val){
        $sTmpOrder = "";
        if(array_key_exists($val, self::$fieldNames)){
          $sTmpOrder .= self::$fieldNames[$val];
          switch ($a_valtype[$key]){
            case 1: $sTmpOrder .= " ASC"; break;
            case 2: $sTmpOrder .= " DESC"; break;
          }
          $a_order[] = $sTmpOrder;
        }
      }
      $order_by .= implode(", ", $a_order);
    }
    return $order_by;
  }
  
  
  /**
  * Retorna un objeto AdelantoBean
  *
  * @return Object
  */
 
  public function selectByPk(){
  
    $con = Conexion::getConexion();
    $sql = "SELECT pf.idpedidofecha,pf.idsucursal,pf.fecha,pf.estado,pf.comentario,pf.fechacreacion,pf.usuariocreacion,pf.fechamodificacion,pf.usuariomodificacion,
    		 pcf.fecha as fechacierre,pcf.idcolaborador,pcf.fechacreacion as fechacreacioncierre,pf.usuariocreacion as usuariocreacioncierre,pcf.fechamodificacion as fechamodificacioncierre,pcf.usuariomodificacion as usuariomodificacioncierre
            FROM cr_pedidofecha pf
             LEFT JOIN cr_pedidocierrefecha pcf ON pcf.idpedidofecha = pf.idpedidofecha 	
             LEFT JOIN cr_sucursal su ON pf.IdSucursal = su.IdSucursal 
             
    		 WHERE  pf.IdPedidioFecha ='".$this->getObjetoBean()->getIdPedidoFecha()."' ";
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    $o_Propel = $result ? mysql_fetch_object($result) : null;
    
    //echo $sql;
    return $o_Propel?$this->insertarObjetoBean($o_Propel):null;
  
  }
  
   
  
  /**
  * Reasigna valores retornados del propel a un objeto AdelantoBean
  *
  * @param Object $o_Propel
  * @return AdelantoBean
  */
 private function insertarObjetoBean($o_Propel){

    $o_CierrePedidoBean = new CierrePedidoBean();
  
    $o_CierrePedidoBean->setIdPedidoFecha($o_Propel->idpedidofecha);
    $o_CierrePedidoBean->setIdSucursal($o_Propel->idsucursal);
    $o_CierrePedidoBean->setDescripcionSucursal($o_Propel->decripcionsucursal);
    $o_CierrePedidoBean->setIdpedidocabecera($o_Propel->idpedidocabecera);
     
    $o_CierrePedidoBean->setFecha($o_Propel->fecha);
    $o_CierrePedidoBean->setComentario($o_Propel->comentario);
    $o_CierrePedidoBean->setEstado($o_Propel->estado);
    $o_CierrePedidoBean->setNumeropedidos($o_Propel->montototal);
    $o_CierrePedidoBean->setNumeropedidosaprobados($o_Propel->montoaprobado);
    $o_CierrePedidoBean->setNombreRep($o_Propel->nombreRep);
    $o_CierrePedidoBean->setNumeropedidosdesaprobados($o_Propel->montorechazado);
    $o_CierrePedidoBean->setUsuarioCreacion($o_Propel->usuariocreacion);
    $o_CierrePedidoBean->setFechaCreacion($o_Propel->fechacreacion);
    $o_CierrePedidoBean->setUsuarioModificacion($o_Propel->usuariomodificacion);
    $o_CierrePedidoBean->setFechaModificacion($o_Propel->fechamodificacion);
    $o_CierrePedidoBean->setFechaCierre($o_Propel->fechacierre);
    $o_CierrePedidoBean->setIdColaborador($o_Propel->idcolaborador);
    $o_CierrePedidoBean->setIdColaborador($o_Propel->idcolaborador);
    $o_CierrePedidoBean->setUsuarioCreacionCierre($o_Propel->usuariocreacioncierre);
    $o_CierrePedidoBean->setUsuarioModificacionCierre($o_Propel->usuariomodificacioncierre);
    $o_CierrePedidoBean->setFechaCreacionCierre($o_Propel->fechacreacioncierre);
    $o_CierrePedidoBean->setUsuarioModificacionCierre($o_Propel->usuariomodificacioncierre);
    
           
    return $o_CierrePedidoBean;    
    
  }
  public function selectNumRows(){
    
    $where = $this->buildConsult();
    
    $con = Conexion::getConexion();
    $sql = " SELECT *
            FROM cr_pedidofecha pf
             LEFT JOIN cr_pedidocierrefecha pcf ON pcf.idpedidofecha = pf.idpedidofecha 	
             LEFT JOIN cr_sucursal su ON pf.IdSucursal = su.IdSucursal  
     		WHERE 1 ".$where;
	//echo $sql;	   
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    $num_rows = mysql_num_rows($result);
    
    
   
    return $num_rows;
    
  }
  public function selectNumRowsCC(){
    
    $where = $this->buildConsult();
    
    $con = Conexion::getConexion();
    $sql = " SELECT *
            FROM cr_pedidofecha pf
     		WHERE 1 ".$where;
	//echo $sql;	   
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    $num_rows = mysql_num_rows($result);
    
    
   
    return $num_rows;
    
  }
  private function buildConsult(){
    
    $where = "";
    
    if($this->getObjetoBean()->getIdPedidoFecha()){
       $where .= " AND pf.fecha  = '".$this->getObjetoBean()->getIdPedidoFecha()."'";
    }
     if($this->getObjetoBean()->getFechaInicial()){
       $where .= " AND pf.fecha >= '".$this->getObjetoBean()->getFechaInicial()."'";
    }
     if($this->getObjetoBean()->getFechaFinal()){
       $where .= " AND pf.fecha  <= '".$this->getObjetoBean()->getFechaFinal()."'";
    }
    if($this->getObjetoBean()->getIdSucursal()){
      
       $where .= " AND pf.IdSucursal= '".$this->getObjetoBean()->getIdSucursal()."'";
       
    }
    if($this->getObjetoBean()->getIdColaborador()){
      
       $where .= " AND pcf.idcolaborador = '".$this->getObjetoBean()->getIdColaborador()."'";
       
    }
     if($this->getObjetoBean()->getEstado()){
      
       $where .= " AND pf.estado= '".$this->getObjetoBean()->getEstado()."'";
       
    }
   
    return $where;
    
  }
  
  public function existePedidosEntregados($s_FechaOperacion,$idsucursal,$i_IdColaborador,$estado='P'){
  	//Id de Prestamos entregados
  	$con = Conexion::getConexion();
 	if($s_FechaOperacion && $i_IdColaborador){
	    $sql = " 
				SELECT entregado
				FROM cr_pedidodetalle pd
				LEFT JOIN cr_pedidocabecera pc on pd.idpedidocabecera = pc.idpedidocabecera 
				
				WHERE idsucursal = '$idsucursal'
						  and fechaoperacion = '$s_FechaOperacion'
						  and idcolaboradorrepresentante = '$i_IdColaborador'
						  and pc.estado = '$estado'
						  and (entregado > 0 or entregado = -1)
				
				 ";
		//echo $sql;	   
	    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
	    $num_rows = mysql_num_rows($result);
	    
	    $a_entregado = null;
	    if($num_rows>0){
	      $a_entregado = null;	
	      while ($o_valor = mysql_fetch_object($result)) {
	     	 $a_entregado_noentregado[] = $o_valor->entregado;
	      }
	    }
	    if(is_array($a_entregado_noentregado)){
		    foreach ($a_entregado_noentregado as $key => $value){
		    	if($value > 1){
				    $a_entregado[] = $value;
		    	}else{
		    		 $a_noentregado[] = -1;
		    	}
		    }
		    if(is_array($a_entregado)){
		    	$o_prestamoBean = new PrestamoBean();
			    $o_prestamoBean->setIdsPrestamos($a_entregado);
			    $o_prestamoDP = new PrestamoDP($o_prestamoBean);
			    $a_prestamos = $o_prestamoDP->select();
		    }
	    }
	    
	    return count($a_prestamos) + count($a_noentregado);
	   
 	}
 	return false;
  }
  
  
  /*
  Existe Pedidos abiertos para una fecha
  */
  function existe_pedidos($s_FechaOperacion,$idsucursal,$i_IdColaborador,$estado='P'){
  		$con = Conexion::getConexion();
  	 	if($s_FechaOperacion && $i_IdColaborador){
  	 		if($estado != '-1') $where = "and estado = '$estado'";
		    $sql = " 
					SELECT idpedidocabecera 
						FROM cr_pedidocabecera
						WHERE idsucursal = '$idsucursal'
							  and fechaoperacion = '$s_FechaOperacion'
							  and idcolaboradorrepresentante = '$i_IdColaborador'
							  $where
					 ";
			//echo $sql;	   
		    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
		    $num_rows = mysql_num_rows($result);
		    
		    if($num_rows>0){
		      while ($o_valor = mysql_fetch_object($result)) {
		     	 $idpedidocabecera = $o_valor->idpedidocabecera;
		      }
		    }
			return $idpedidocabecera;    
  	 	}
  	 	return false;
  }
  
  /*
  Ultima fecha para abierta por
  Sucursal
  Colaborador
  */
  function obtenerFechaCierrePeriodo($idSucursal,$idColaborador=''){
  	
  	
  	 	$con = Conexion::getConexion();
  	 	if(!$idColaborador){
		    $sql = " 
					SELECT fecha
						FROM cr_pedidofecha
						WHERE idsucursal = '$idSucursal'
							  and estado = 'A'
						order by fecha asc	
						Limit 0,1
					 ";
			//echo $sql;	   
		    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
		    $num_rows = mysql_num_rows($result);
		    
		    $a_tmp = array();
		
		    if($num_rows>0){
		      while ($o_valor = mysql_fetch_object($result)) {
		     	 $d_fecha = $o_valor->fecha;
		      }
		    }
  	 	}elseif($idColaborador){
  	 		 $sql = " 
					SELECT idpedidofecha,fecha
						FROM cr_pedidofecha
						WHERE idsucursal = '$idSucursal'
						 and estado = 'A'
						order by fecha asc	
						Limit 0,1
					 ";
			//echo $sql;	   
		    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
		    $num_rows = mysql_num_rows($result);
		    
		    $a_tmp = array();
		
		    if($num_rows>0){
		      while ($o_valor = mysql_fetch_object($result)) {
		      	$i_idpedidofecha = $o_valor->idpedidofecha;
		      	$d_fecha = $o_valor->fecha;
		      }
		    }
  	 		
  	 		 $sql = " 
					SELECT fecha
						FROM cr_pedidocierrefecha
						WHERE idpedidofecha = '$i_idpedidofecha'
							  and idcolaborador = '$idColaborador'
						order by fecha asc	
						Limit 0,1
					 ";
			// echo $sql;	   
		    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
		    $num_rows = mysql_num_rows($result);
		    
		    $a_tmp = array();
		
		    if($num_rows>0){
		     	while ($o_valor = mysql_fetch_object($result)) {
			      	$d_fechac = $o_valor->fecha;
			     }
		    }
		    //Esta cerrado los pedidos del colaborador pero el dia de pedido esta cerrado
		    if($d_fechac && $d_fechac == $d_fecha){
		    	$loop =1;
		    
		    	while($loop){
		    	//Obtener el siguiente dia laborable
			    	$d_fechanueva = date('Y-m-d', strtotime('+1 days'. $d_fechac));
			    	
			    	$sql = " 
							SELECT fecha
								FROM cr_dianolaborable
								WHERE  fecha = '$d_fechanueva'
								
							 ";
			   
				    $result7 = mysql_db_query(Conexion::getNameDb(), $sql, $con);
				    $num_rows7 = mysql_num_rows($result7);
				    
				    
				     if($num_rows7 == 0){
				     	$loop=0;
				     }
				     $d_fechac = $d_fechanueva;
			    	 $d_fecha = $d_fechanueva;
		    	}
			    	
		    }
		    
  	 	}
	   return $d_fecha; 
  }
  
  function existePedidosPendientes($fecha,$idsucursal,$idcolaborador,$estadoC ='P'){
  	$con = Conexion::getConexion();
  	$a_existe = null;
  	if($idcolaborador) $where = "and pc.idcolaboradorrepresentante = '$idcolaborador'";
    $sql = " 
			SELECT pd.estado, count(*) as cantidad
				FROM cr_pedidodetalle pd
				LEFT JOIN cr_pedidocabecera pc on pd.idpedidocabecera = pc.idpedidocabecera 
				
				WHERE pc.estado = '$estadoC'
				AND (pd.eliminado ='0' or pd.eliminado is null)
				AND idsucursal ='$idsucursal'
				and fechaoperacion = '$fecha' $where
				group by  pd.estado";
	//echo $sql;	   
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    $num_rows = mysql_num_rows($result);
    
    $a_tmp = array();

    if($num_rows>0){
      while ($o_valor = mysql_fetch_object($result)) {
      $a_existe[$o_valor->estado] = $o_valor->cantidad;
      }
    }
    return $a_existe;
  }
  
  function mostrarColaboradores($idSucursal){
  
    $con = Conexion::getConexion();
    $sql = " 
			SELECT IdColaborador as idcolaborador
				FROM cr_colaborador
					WHERE IdPadre
			IN (
				SELECT idadministrador
				FROM cr_sucursal
				WHERE idsucursal ='$idSucursal'
			)
				AND eliminado ='0'
				and idrol = 'sys.ope' ";
	//echo $sql;	   
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    $num_rows = mysql_num_rows($result);
    
    $a_tmp = array();

    if($num_rows>0){
      while ($o_valor = mysql_fetch_object($result)) {
      $a_tmp[] = $o_valor->idcolaborador;
      }
    }
    
    $o_ColaboradorBean = new ColaboradorBean();
    $o_ColaboradorBean->setIdColaboradores($a_tmp);
    
    $o_ColaboradorDP = new ColaboradorDP($o_ColaboradorBean);
  
     return $o_ColaboradorDP->select();
   
  }
  
  /*
  metodo::
  1: Metodo de Abrir el periodo del colaborador
  2: Metodo de Cierre el periodo del colaborador
  
  */
  function operacionPeriodoParcial($metodo,$fecha,$idsucursal,$idcolaborador){
  	
  	$con = Conexion::getConexion();
  	switch($metodo){
  		case '1': 
  		
  			 $sql = " 
					SELECT idpedidofecha
						FROM cr_pedidofecha
						WHERE idsucursal = '$idsucursal'
							AND fecha = '$fecha'
						order by fecha asc	
						Limit 0,1
					 ";
			   
		    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
		    $num_rows = mysql_num_rows($result);
		    
		    
		     if($num_rows>0){
		      while ($o_valor = mysql_fetch_object($result)) {
		      	$i_idpedidofecha = $o_valor->idpedidofecha;
		      	
		      	$sql = " 
						DELETE 
						FROM cr_pedidocierrefecha
						WHERE idpedidofecha = '$i_idpedidofecha'
							  and idcolaborador = '$idcolaborador'
					 ";
				
		   		$result2 = mysql_db_query(Conexion::getNameDb(), $sql, $con);
		   		
		   		$sql = " 
						UPDATE cr_pedidofecha
						SET estado = 'A'
						WHERE idpedidofecha = '$i_idpedidofecha'
							  
					 ";
				
		   		$result3 = mysql_db_query(Conexion::getNameDb(), $sql, $con);
		   		
		   		
		      }
		    }
  		
  			
  			break;
  			
  			
  		case '2':
  			
  			
  			$sql = " 
					SELECT idpedidofecha
						FROM cr_pedidofecha
						WHERE idsucursal = '$idsucursal'
							AND fecha = '$fecha'
						order by fecha asc	
						Limit 0,1
					 ";
			   
		    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
		    $num_rows = mysql_num_rows($result);
		    
		    
		     if($num_rows>0){
		      while ($o_valor = mysql_fetch_object($result)) {
		      	$i_idpedidofecha = $o_valor->idpedidofecha;
		      	
		      	$sql = " 
						INSERT INTO cr_pedidocierrefecha
						(idpedidofecha,fecha,idcolaborador,fechacreacion,usuariocreacion)
							values
						('$i_idpedidofecha','$fecha','$idcolaborador','".date('Y-m-d H:i:s')."','".myUser::getUser()->getUserId()."')";
				
		   		$result2 = mysql_db_query(Conexion::getNameDb(), $sql, $con);
		      }
		    }
  			
  			
  			break;
  			
  	}
  }
	
  	 /*
  metodo::
  3: Metodo de Abrir el periodo de la sucursal
  4: Metodo de Cierre el periodo de la sucursal
  
  */
  function operacionPeriodoTotal($metodo,$fecha,$idsucursal,$idcolaborador){
  	
  	$con = Conexion::getConexion();
  	switch($metodo){
  		case '3': 
  		
  			 $sql = " 
					SELECT idpedidofecha
						FROM cr_pedidofecha
						WHERE idsucursal = '$idsucursal'
							AND fecha = '$fecha'
							AND estado = 'C'
						order by fecha asc	
						Limit 0,1
					 ";
			   
		    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
		    $num_rows = mysql_num_rows($result);
		    
		    
		     if($num_rows>0){
		      while ($o_valor = mysql_fetch_object($result)) {
		      	$i_idpedidofecha = $o_valor->idpedidofecha;
		      	
		      	$sql = " 
						INSERT INTO  cr_pedidocierrefecha_bk (idpedidofecha_bk,idpedidofecha,fecha,idcolaborador,fechacreacion,usuariocreacion,fechamodificacion,usuariomodificacion)
							SELECT NULL,idpedidofecha,fecha,idcolaborador,fechacreacion,usuariocreacion,fechamodificacion,usuariomodificacion
							FROM cr_pedidocierrefecha
							WHERE idpedidofecha = '$i_idpedidofecha'
					 ";
		      	
		      	$result2 = mysql_db_query(Conexion::getNameDb(), $sql, $con);
		      	
		      	$sql = " 
						UPDATE cr_pedidofecha
						SET estado = 'A'
						WHERE idpedidofecha = '$i_idpedidofecha'
							  
					 ";
				
		   		$result3 = mysql_db_query(Conexion::getNameDb(), $sql, $con);
		   		
		   		$a_representantes = $this->mostrarColaboradores($idsucursal);
		   		
		   		if(is_array($a_representantes)){
					foreach ($a_representantes as $key => $o_representante){
						$idcolaborador = $o_representante->getIdColaborador();
						$sql = " 
								DELETE 
								FROM cr_pedidocierrefecha
								WHERE idpedidofecha = '$i_idpedidofecha'
									  and idcolaborador = '$idcolaborador'
							 ";
					
						$result4 = mysql_db_query(Conexion::getNameDb(), $sql, $con);
					}
		   		}
		      }
		    }

  			
  			break;
  			
  			
  		case '4':
  			
  			
  			$sql = " 
					SELECT idpedidofecha
					FROM cr_pedidofecha
					WHERE idsucursal = '$idsucursal'
							AND fecha = '$fecha'
							AND estado = 'A'
						order by fecha asc	
						Limit 0,1
					 ";
			   
		    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
		    $num_rows = mysql_num_rows($result);
		    
		    
		     if($num_rows > 0){
		      while ($o_valor = mysql_fetch_object($result)) {
		      	$i_idpedidofecha = $o_valor->idpedidofecha;
		      	
		      	$sql = " 
						UPDATE cr_pedidofecha
						SET estado = 'C'
						WHERE idpedidofecha = '$i_idpedidofecha'
							  
					 ";
				
		   		$result2 = mysql_db_query(Conexion::getNameDb(), $sql, $con);
		   		
		   		
		   		$a_representantes = $this->mostrarColaboradores($idsucursal);
		   		
		   		if(is_array($a_representantes)){
					foreach ($a_representantes as $key => $o_representante){
						$idcolaborador = $o_representante->getIdColaborador();
						
						$sql = " 
								SELECT idcolaborador
									FROM cr_pedidocierrefecha
									WHERE idcolaborador = '$idcolaborador'
										AND idpedidofecha = '$i_idpedidofecha'
									Limit 0,1
								 ";
						   
					    $result5 = mysql_db_query(Conexion::getNameDb(), $sql, $con);
					    $num_rows = mysql_num_rows($result5);
					    if($num_rows == 0){
							$sql = " 
									INSERT INTO cr_pedidocierrefecha
									(idpedidofecha,fecha,idcolaborador,fechacreacion,usuariocreacion)
										values
									('$i_idpedidofecha','$fecha','$idcolaborador','".date('Y-m-d H:i:s')."','".myUser::getUser()->getUserId()."')";
						
							$result6 = mysql_db_query(Conexion::getNameDb(), $sql, $con);
					    }
					}
		   		}
		   		$loop = 1;
		   		
		   		while($loop){
		   			
		   			$fechanueva = date('Y-m-d',strtotime('+1 days '. $fecha));
		   			$sql = " 
							SELECT fecha
								FROM cr_dianolaborable
								WHERE  fecha = '$fechanueva'
								
							 ";
			   
				    $result7 = mysql_db_query(Conexion::getNameDb(), $sql, $con);
				    $num_rows = mysql_num_rows($result7);
				    
				    
				     if($num_rows > 0){
				     	
				     	 //Cierre del Periodo Total 
				     	 $loop = 1;
				     	 $sql = " 
								SELECT idsucursal
									FROM cr_pedidofecha
									WHERE idsucursal = '$idsucursal'
										AND fecha = '$fechanueva'
									Limit 0,1
								 ";
						   
					    $result8 = mysql_db_query(Conexion::getNameDb(), $sql, $con);
					    $num_rows = mysql_num_rows($result8);
					    if($num_rows == 0){
					   		$sql = " 
									INSERT INTO cr_pedidofecha 
										(idpedidofecha, IdSucursal, comentario, fecha, fechacreacion, usuariocreacion,estado )
									VALUES
										(NULL,$idsucursal,'','$fechanueva','".date('Y-m-d H:i:s')."','".myUser::getUser()->getUserId()."','C')
										  
								 ";
							
					   		$result9 = mysql_db_query(Conexion::getNameDb(), $sql, $con);
				      	
					   		if(is_array($a_representantes)){
								foreach ($a_representantes as $key => $o_representante){
									$idcolaborador = $o_representante->getIdColaborador();
									
									$sql = " 
											SELECT idcolaborador
												FROM cr_pedidocierrefecha
												WHERE idcolaborador = '$idcolaborador'
													AND idpedidofecha = '$i_idpedidofecha'
												Limit 0,1
											 ";
									   
								    $result11 = mysql_db_query(Conexion::getNameDb(), $sql, $con);
								    $num_rows = mysql_num_rows($result11);
								    if($num_rows == 0){
										$sql = " 
												INSERT INTO cr_pedidocierrefecha
												(idpedidofecha,fecha,idcolaborador,fechacreacion,usuariocreacion)
													values
												('$i_idpedidofecha','$fecha','$idcolaborador','".date('Y-m-d H:i:s')."','".myUser::getUser()->getUserId()."')";
									
										$result12 = mysql_db_query(Conexion::getNameDb(), $sql, $con);
								    }
								}
					   		}
					   		$fecha = $fechanueva;
					    }
				     }else{
				     	//Sale del loop
			     		$loop = 0;
				     }
				     $fecha = $fechanueva;
		        }
		        $sql = " 
						SELECT idsucursal
						FROM cr_pedidofecha
						WHERE idsucursal = '$idsucursal'
							AND fecha = '$fechanueva'
						Limit 0,1
						 ";
				   
			    $result12 = mysql_db_query(Conexion::getNameDb(), $sql, $con);
			    $num_rows = mysql_num_rows($result12);
			    if($num_rows == 0){
					$sql = " 
								INSERT INTO cr_pedidofecha 
									(idpedidofecha, IdSucursal, comentario, fecha, fechacreacion, usuariocreacion,estado )
								VALUES
									(NULL,$idsucursal,'','$fechanueva','".date('Y-m-d H:i:s')."','".myUser::getUser()->getUserId()."','A')
									  
							 ";
						
					$result13 = mysql_db_query(Conexion::getNameDb(), $sql, $con);
				}
		      }
		    }
  			
  			
  			break;
  			
  	}
  	
   
  }
  
    
}