<?php
/**
 * Clase ContBalanceDiaer para BalanceDia
 *
 * @package    IM
 * @subpackage BalanceDiaCT
 * @author     Willy
 * @version    SVN: $Id: BalanceDiaCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class BalanceDiaCT implements interfaceCT{
  /**
  * Funcin para Guardar el  BalanceDia
  *
  * @param $o_BalanceDiaBean, objeto bean de BalanceDia
  * @return booleam
  */
  public function guardar(&$o_BalanceDiaBean){ 
    
    $o_BalanceDiaDP = new BalanceDiaDP($o_BalanceDiaBean);
    return $o_BalanceDiaDP->save();
    
  }
  
  /**
  * Funcin para Modificar el  BalanceDia
  *
  * @param $o_BalanceDiaBean, objeto bean de BalanceDia
  * @return booleam
  */
  public function modificar(&$o_BalanceDiaBean){
    
    $o_BalanceDiaDP = new BalanceDiaDP($o_BalanceDiaBean);
    return $o_BalanceDiaDP->update();
    
  }
  
  /**
  * Funcin para Eliminar el  BalanceDia
  *
  * @param $o_BalanceDiaBean, objeto bean de BalanceDia
  * @return booleam
  */
  public function eliminar($o_BalanceDiaBean){ 
    $o_BalanceDiaDP = new BalanceDiaDP($o_BalanceDiaBean);
    return $o_BalanceDiaDP->delete();
  }
  
  
  public function totalRegistros($o_BalanceDiaBean){
    $o_BalanceDiaBeanDP = new BalanceDiaDP($o_BalanceDiaBean);
    return $o_BalanceDiaBeanDP->selectNumRows();
    
  }
  
  
  /**
  * Funcin para Seleccionar el  BalanceDia
  *
  * @param $o_BalanceDiaBeans, objeto bean de BalanceDia
  * @return booleam
  */
  public function seleccionar($o_BalanceDiaBean){
  
    $o_BalanceDiaDP = new BalanceDiaDP($o_BalanceDiaBean);
    if($o_BalanceDiaBean->getIdBalanceDia()){
      return $o_BalanceDiaDP->selectByPk();
    }else{
      return $o_BalanceDiaDP->select();
    }
      
  }
  
}