<?php
/**
 * Clase ContSucursalMercadoer para SucursalMercado
 *
 * @package    IM
 * @subpackage SucursalMercadoCT
 * @author     Willy
 * @version    SVN: $Id: SucursalMercadoCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class SucursalMercadoCT implements interfaceCT{
  /**
  * Funci�n para Guardar el  SucursalMercado
  *
  * @param $o_SucursalMercadoBean, objeto bean de SucursalMercado
  * @return booleam
  */
  public function guardar(&$o_SucursalMercadoBean){ 
      $o_SucursalMercadoDP = new SucursalMercadoDP($o_SucursalMercadoBean);
      $iResultado = $o_SucursalMercadoDP->save();        
      if($iResultado){
        return true;
      }else{
        return false;
      }
  }
  
  /**
  * Funci�n para Modificar el  SucursalMercado
  *
  * @param $o_SucursalMercadoBean, objeto bean de SucursalMercado
  * @return booleam
  */
  public function modificar(&$o_SucursalMercadoBean){
    $o_SucursalMercadoDP = new SucursalMercadoDP($o_SucursalMercadoBean);
    $iResultado = $o_SucursalMercadoDP->update();        
    if($iResultado){
      return true;
    }else{
      return false;
    }
  }
  
  /**
  * Funci�n para Eliminar el  SucursalMercado
  *
  * @param $o_SucursalMercadoBean, objeto bean de SucursalMercado
  * @return booleam
  */
  public function eliminar($o_SucursalMercadoBean){ 
    $o_SucursalMercadoDP = new SucursalMercadoDP($o_SucursalMercadoBean);
    $iResultado = $o_SucursalMercadoDP->delete();        
    if($iResultado){
      return true;
    }else{
      return false;
    }
  }
  
  
  /**
  * Funci�n para Seleccionar el  SucursalMercado
  *
  * @param $o_SucursalMercadoBeans, objeto bean de SucursalMercado
  * @return booleam
  */
  public function seleccionar($o_SucursalMercadoBean){
  
    $o_SucursalMercadoDP = new SucursalMercadoDP($o_SucursalMercadoBean);        
    if($o_SucursalMercadoBean->getIdSucursal() && $o_SucursalMercadoBean->getIdMercado()){
      return $o_SucursalMercadoDP->selectByPk();
    }else{
      return $o_SucursalMercadoDP->select();
    }
      
  }
  
}?>