<?php
/**
 * Clase ContSucursaler para Sucursal
 *
 * @package    IM
 * @subpackage SucursalCT
 * @author     Willy
 * @version    SVN: $Id: SucursalCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class SucursalCT implements interfaceCT{
  /**
  * Funcin para Guardar el  Sucursal
  *
  * @param $o_SucursalBean, objeto bean de Sucursal
  * @return booleam
  */
  public function guardar(&$o_SucursalBean){ 
    
    $o_SucursalDP = new SucursalDP($o_SucursalBean);
    return $o_SucursalDP->save();
    
  }
  
  /**
  * Funcin para Modificar el  Sucursal
  *
  * @param $o_SucursalBean, objeto bean de Sucursal
  * @return booleam
  */
  public function modificar(&$o_SucursalBean){
    
    $o_SucursalDP = new SucursalDP($o_SucursalBean);
    return $o_SucursalDP->update();
    
  }
  
  /**
  * Funcin para Eliminar el  Sucursal
  *
  * @param $o_SucursalBean, objeto bean de Sucursal
  * @return booleam
  */
  public function eliminar($o_SucursalBean){ 
    $o_SucursalDP = new SucursalDP($o_SucursalBean);
    return $o_SucursalDP->delete();
  }
  
  
  public function totalRegistros($o_SucursalBean){
    $o_SucursalBeanDP = new SucursalDP($o_SucursalBean);
    return $o_SucursalBeanDP->selectNumRows();
    
  }
  
  
  /**
  * Funcin para Seleccionar el  Sucursal
  *
  * @param $o_SucursalBeans, objeto bean de Sucursal
  * @return booleam
  */
  public function seleccionar($o_SucursalBean){
  
    $o_SucursalDP = new SucursalDP($o_SucursalBean);
    if($o_SucursalBean->getIdSucursal()){
      return $o_SucursalDP->selectByPk();
    }else{
      return $o_SucursalDP->select();
    }
      
  }
  
}