<?php
/**
 * Clase ContMercadoer para Mercado
 *
 * @package    IM
 * @subpackage MercadoCT
 * @author     Willy
 * @version    SVN: $Id: MercadoCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class MercadoCT implements interfaceCT{
  /**
  * Funcin para Guardar el  Mercado
  *
  * @param $o_MercadoBean, objeto bean de Mercado
  * @return booleam
  */
  public function guardar(&$o_MercadoBean){ 
    
    $o_MercadoDP = new MercadoDP($o_MercadoBean);
    return $o_MercadoDP->save();
    
  }
  
  /**
  * Funcin para Modificar el  Mercado
  *
  * @param $o_MercadoBean, objeto bean de Mercado
  * @return booleam
  */
  public function modificar(&$o_MercadoBean){
    
    $o_MercadoDP = new MercadoDP($o_MercadoBean);
    return $o_MercadoDP->update();
    
  }
  
  /**
  * Funcin para Eliminar el  Mercado
  *
  * @param $o_MercadoBean, objeto bean de Mercado
  * @return booleam
  */
  public function eliminar($o_MercadoBean){ 
    $o_MercadoDP = new MercadoDP($o_MercadoBean);
    return $o_MercadoDP->delete();
  }
  
  
  public function totalRegistros($o_MercadoBean){
    $o_MercadoBeanDP = new MercadoDP($o_MercadoBean);
    return $o_MercadoBeanDP->selectNumRows();
    
  }
  
  
  /**
  * Funcin para Seleccionar el  Mercado
  *
  * @param $o_MercadoBeans, objeto bean de Mercado
  * @return booleam
  */
  public function seleccionar($o_MercadoBean){
  
    $o_MercadoDP = new MercadoDP($o_MercadoBean);
    if($o_MercadoBean->getIdMercado()){
      return $o_MercadoDP->selectByPk();
    }else{
      return $o_MercadoDP->select();
    }
      
  }
  
}