<?php
/**
 * Clase ContColaboradorer para Colaborador
 *
 * @package    IM
 * @subpackage ColaboradorCT
 * @author     Willy
 * @version    SVN: $Id: ColaboradorCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class ColaboradorCT implements interfaceCT{
  /**
  * Funcin para Guardar el  Colaborador
  *
  * @param $o_ColaboradorBean, objeto bean de Colaborador
  * @return booleam
  */
  public function guardar(&$o_ColaboradorBean){ 
    
    $o_ColaboradorDP = new ColaboradorDP($o_ColaboradorBean);
    return $o_ColaboradorDP->save();
    
  }
  
  /**
  * Funcin para Modificar el  Colaborador
  *
  * @param $o_ColaboradorBean, objeto bean de Colaborador
  * @return booleam
  */
  public function modificar(&$o_ColaboradorBean){
    
    $o_ColaboradorDP = new ColaboradorDP($o_ColaboradorBean);
    return $o_ColaboradorDP->update();
    
  }
  
  /**
  * Funcin para Eliminar el  Colaborador
  *
  * @param $o_ColaboradorBean, objeto bean de Colaborador
  * @return booleam
  */
  public function eliminar($o_ColaboradorBean){ 
    $o_ColaboradorDP = new ColaboradorDP($o_ColaboradorBean);
    return $o_ColaboradorDP->delete();
  }
  
  
  public function totalRegistros($o_ColaboradorBean){
    $o_ColaboradorBeanDP = new ColaboradorDP($o_ColaboradorBean);
    return $o_ColaboradorBeanDP->selectNumRows();
    
  }
  
  
  /**
  * Funcin para Seleccionar el  Colaborador
  *
  * @param $o_ColaboradorBeans, objeto bean de Colaborador
  * @return booleam
  */
  public function seleccionar($o_ColaboradorBean){
  
    $o_ColaboradorDP = new ColaboradorDP($o_ColaboradorBean);
    if($o_ColaboradorBean->getColaboradorId()){
      return $o_ColaboradorDP->selectByPk();
    }else{
      return $o_ColaboradorDP->select();
    }
      
  }
  
}?>