<?php

/**
* Clase Dispacher para Prestamo
*
* @package IM
* @subpackage PrestamoDP
* @author Willy
* @version SVN: : PrestamoDP.class.php,v 1.1 2009/06/10 22:59:27 Exp $
*/
class PrestamoDP implements interfaceDP {
 	private static $fieldNames = array (
    'Condicion' => 'condicion','FechaEliminado'=>'cr_prestamo.FechaEliminado','FlagReporte'=>'cr_prestamo.FlagReporte','IdPrestamo'=>'cr_prestamo.IdPrestamo'
	);
			
  protected $o_Bean;

  /**
  * Constructor donde asigna a un atributo el objeto PrestamoBean
  *
  * @param PrestamoBean $o_PrestamoBean
  */
  public function __construct(PrestamoBean $o_PrestamoBean){
  
    $this->o_Bean = $o_PrestamoBean;
    
  }
  
  /**
  * Retorna el objeto PrestamoBean
  *
  * @return Object
  */
  protected function getObjetoBean(){
  
    if(!$this->o_Bean){
        $this->o_Bean = new PrestamoBean();
    }        
    return $this->o_Bean;
    
  }
  
  /**
  * Ingresa un nuevo registro
  *
  * @return IdGenerado
  */
  public function save(){

    $con = Conexion::getConexion();
    
      $a_Fields = array();
    
      if($this->getObjetoBean()->getIdCliente()) : $a_Fields['IdCliente'] = ($this->getObjetoBean()->getIdCliente()); endif;
      if($this->getObjetoBean()->getFechaInicio()) : $a_Fields['FechaInicio'] = ($this->getObjetoBean()->getFechaInicio()); endif;
      if($this->getObjetoBean()->getFechaInicioPago()) : $a_Fields['FechaInicioPago'] = ($this->getObjetoBean()->getFechaInicioPago()); endif;
      if($this->getObjetoBean()->getFechaVencimiento()) : $a_Fields['FechaVencimiento'] = ($this->getObjetoBean()->getFechaVencimiento()); endif;
      if($this->getObjetoBean()->getMontoPrestado()) : $a_Fields['MontoPrestado'] = ($this->getObjetoBean()->getMontoPrestado()); endif;
      if($this->getObjetoBean()->getInteresPorcentaje()) : $a_Fields['InteresPorcentaje'] = ($this->getObjetoBean()->getInteresPorcentaje()); endif;
      if($this->getObjetoBean()->getInteresMonto()) : $a_Fields['InteresMonto'] = ($this->getObjetoBean()->getInteresMonto()); endif;
      if($this->getObjetoBean()->getMontoTotal()) : $a_Fields['MontoTotal'] = ($this->getObjetoBean()->getMontoTotal()); endif;
      if($this->getObjetoBean()->getCuotaPago()) : $a_Fields['CuotaPago'] = ($this->getObjetoBean()->getCuotaPago()); endif;
      if($this->getObjetoBean()->getMoraAcumulada()) : $a_Fields['MoraAcumulada'] = ($this->getObjetoBean()->getMoraAcumulada()); endif;
      if($this->getObjetoBean()->getMoraAmortizada()) : $a_Fields['MoraAmortizada'] = ($this->getObjetoBean()->getMoraAmortizada()); endif;
      if($this->getObjetoBean()->getSaldoPrestamo()) : $a_Fields['SaldoPrestamo'] = ($this->getObjetoBean()->getSaldoPrestamo()); endif;
      if($this->getObjetoBean()->getFechaSaldoCero()) : $a_Fields['FechaSaldoCero'] = ($this->getObjetoBean()->getFechaSaldoCero()); endif;
      if($this->getObjetoBean()->getOrigen()) : $a_Fields['Origen'] = ($this->getObjetoBean()->getOrigen()); endif;
      if($this->getObjetoBean()->getEstado()) : $a_Fields['Estado'] = ($this->getObjetoBean()->getEstado()); endif;
      if($this->getObjetoBean()->getObservacion()) : $a_Fields['Observacion'] = ($this->getObjetoBean()->getObservacion()); endif;
      if($this->getObjetoBean()->getPeriodicidadPago()) : $a_Fields['PeriodicidadPago'] = ($this->getObjetoBean()->getPeriodicidadPago()); endif;
      if($this->getObjetoBean()->getFechaCancelacion()) : $a_Fields['FechaCancelacion'] = ($this->getObjetoBean()->getFechaCancelacion()); endif;
      if($this->getObjetoBean()->getIdPrestamoReferencia()) : $a_Fields['IdPrestamoReferencia'] = ($this->getObjetoBean()->getIdPrestamoReferencia()); endif;
      if($this->getObjetoBean()->getNroCuotas()) : $a_Fields['NroCuotas'] = ($this->getObjetoBean()->getNroCuotas()); endif;
      if($this->getObjetoBean()->getMontoExtra()) : $a_Fields['MontoExtra'] = ($this->getObjetoBean()->getMontoExtra()); endif;
      $a_Fields['Eliminado'] = '0';
	  
      if($this->getObjetoBean()->getIdPedidoReferencia()) : $a_Fields['idpedidoreferencia'] = ($this->getObjetoBean()->getIdPedidoReferencia()); endif;
      
      if($this->getObjetoBean()->getFechaEliminado()) : $a_Fields['FechaEliminado'] = ($this->getObjetoBean()->getFechaEliminado()); endif;
      if($this->getObjetoBean()->getUsuarioEliminado()) : $a_Fields['UsuarioEliminado'] = ($this->getObjetoBean()->getUsuarioEliminado()); endif;
      if($this->getObjetoBean()->getGastoAdministrativo()) : $a_Fields['GastoAdministrativo'] = ($this->getObjetoBean()->getGastoAdministrativo()); endif;
      
      if($this->getObjetoBean()->getGastoAdministrativoNP()) : $a_Fields['GastoAdministrativoNP'] = ($this->getObjetoBean()->getGastoAdministrativoNP()); endif;
      if($this->getObjetoBean()->getMoraNP()) : $a_Fields['MoraNP'] = ($this->getObjetoBean()->getMoraNP()); endif;
      
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getIdColaborador()) : $a_Fields['IdColaborador'] = ($this->getObjetoBean()->getIdColaborador()); endif;
      if($this->getObjetoBean()->getDuracion()) : $a_Fields['Duracion'] = ($this->getObjetoBean()->getDuracion()); endif;
	  
	  if($this->getObjetoBean()->getRegistroLatitud()) 	: $a_Fields['registrolatitud'] = ($this->getObjetoBean()->getRegistroLatitud()); endif;
	  if($this->getObjetoBean()->getRegistroLongitud()) : $a_Fields['registrolongitud'] = ($this->getObjetoBean()->getRegistroLongitud()); endif;
      
      $ultimoInteresMora = $this->getUltimoInteresMora($this->getObjetoBean()->getIdCliente());
      if($ultimoInteresMora) : $a_Fields['InteresMora'] = ($ultimoInteresMora); endif;
      
      $a_Fields['FlagReporte'] = '2';
           
      $sStringField = arrayClass::implode_keys(',', $a_Fields);
      $sStringValue = "'".implode("','", $a_Fields)."'";

      //$con = Conexion::getConexion();
      $sql = "INSERT INTO cr_prestamo (".$sStringField.")
                      VALUES (".$sStringValue.");";
	  	    
      $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      
      $idPrestamo = mysql_insert_id($con);
      
      
      

      $iResultSave = $idPrestamo;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

    
  }
  
 /**
  * Modifica un nuevo registro
  *
  * @return IdGenerado
  */
 public function TrasladoPrestamos($IdMercado='') {

   
      $con = Conexion::getConexion();
      $a_Fields = array();
     
     
      if($this->getObjetoBean()->getIdColaboradorDestino()) : $a_Fields['IdColaborador'] = ($this->getObjetoBean()->getIdColaboradorDestino()); endif;
     
      $sString = arrayClass::implode_key_value(",", $a_Fields);

      $sql = "UPDATE cr_prestamo SET
                  ".$sString."
            WHERE 1 AND IdColaborador= '".$this->getObjetoBean()->getIdColaborador()."'
              and Idcliente in (select IdCliente from cr_cliente where IdMercado = '".$IdMercado."') ";
     
      $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      
                 
      $iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

  }
  
    /**
  * Modifica un nuevo registro
  *
  * @return IdGenerado
  */
  public function update() {

    if($this->getObjetoBean()->getIdPrestamo()){
      $con = Conexion::getConexion();
      $a_Fields = array();
      
      if($this->getObjetoBean()->getIdPrestamo()) : $a_Fields['IdPrestamo'] = ($this->getObjetoBean()->getIdPrestamo()); endif;
      if($this->getObjetoBean()->getIdCliente()) : $a_Fields['IdCliente'] = ($this->getObjetoBean()->getIdCliente()); endif;

      if($this->getObjetoBean()->getIdMercado()) : $a_Fields['IdMercado'] = ($this->getObjetoBean()->getIdMercado()); endif;

      if($this->getObjetoBean()->getIdColaboradorPrestamo()) : $a_Fields['IdColaborador'] = ($this->getObjetoBean()->getIdColaboradorPrestamo()); endif;
      if($this->getObjetoBean()->getFechaInicio()) : $a_Fields['FechaInicio'] = ($this->getObjetoBean()->getFechaInicio()); endif;
      if($this->getObjetoBean()->getFechaVencimiento()) : $a_Fields['FechaVencimiento'] = ($this->getObjetoBean()->getFechaVencimiento()); endif;
      if($this->getObjetoBean()->getMontoPrestado()) : $a_Fields['MontoPrestado'] = ($this->getObjetoBean()->getMontoPrestado()); endif;
      if($this->getObjetoBean()->getInteresPorcentaje()) : $a_Fields['InteresPorcentaje'] = ($this->getObjetoBean()->getInteresPorcentaje()); endif;
      if($this->getObjetoBean()->getInteresMonto()) : $a_Fields['InteresMonto'] = ($this->getObjetoBean()->getInteresMonto()); endif;
      if($this->getObjetoBean()->getMontoTotal()) : $a_Fields['MontoTotal'] = ($this->getObjetoBean()->getMontoTotal()); endif;
      if($this->getObjetoBean()->getCuotaPago()) : $a_Fields['CuotaPago'] = ($this->getObjetoBean()->getCuotaPago()); endif;
      if($this->getObjetoBean()->getMoraAcumulada()) : $a_Fields['MoraAcumulada'] = ($this->getObjetoBean()->getMoraAcumulada()); endif;
      if($this->getObjetoBean()->getMoraAmortizada()) : $a_Fields['MoraAmortizada'] = ($this->getObjetoBean()->getMoraAmortizada()); endif;
      if($this->getObjetoBean()->getSaldoPrestamo()) : $a_Fields['SaldoPrestamo'] = ($this->getObjetoBean()->getSaldoPrestamo()); endif;
      if($this->getObjetoBean()->getSaldoMora()) : $a_Fields['SaldoMora'] = ($this->getObjetoBean()->getSaldoMora()); endif;
      if($this->getObjetoBean()->getInteresMora()) : $a_Fields['InteresMora'] = ($this->getObjetoBean()->getInteresMora()); endif;
      if($this->getObjetoBean()->getFechaSaldoCero()) : $a_Fields['FechaSaldoCero'] = ($this->getObjetoBean()->getFechaSaldoCero()); endif;
      if($this->getObjetoBean()->getOrigen()) : $a_Fields['Origen'] = ($this->getObjetoBean()->getOrigen()); endif;
      if($this->getObjetoBean()->getEstado()) : $a_Fields['cr_prestamo.Estado'] = ($this->getObjetoBean()->getEstado()); endif;
      if($this->getObjetoBean()->getObservacion()) : $a_Fields['cr_prestamo.Observacion'] = ($this->getObjetoBean()->getObservacion()); endif;
      if($this->getObjetoBean()->getPeriodicidadPago()) : $a_Fields['PeriodicidadPago'] = ($this->getObjetoBean()->getPeriodicidadPago()); endif;
      if($this->getObjetoBean()->getFechaCancelacion()) : $a_Fields['FechaCancelacion'] = ($this->getObjetoBean()->getFechaCancelacion()); endif;
      if($this->getObjetoBean()->getFechaNegociacion()) : $a_Fields['FechaNegMora'] = ($this->getObjetoBean()->getFechaNegociacion()); endif;
      if($this->getObjetoBean()->getFlagNegociacion()) : $a_Fields['FlagNegMora'] = ($this->getObjetoBean()->getFlagNegociacion()); endif;
      if($this->getObjetoBean()->getUsuarioNegociacion()) : $a_Fields['UsuarioNegMora'] = ($this->getObjetoBean()->getUsuarioNegociacion()); endif;
      
      
     
      if($this->getObjetoBean()->getIdPrestamoReferencia()) : $a_Fields['IdPrestamoReferencia'] = ($this->getObjetoBean()->getIdPrestamoReferencia()); endif;
      
      if($this->getObjetoBean()->getIdPedidoReferencia()) : $a_Fields['idpedidoreferencia'] = ($this->getObjetoBean()->getIdPedidoReferencia()); endif;
      
      if($this->getObjetoBean()->getNroCuotas()) : $a_Fields['NroCuotas'] = ($this->getObjetoBean()->getNroCuotas()); endif;
      if($this->getObjetoBean()->getMontoExtra()) : $a_Fields['MontoExtra'] = ($this->getObjetoBean()->getMontoExtra()); endif;
      $a_Fields['Eliminado'] = '0';
      if($this->getObjetoBean()->getFechaEliminado()) : $a_Fields['cr_prestamo.FechaEliminado'] = ($this->getObjetoBean()->getFechaEliminado()); endif;
      if($this->getObjetoBean()->getUsuarioEliminado()) : $a_Fields['cr_prestamo.UsuarioEliminado'] = ($this->getObjetoBean()->getUsuarioEliminado()); endif;
      if($this->getObjetoBean()->getGastoAdministrativo()) : $a_Fields['GastoAdministrativo'] = ($this->getObjetoBean()->getGastoAdministrativo()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['cr_prestamo.UsuarioCreacion'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['cr_prestamo.FechaCreacion'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getDuracion()) : $a_Fields['Duracion'] = ($this->getObjetoBean()->getDuracion()); endif;
      if($this->getObjetoBean()->getFechaModificacion()) : $a_Fields['cr_prestamo.FechaModificacion'] = ($this->getObjetoBean()->getFechaModificacion()); endif;
      if($this->getObjetoBean()->getUsuarioModificacion()) : $a_Fields['cr_prestamo.UsuarioModificacion'] = ($this->getObjetoBean()->getUsuarioModificacion()); endif;
      if($this->getObjetoBean()->getFlagReporte()) : $a_Fields['cr_prestamo.FlagReporte'] = ($this->getObjetoBean()->getFlagReporte()); endif;
      if($this->getObjetoBean()->getFlagContUtilidad()) : $a_Fields['FlagContUtilidad'] = ($this->getObjetoBean()->getFlagContUtilidad()); endif;
	  if($this->getObjetoBean()->getCalificacionUP()) : $a_Fields['CalificacionUP'] = ($this->getObjetoBean()->getCalificacionUP()); endif;
	  if($this->getObjetoBean()->getDescripcionUP()) : $a_Fields['DescripcionUP'] = ($this->getObjetoBean()->getDescripcionUP()); endif;
      if($this->getObjetoBean()->getColorUP()) : $a_Fields['ColorUP'] = ($this->getObjetoBean()->getColorUP()); endif;
      $a_Fields['flagCC'] = '-1';
      $sString = arrayClass::implode_key_value(",", $a_Fields);

      $sql = "UPDATE cr_prestamo SET
                  ".$sString."
            WHERE 1 AND IdPrestamo= '".$this->getObjetoBean()->getIdPrestamo()."' ";
     
     
      $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      
                  
      $iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

    }else{
      return false;
    }

  }
  
  /**
  * Elimina registro
  *
  * @return Boolean
  */
  public function delete(){
  	           
      $con = Conexion::getConexion();
      
      /*if($this->getObjetoBean()->getIdPrestamo()){
          $o_Cliente->setIdPrestamo($this->getObjetoBean()->getIdPrestamo());
      }*/
            
      $sql = "UPDATE cr_prestamo 
              SET
                Eliminado = '1',
                FechaEliminado = '".date('Y-m-d H:i:s')."',
                UsuarioEliminado = '".$this->getObjetoBean()->getUsuarioEliminado()."'
            WHERE IdPrestamo= '".$this->getObjetoBean()->getIdPrestamo()."' ";
      
      $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      
      $num_rows = mysql_affected_rows($con);
      
                  
      $iResultDelete = $num_rows;
      if($iResultDelete){
          return 1;
      }else{
          return false;
      }    
    
  }
  	
  	
    /*
      $o_Prestamo = new Prestamo();
      
      if($this->getObjetoBean()->getIdPrestamo()){
          $o_Prestamo->setIdPrestamo($this->getObjetoBean()->getIdPrestamo());
      }
      $iResultDelete = $o_Prestamo->delete();
      if($iResultDelete > 0){
          return true;
      }else{
          return false;
      }    
    */
  
  /**
  * Selecciona un nuevo registro
  *
  * @return IdGenerado
  */
public function select(){
      
    $where = "";
        
    $tamPag           = is_null($this->getObjetoBean()->tamPag)?999999:$this->getObjetoBean()->tamPag;
    $pagina           = is_null($this->getObjetoBean()->page)?1:$this->getObjetoBean()->page;
    $numeroRegistros  = $this->selectNumRows();
    $limitInf         = ($pagina-1)*$tamPag;
    
    $where = $this->buildConsult();
    $orden = $this->buildOrderByField();
     if(trim($orden) =='') $orden = "ORDER BY FlagReporte DESC,IdPrestamo DESC";
    $con = Conexion::getConexion();
   
	 $sql = "SELECT cr_prestamo.*
			   	FROM cr_prestamo
					LEFT JOIN cr_cliente ON cr_cliente.IdCliente = cr_prestamo.IdCliente
					LEFT JOIN cr_mercado ON cr_cliente.IdMercado = cr_mercado.IdMercado
					
            WHERE 1=1 ".$where." ".$orden." LIMIT ".$limitInf.",".$tamPag;
	//echo $sql;
	/*$sql = "SELECT cr_prestamo.*
			   	FROM cr_prestamo
					LEFT JOIN cr_cliente ON cr_cliente.IdCliente = cr_prestamo.IdCliente
					LEFT JOIN cr_mercado ON cr_cliente.IdMercado = cr_mercado.IdMercado
					
            WHERE cr_prestamo.Eliminado <> '1' ".$where." ".$orden." LIMIT ".$limitInf.",".$tamPag;*/
   
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    $num_rows = mysql_num_rows($result);
    
    $a_tmp = array();

    if($num_rows>0){
      while ($o_valor = mysql_fetch_object($result)) {
      $a_tmp[] = $this->insertarObjetoBean($o_valor);
      }
    }

    
   
    return count($a_tmp)>0?$a_tmp:null;
      
  }  
  
  public function selectSqlPedido(){
      
    $where = "";
        
    $tamPag           = is_null($this->getObjetoBean()->tamPag)?999999:$this->getObjetoBean()->tamPag;
    $pagina           = is_null($this->getObjetoBean()->page)?1:$this->getObjetoBean()->page;
    $numeroRegistros  = $this->selectNumRows();
    $limitInf         = ($pagina-1)*$tamPag;
    
    $where = $this->buildConsult();
    $orden = $this->buildOrderByField();
     if(trim($orden) =='') $orden = "ORDER BY FlagReporte DESC,IdPrestamo DESC";
    $con = Conexion::getConexion();
   
	 $sql = "SELECT cr_cliente.*
			   	FROM cr_prestamo
					LEFT JOIN cr_cliente ON cr_cliente.IdCliente = cr_prestamo.IdCliente
					LEFT JOIN cr_mercado ON cr_cliente.IdMercado = cr_mercado.IdMercado
					
            WHERE 1=1 ".$where." ".$orden." LIMIT ".$limitInf.",".$tamPag;
	return $sql;
  }  
  
  
  /*
  function ObtenerPago_1($IdPrestamo,$pos=1){
  	 $dia = date('N');
  	 if($dia == 1){
  	 	$FechaPago = date('Y-m-d',strtotime('-3 day'));
  	 }else{
  	 	$FechaPago = date('Y-m-d',strtotime('-2 day'));
  	 }
  	 $con = Conexion::getConexion();
  	  $sql = "	SELECT  sum(MontoPago) as Pago
				FROM cr_pago
    			WHERE IdPrestamo = '".$IdPrestamo."'
    			and MontoPago > 0 and FechaPago >= '$FechaPago'
    			group by FechaPago
    			";
    
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    $num_rows = mysql_num_rows($result);
    if($num_rows){
	    $i =1;
	    while ($o_valor = mysql_fetch_object($result)) {
	    	if($pos == $i) return $o_valor->Pago;
	    	$i++;
	    }
    }
  }*/
  
  public function selectTotalMonto(){
    
    $where = $this->buildConsult();
    
    $con = Conexion::getConexion();

	$sql = "SELECT sum(SaldoPrestamo) as MONTO
			FROM cr_prestamo
				LEFT JOIN cr_cliente ON cr_cliente.IdCliente = cr_prestamo.IdCliente
				LEFT JOIN cr_mercado ON cr_cliente.IdMercado = cr_mercado.IdMercado
     		WHERE 1=1 ".$where;


    /*$sql = "SELECT sum(SaldoPrestamo) as MONTO
			FROM cr_prestamo
				LEFT JOIN cr_cliente ON cr_cliente.IdCliente = cr_prestamo.IdCliente
				LEFT JOIN cr_mercado ON cr_cliente.IdMercado = cr_mercado.IdMercado
     		WHERE cr_prestamo.Eliminado <> '1'".$where;*/
   
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    $num_rows = mysql_num_rows($result);
    
     while ($o_valor = mysql_fetch_object($result)) {
      $monto_total = $o_valor->MONTO;
      }
    
    
   
    return $monto_total;
    
  }
 /* public function select(){
      
    $where = "";
    
    
    
    $con = Conexion::getConexion();
    $sql = "SELECT * FROM cr_prestamo WHERE 1 ".$where;
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    $num_rows = mysql_num_rows($result);

    $a_tmp = array();

    if($num_rows>0){
      while ($o_valor = mysql_fetch_object($result)) {
      $a_tmp[] = $this->insertarObjetoBean($o_valor);
      }
    }

    
   
    return count($a_tmp)>0?$a_tmp:null;
      
  }*/
  
  /**
  * Retorna un objeto PrestamoBean
  *
  * @return Object
  */
  public function selectByPk(){
     $where = $this->buildConsult();
    $con = Conexion::getConexion();
	
	 $sql = "SELECT cr_prestamo.*
					FROM cr_prestamo
					LEFT JOIN cr_cliente ON cr_cliente.IdCliente = cr_prestamo.IdCliente
					LEFT JOIN cr_mercado ON cr_cliente.IdMercado = cr_mercado.IdMercado
					
    		WHERE  1 = 1 and IdPrestamo = '".$this->getObjetoBean()->getIdPrestamo()."' $where";


    /*$sql = "SELECT cr_prestamo.*
					FROM cr_prestamo
					LEFT JOIN cr_cliente ON cr_cliente.IdCliente = cr_prestamo.IdCliente
					LEFT JOIN cr_mercado ON cr_cliente.IdMercado = cr_mercado.IdMercado
					
    		WHERE cr_prestamo.Eliminado <> '1' and IdPrestamo = '".$this->getObjetoBean()->getIdPrestamo()."' $where";*/
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    $o_Propel = $result ? mysql_fetch_object($result) : null;
    
    //echo $sql;
    /*
    LEFT JOIN cr_mercado_representante ON cr_cliente.IdMercado = cr_mercado_representante.IdMercado
				LEFT JOIN cr_colaborador ON cr_colaborador.IdColaborador = cr_mercado_representante.IdColaborador
    */
    return $o_Propel?$this->insertarObjetoBean($o_Propel):null;
  
  }


  public function selectByPk_eliminado(){
     $where = $this->buildConsult();
    $con = Conexion::getConexion();
	
	 $sql = "SELECT cr_prestamo.*
					FROM cr_prestamo
					LEFT JOIN cr_cliente ON cr_cliente.IdCliente = cr_prestamo.IdCliente
					LEFT JOIN cr_mercado ON cr_cliente.IdMercado = cr_mercado.IdMercado
					
    		WHERE  1 = 1 and IdPrestamo = '".$this->getObjetoBean()->getIdPrestamo()."'$where";


    /*$sql = "SELECT cr_prestamo.*
					FROM cr_prestamo
					LEFT JOIN cr_cliente ON cr_cliente.IdCliente = cr_prestamo.IdCliente
					LEFT JOIN cr_mercado ON cr_cliente.IdMercado = cr_mercado.IdMercado
					
    		WHERE cr_prestamo.Eliminado <> '1' and IdPrestamo = '".$this->getObjetoBean()->getIdPrestamo()."' $where";*/
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    $o_Propel = $result ? mysql_fetch_object($result) : null;
    
    //echo $sql;
    /*
    LEFT JOIN cr_mercado_representante ON cr_cliente.IdMercado = cr_mercado_representante.IdMercado
				LEFT JOIN cr_colaborador ON cr_colaborador.IdColaborador = cr_mercado_representante.IdColaborador
    */
    return $o_Propel?$this->insertarObjetoBean($o_Propel):null;
  
  }


  
  /**
  * Reasigna valores retornados del propel a un objeto PrestamoBean
  *
  * @param Object $o_Propel
  * @return PrestamoBean
  */
  private function insertarObjetoBean($o_Propel){

    $o_PrestamoBean = new PrestamoBean();
    
  
    $o_PrestamoBean->setIdPrestamo($o_Propel->IdPrestamo);
    $o_PrestamoBean->setIdCliente($o_Propel->IdCliente);
    $o_PrestamoBean->setFechaInicio($o_Propel->FechaInicio);
    $o_PrestamoBean->setFechaVencimiento($o_Propel->FechaVencimiento);
    $o_PrestamoBean->setMontoPrestado($o_Propel->MontoPrestado);
    $o_PrestamoBean->setInteresPorcentaje($o_Propel->InteresPorcentaje);
    $o_PrestamoBean->setInteresMonto($o_Propel->InteresMonto);
    $o_PrestamoBean->setMontoTotal($o_Propel->MontoTotal);
    $o_PrestamoBean->setCuotaPago($o_Propel->CuotaPago);
    $o_PrestamoBean->setMoraAcumulada($o_Propel->MoraAcumulada);
    $o_PrestamoBean->setMoraAmortizada($o_Propel->MoraAmortizada);
    $o_PrestamoBean->setSaldoPrestamo($o_Propel->SaldoPrestamo);
    $o_PrestamoBean->setFechaSaldoCero($o_Propel->FechaSaldoCero);
    $o_PrestamoBean->setOrigen($o_Propel->Origen);
    $o_PrestamoBean->setEstado($o_Propel->Estado);
    $o_PrestamoBean->setObservacion($o_Propel->Observacion);
    $o_PrestamoBean->setPeriodicidadPago($o_Propel->PeriodicidadPago);
    $o_PrestamoBean->setFechaCancelacion($o_Propel->FechaCancelacion);
    $o_PrestamoBean->setIdPrestamoReferencia($o_Propel->IdPrestamoReferencia);
    $o_PrestamoBean->setIdPedidoReferencia($o_Propel->idpedidoreferencia);
    $o_PrestamoBean->setNroCuotas($o_Propel->NroCuotas);
    $o_PrestamoBean->setMontoExtra($o_Propel->MontoExtra);
    $o_PrestamoBean->setEliminado($o_Propel->Eliminado);
    $o_PrestamoBean->setFechaEliminado($o_Propel->FechaEliminado);
    $o_PrestamoBean->setGastoAdministrativo($o_Propel->GastoAdministrativo);
    
    $o_PrestamoBean->setGastoAdministrativoNP($o_Propel->GastoAdministrativoNP);
    $o_PrestamoBean->setMoraNP($o_Propel->MoraNP);
       
    $o_PrestamoBean->setUsuarioNegociacion($o_Propel->UsuarioNegMora);
    $o_PrestamoBean->setFechaNegociacion($o_Propel->FechaNegMora);
    $o_PrestamoBean->setCondicion($o_Propel->condicion);
    $o_PrestamoBean->setFlagNegociacion($o_Propel->FlagNegMora);
    $o_PrestamoBean->setSaldoMora($o_Propel->SaldoMora);
    $o_PrestamoBean->setInteresMora($o_Propel->InteresMora);
	
    $o_PrestamoBean->setRegistroLatitud($o_Propel->registrolatitud);
    $o_PrestamoBean->setRegistroLongitud($o_Propel->registrolongitud);
        
    $o_PrestamoBean->setUsuarioCreacion($o_Propel->UsuarioCreacion);
    $o_PrestamoBean->setFechaCreacion($o_Propel->FechaCreacion);
    $o_PrestamoBean->setUsuarioModificacion($o_Propel->UsuarioModificacion);
    $o_PrestamoBean->setFechaModificacion($o_Propel->FechaModificacion); 
    $o_PrestamoBean->setUsuarioEliminado($o_Propel->UsuarioEliminado);
    $o_PrestamoBean->setDuracion($o_Propel->Duracion);     
    $o_PrestamoBean->setIdColaborador($o_Propel->IdColaborador);     
    $o_PrestamoBean->setMaxPago($this->ObtenerMaximoPago($o_Propel->IdPrestamo));
    $o_PrestamoBean->setNroPagos($this->ObtenerNroPagos($o_Propel->IdPrestamo));
    $o_PrestamoBean->setPago_1($this->ObtenerPago_1($o_Propel->IdPrestamo,1));
    $o_PrestamoBean->setPago_2($this->ObtenerPago_1($o_Propel->IdPrestamo,2));
    $o_PrestamoBean->setFlagReporte($o_Propel->FlagReporte);
    $o_PrestamoBean->setSemaforo($o_Propel->semaforo);
    $o_PrestamoBean->setCalificacionUP($o_Propel->CalificacionUP);
    $o_PrestamoBean->setDescripcionUP($o_Propel->DescripcionUP);
    $o_PrestamoBean->setColorUP($o_Propel->ColorUP);
	
	$o_PrestamoBean->setNombreCategoria($o_Propel->nombrecategoria);
    $o_PrestamoBean->setIdCategoria($o_Propel->idcategoria);
      
    $o_PrestamoBean->setFechaInicioPago($o_Propel->FechaInicioPago);
    
    return $o_PrestamoBean;    
    
  }
  
  function ObtenerMaximoPago($IdPrestamo){
  	 $con = Conexion::getConexion();
  	 $sql = "	SELECT max(MontoPago) as MaximoPago
				FROM cr_pago
    			WHERE IdPrestamo = '".$IdPrestamo."'";
    
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    while ($o_valor = mysql_fetch_object($result)) {
      return $o_valor->MaximoPago;
    }
  }
  
  function ObtenerNroPagos($IdPrestamo){
  	 $con = Conexion::getConexion();
  	 $sql = "	SELECT  sum(MontoPago)
				FROM cr_pago
    			WHERE IdPrestamo = '".$IdPrestamo."'
    			and MontoPago > 0
    			group by FechaPago
    			";
    
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
   
     return mysql_num_rows($result);
    
  }
  
  
  function ObtenerPago_1($IdPrestamo,$pos=1){
  	 $dia = date('N');
  	 if($dia == 1){
  	 	$FechaPago = date('Y-m-d',strtotime('-3 day'));
  	 }else{
  	 	$FechaPago = date('Y-m-d',strtotime('-2 day'));
  	 }
  	 $con = Conexion::getConexion();
  	  $sql = "	SELECT  max(FechaPago),sum(MontoPago) as Pago
				FROM cr_pago
    			WHERE IdPrestamo = '".$IdPrestamo."'
    			and FechaPago >= '$FechaPago'
    			group by FechaPago
				ORDER BY FechaPago DESC
				LIMIT 0 , 1
    			";
    
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    $num_rows = mysql_num_rows($result);
    if($num_rows){
	    $i =1;
	    while ($o_valor = mysql_fetch_object($result)) {
	    	if($pos == $i) return $o_valor->Pago;
	    	$i++;
	    }
    }
  }
  
  
  public function selectNumRows(){
    
    $where = $this->buildConsult();
    
    $con = Conexion::getConexion();
    //concat(cr_cliente.ApellidoPaterno,' ',cr_cliente.ApellidoMaterno,' ',cr_cliente.Nombres) as NombreCliente

	 $sql = "SELECT cr_prestamo.Estado
				FROM cr_prestamo
				LEFT JOIN cr_cliente ON cr_cliente.IdCliente = cr_prestamo.IdCliente
				LEFT JOIN cr_mercado ON cr_cliente.IdMercado = cr_mercado.IdMercado
				
    	WHERE 1 = 1 ".$where;

    /*$sql = "SELECT cr_prestamo.Estado
				FROM cr_prestamo
				LEFT JOIN cr_cliente ON cr_cliente.IdCliente = cr_prestamo.IdCliente
				LEFT JOIN cr_mercado ON cr_cliente.IdMercado = cr_mercado.IdMercado
				
    	WHERE cr_prestamo.Eliminado <> '1'".$where;*/
    //echo $sql;
    /*
    LEFT JOIN cr_mercado_representante ON cr_cliente.IdMercado = cr_mercado_representante.IdMercado
				LEFT JOIN cr_colaborador ON cr_colaborador.IdColaborador = cr_mercado_representante.IdColaborador
    */
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    $num_rows = mysql_num_rows($result);
    
    
   // echo $sql;
    return $num_rows;
    
  }
  
  public function selectUtilidades($periodo='diario'){
  	
  	if($periodo == "diario"){
  		$periodo = "IdColaborador,left(FechaCancelacion,10)";
  	}elseif($periodo == "mensual"){
  		$periodo = "IdColaborador,left(FechaCancelacion,7)";
  	}
  	$where = $this->buildConsult();
    
    $con = Conexion::getConexion();
    //concat(cr_cliente.ApellidoPaterno,' ',cr_cliente.ApellidoMaterno,' ',cr_cliente.Nombres) as NombreCliente
    $sql = "SELECT $periodo as Fecha,count(*) as cantidad, round(sum(InteresMonto),2) as total
				FROM cr_prestamo
				LEFT JOIN cr_cliente ON cr_cliente.IdCliente = cr_prestamo.IdCliente
				LEFT JOIN cr_mercado ON cr_cliente.IdMercado = cr_mercado.IdMercado
				
    		WHERE cr_prestamo.Eliminado <> '1' and SaldoPrestamo = 0 and cr_prestamo.estado = 'C' ".$where
    		." group by IdColaborador,$periodo " ;
   
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
  	 while ($o_valor = mysql_fetch_object($result)) {
      $a_utilidades[$o_valor->IdColaborador]['fecha'] = $o_valor->Fecha;
      $a_utilidades[$o_valor->IdColaborador]['cantidad'] = $o_valor->cantidad;
      $a_utilidades[$o_valor->IdColaborador]['total'] = $o_valor->total;
    }
    return $a_utilidades;
  }
  
  private function buildConsult(){
    
     $where = "";
    
    $where_eliminado = " AND cr_prestamo.Eliminado <> '1'";
    
    if($this->getObjetoBean()->getIdPrestamo()){
       $where .= " AND IdPrestamo  = '".$this->getObjetoBean()->getIdPrestamo()."'";
    }
    if($this->getObjetoBean()->getIdPrestamoReferencia()){
       $where .= " AND IdPrestamoReferencia  = '".$this->getObjetoBean()->getIdPrestamoReferencia()."'";
    }
    if($this->getObjetoBean()->getIdMercado()){
       $where .= " AND cr_cliente.IdMercado  = '".$this->getObjetoBean()->getIdMercado()."'";
    }
    if($this->getObjetoBean()->getDni()){
       $where .= " AND cr_cliente.dni  = '".$this->getObjetoBean()->getDni()."'";
    }
    
    if($this->getObjetoBean()->getReporte()){
       $where .= " AND NoReporteCobranza  = '0'";
    }
    
   //Nuevo
    if($this->getObjetoBean()->getIdMercados()){
       $where .= " AND cr_cliente.IdMercado   in ('".implode("','",$this->getObjetoBean()->getIdMercados())."')";
    }
    
     if($this->getObjetoBean()->getIdPedidoReferencia()){
       $where .= " AND cr_prestamo.idpedidoreferencia  = '".$this->getObjetoBean()->getIdPedidoReferencia()."'";
    }
    
    if($this->getObjetoBean()->getIdsPrestamos()){
       $where .= " AND IdPrestamo   in ('".implode("','",$this->getObjetoBean()->getIdsPrestamos())."')";
    }
    //fin Nuevo
    
    if($this->getObjetoBean()->getIdColaboradorPrestamo()){
       $where .= " AND cr_prestamo.IdColaborador  = '".$this->getObjetoBean()->getIdColaboradorPrestamo()."'";
    }
    
   
        
    if($this->getObjetoBean()->getIdCliente()){
       $where .= " AND cr_prestamo.IdCliente  = '".$this->getObjetoBean()->getIdCliente()."'";
    }
    if($this->getObjetoBean()->getEstado()){
        $where .= " AND cr_prestamo.Estado  = '".$this->getObjetoBean()->getEstado()."'";
    }
    if($this->getObjetoBean()->getEstados()){
        $where .= " AND cr_prestamo.Estado in ('".implode("','",$this->getObjetoBean()->getEstados())."')";
    }
    if($this->getObjetoBean()->getOrigen()){
        $where .= " AND cr_prestamo.Origen  = '".$this->getObjetoBean()->getOrigen()."'";
    }
   
    if($this->getObjetoBean()->getFechaSaldoCeroFin()){
      	 $where .= " AND FechaSaldoCero <= '".$this->getObjetoBean()->getFechaSaldoCeroFin()." 23:59:59'";
    }
    
    if($this->getObjetoBean()->getFechaSaldoCero()){
      	 $where .= " AND FechaSaldoCero >= '".$this->getObjetoBean()->getFechaSaldoCero()." 00:00:00' ";
    }

    
    if($this->getObjetoBean()->getFechaInicio()){
      	 $where .= " AND FechaInicio >= '".$this->getObjetoBean()->getFechaInicio()."'";
    }
    
    if($this->getObjetoBean()->getFechaFinal()){
      	 $where .= " AND FechaInicio <= '".$this->getObjetoBean()->getFechaFinal()."'";
    }
    if($this->getObjetoBean()->getFechaVencimiento()){
      	 $where .= " AND FechaVencimiento >= '".$this->getObjetoBean()->getFechaVencimiento()."'";
    }
    
    if($this->getObjetoBean()->getFechaFinalven()){
      	 $where .= " AND FechaVencimiento <= '".$this->getObjetoBean()->getFechaFinalven()."'";
    }
    
    if($this->getObjetoBean()->getFechaCancelacion()){
      	 $where .= " AND FechaCancelacion >= '".$this->getObjetoBean()->getFechaCancelacion()." 00:00:01'";
    }
    
     if($this->getObjetoBean()->getFechaCancelacionFin()){
      	 $where .= " AND FechaCancelacion <= '".$this->getObjetoBean()->getFechaCancelacionFin()." 23:59:59'";
    }
    
    if($this->getObjetoBean()->getFechaFinalcan()){
      	 $where .= " AND FechaCancelacion <= '".$this->getObjetoBean()->getFechaFinalcan()." 23:59:59'";
    }
    
    
    if($this->getObjetoBean()->getIdCliente()){
       $where .= " AND cr_cliente.IdCliente = '".$this->getObjetoBean()->getIdCliente()."'";
    }
    if($this->getObjetoBean()->getApellidoPaterno()){ 
   	   
       $where .= " AND ApellidoPaterno like '%".$this->getObjetoBean()->getApellidoPaterno()."%'";
    } 
    if($this->getObjetoBean()->getConMoraAcumulada()){ 
       $where .= " AND MoraAcumulada > '0'";
    }
	if($this->getObjetoBean()->getApellidoMaterno()){
       $where .= " AND ApellidoMaterno like '%".$this->getObjetoBean()->getApellidoMaterno()."%'";
    }
    if($this->getObjetoBean()->getNombres()){
       $where .= " AND Nombres like '%".$this->getObjetoBean()->getNombres()."%'";
    }
    if($this->getObjetoBean()->getNombreCompleto()){
      $where .= " AND NombreCompleto like '%".$this->getObjetoBean()->getNombreCompleto()."%'";
       
    }
    if(is_array($this->getObjetoBean()->getFiltroSucursal())){
      	 $where .= " AND cr_prestamo.IdColaborador in ('".implode("','",$this->getObjetoBean()->getFiltroSucursal())."')";
    }
    if(is_array($this->getObjetoBean()->getFiltroMercado())){
      	 $where .= " AND cr_cliente.IdMercado in ('".implode("','",$this->getObjetoBean()->getFiltroMercado())."')";
    }
    
    if($this->getObjetoBean()->getVencido()){
      	 $where .= " AND (cr_prestamo.Estado  = 'P' and cr_prestamo.FechaVencimiento < curdate())";
    }
      if($this->getObjetoBean()->getEliminado()){
      	 $where_eliminado = " AND cr_prestamo.Eliminado  = '1'";
    }
     if($this->getObjetoBean()->getFlagReporte()){
       $where .= " AND cr_prestamo.FlagReporte  = '".$this->getObjetoBean()->getFlagReporte()."'";
    }
   
    
     return $where_eliminado." ". $where;
    
  }
  
   public function buildOrderByField(){
    $order_by = "";
    if($this->getObjetoBean()->sortCampos || $this->getObjetoBean()->sortCampos != ""){
      $a_valCampos = explode(";", $this->getObjetoBean()->sortCampos);
      $a_valtype   = explode(";", $this->getObjetoBean()->sortType);
      $order_by = " ORDER BY ";
      $a_order = array();
      foreach ($a_valCampos as $key => $val){
        $sTmpOrder = "";
        if(array_key_exists($val, self::$fieldNames)){
          $sTmpOrder .= self::$fieldNames[$val];
          switch ($a_valtype[$key]){
            case 1: $sTmpOrder .= " ASC"; break;
            case 2: $sTmpOrder .= " DESC"; break;
          }
          $a_order[] = $sTmpOrder;
        }
      }
      $order_by .= implode(", ", $a_order);
    }
    return $order_by;
  }
  
  public function getUltimoInteresMora($idCliente){
  	 $con = Conexion::getConexion();
  	 $sql = "	SELECT InteresMora 
     			FROM cr_prestamo
     			where idcliente = '".$idCliente."' and eliminado='0' and estado = 'C'
     			order by idprestamo desc
     			limit 0,1
     		";
	    //echo $sql;
	    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
	    $num_rows = mysql_num_rows($result);
	    if($num_rows>0){
	      while ($o_valor = mysql_fetch_object($result)) {
	      	return $o_valor->InteresMora;
	      }
	    }
	    return false;
  }
  
	public function getTotalDiaAbierto($IdPrestamo,$fechaDiaAbierto){
  	 $con = Conexion::getConexion();
  	 $sql = "	SELECT sum(MontoPago) as MontoPago
     			FROM cr_pago
     			where idprestamo 		= '".$IdPrestamo."'
	     				and FechaPago 	= '".$fechaDiaAbierto."'
	     				and TipoPago  	= '1'
     		";
	    //echo $sql;
	    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
	    $num_rows = mysql_num_rows($result);
	    if($num_rows>0){
	      while ($o_valor = mysql_fetch_object($result)) {
	      	return $o_valor->MontoPago;
	      }
	    }
	    return false;
  }
  
	public function getNumeroPagosDiaAbierto($IdPrestamo,$fechaDiaAbierto){
		$con = Conexion::getConexion();
		$sql = "	SELECT MontoPago as MontoPago
				FROM cr_pago
				where idprestamo 		= '".$IdPrestamo."'
						and FechaPago 	= '".$fechaDiaAbierto."'
						and TipoPago  	= '1'
						and MontoPago > 0
			";
		//echo $sql;
		$result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
		$num_rows = mysql_num_rows($result);
		return $num_rows;
	}
	public function getUtimoPagoPrestamo($IdPrestamo,$fechaDiaAbierto){
		$con = Conexion::getConexion();
		$sql = "	SELECT FechaPago
				FROM cr_pago
				where idprestamo 		= '".$IdPrestamo."'
						and TipoPago  	= '1'
						and MontoPago > 0
				order by FechaPago desc
				limit 0,1
			";
		//echo $sql;
		$result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
		$num_rows = mysql_num_rows($result);
		if($num_rows > 0){
	    	while ($o_valor = mysql_fetch_object($result)) {
	    		return $o_valor->FechaPago;
	    	}
	    }
	    return "-";
	}
	public function getNumeroPagosPrestamo($IdPrestamo){
		$con = Conexion::getConexion();
		$sql = "	SELECT MontoPago as MontoPago
				FROM cr_pago
				where idprestamo 		= '".$IdPrestamo."'
						and TipoPago  	= '1'
			";
		//echo $sql;
		$result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
		
	    $num_rows = mysql_num_rows($result);
	    if($num_rows > 0){
	    	while ($o_valor = mysql_fetch_object($result)) {
	    		if($o_valor->MontoPago > 0){
	    			$c_pagos_ok++;
	    		}else{
	    			$c_pagos_cero++;
	    		}
	    	}
	    }
	    $a_resultado["pago_cero"] = $c_pagos_cero;
	    $a_resultado["pago_mayor_cero"] = $c_pagos_ok;
	    return $a_resultado;
		
	}
	
	public function getColorCategoria($idCategoria){
		$con = Conexion::getConexion();
		$sql = "	SELECT colordescripcion,codigo
				FROM cr_categoria_prestamo
				where idcategoria 		= '".$idCategoria."'
						
			";
		//echo $sql;
		$result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
		
	    $num_rows = mysql_num_rows($result);
	    if($num_rows > 0){
	    	while ($o_valor = mysql_fetch_object($result)) {
	    		$color = $o_valor->colordescripcion;
	    		$codigo = $o_valor->codigo;
	    		
	    	}
	    }
	    $a_resultado['color'] = $color;
	    $a_resultado['codigo'] = $codigo;
	   
	    return $a_resultado;
		
	}
  
   public function inicializarPagos($cboMercado,$fecha, $idColaborador){
  	 $con = Conexion::getConexion();
    
     $sql = "	SELECT idprestamo,fechainicio 
     			FROM cr_prestamo
     			where idcliente in (
     				SELECT idcliente 
     				FROM cr_cliente
     				where idmercado = '$cboMercado'
     			) and estado = 'P' and eliminado='0'
     		";
	    //echo $sql;
	    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
	    $num_rows = mysql_num_rows($result);
	    if($num_rows>0){
	      while ($o_valor = mysql_fetch_object($result)) {
				if($fecha > $o_valor->fechainicio){
					$sql = "	SELECT * 
			     			FROM cr_pago
			     			where idprestamo = $o_valor->idprestamo
			     			and fechaPago='".$fecha."'
			     		";
				    //echo $sql;
				    $result2 = mysql_db_query(Conexion::getNameDb(), $sql, $con);
				    $num_rows2 = mysql_num_rows($result2);
				    if($num_rows2 == 0){
				      
				      		$o_PagoBean = new PagoBean();
							$o_PagoBean->setIdPrestamo($o_valor->idprestamo);
							$o_PagoBean->setMontoPago("0.00");
							$o_PagoBean->setFechaPago($fecha);
							$o_PagoBean->setUsuarioCreacion(myUser::getUser()->getUserId());
							$o_PagoBean->setIdColaborador($idColaborador);
							$o_PagoBean->setFechaCreacion(date('Y-m-d H:i:s'));
							$o_PagoBL = new PagoBL();
							$o_PagoBL->insertarPago($o_PagoBean);
				      
				    }	
				}
	      	
	      }
	    }
  }
   public function updatePedidoGenerado($fechaDiaAbierto,$idpedido,$idprestamo,$ObservacionFinal){
  	 $con = Conexion::getConexion();
    
     $sql = "	UPDATE cr_pedido_prestamo
     			SET estado		='G',
     				idprestamoreferencia	='".$idprestamo."',
     				FechaEntrega	='".$fechaDiaAbierto."',
     				ObservacionFinal='".$ObservacionFinal."'
     			where idpedido ='".$idpedido."'
     		";
    //echo $sql;
	
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
	return $sql;
   
  }
  public function esPedidoGenerado($idpedido){
  	 $con = Conexion::getConexion();
    
      $sql = "	SELECT * 
			    FROM cr_pedido_prestamo
     			where idpedido ='".$idpedido."'
     				AND estado = 'G'
     		";
     		
    //echo $sql;
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    
    
    $num_rows = mysql_num_rows($result);
    if($num_rows > 0){
    	return true;
    }
    return false;
    
  }
   
     /**
  * Modifica un nuevo registro
  *
  * @return IdGenerado
  */
 public  function updateMove(){
  	$con = Conexion::getConexion();
  	
  	$a_Fields['IdColaborador'] = ($this->getObjetoBean()->getIdColaborador());
  	$sString = arrayClass::implode_key_value(",", $a_Fields);
  	$sql = "UPDATE cr_prestamo SET
                  ".$sString."
            WHERE 1 AND IdCliente= '".($this->getObjetoBean()->getIdCliente())."' ";
  	
  	$result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
  	
  	$iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }
  }
  
    /**
  * Modifica un nuevo registro
  *
  * @return IdGenerado
  */
  public  function updateMovePedido(){
  	$con = Conexion::getConexion();
  	
  	$a_Fields['IdColaborador'] = ($this->getObjetoBean()->getIdColaborador());
  	$a_Fields['IidMercado'] = ($this->getObjetoBean()->getIdMercado());
  	$sString = arrayClass::implode_key_value(",", $a_Fields);
  	$sql = "UPDATE cr_pedido_prestamo SET
                  ".$sString."
            WHERE 1 AND IdCliente= '".($this->getObjetoBean()->getIdCliente())."' ";
  	
  	$result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
  	
  	$iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }
  }
  
    /**
  * Modifica un nuevo registro
  *
  * @return IdGenerado
  */
  public  function updateMovePago($fecha,$IdRepresentante,$IdRepresentanteFinal,$idcliente){
  	$con = Conexion::getConexion();
  	
	if($IdRepresentanteFinal){
		$a_Fields['IdColaborador'] = ($IdRepresentanteFinal);
		
		$sString = arrayClass::implode_key_value(",", $a_Fields);
		
		$sql = "UPDATE cr_pago SET
					  ".$sString."
				WHERE 1 AND FechaPago= '".($fecha)."' and IdColaborador = '".($IdRepresentante)."' and idprestamo in (select idprestamo from cr_prestamo where idcliente='".$idcliente."')";
		
		$result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
		
		$iResultSave = $result;
		  if($iResultSave > 0){
			return $iResultSave;
		  }else{
			return false;
		  }
	}
  }
  
}?>