<?php

/**
* Clase Dispacher para Pago
*
* @package IM
* @subpackage PagoDP
* @author Willy
* @version SVN: : PagoDP.class.php,v 1.1 2009/06/14 15:00:47 Exp $
*/
class PagoDP implements interfaceDP {

	private static $fieldNames = array (
    'IdPago' => 'IdPago','FechaCreacion' => 'cr_pago.FechaCreacion'
	);
  protected $o_Bean;

  /**
  * Constructor donde asigna a un atributo el objeto PagoBean
  *
  * @param PagoBean $o_PagoBean
  */
  public function __construct(PagoBean $o_PagoBean){
  
    $this->o_Bean = $o_PagoBean;
    
  }
  
  /**
  * Retorna el objeto PagoBean
  *
  * @return Object
  */
  protected function getObjetoBean(){
  
    if(!$this->o_Bean){
        $this->o_Bean = new PagoBean();
    }        
    return $this->o_Bean;
    
  }
  
  /**
  * Ingresa un nuevo registro
  *
  * @return IdGenerado
  */
  public function save(){

      $con = Conexion::getConexion();
      $a_Fields = array();
     
      if($this->getObjetoBean()->getIdPrestamo()) : $a_Fields['IdPrestamo'] = ($this->getObjetoBean()->getIdPrestamo()); endif;
      if($this->getObjetoBean()->getMontoPago()) : $a_Fields['MontoPago'] = ($this->getObjetoBean()->getMontoPago()); endif;
      if($this->getObjetoBean()->getTipopago()) : $a_Fields['Tipopago'] = ($this->getObjetoBean()->getTipopago()); endif;
      if($this->getObjetoBean()->getRegistroLatitud()) : $a_Fields['registrolatitud'] = ($this->getObjetoBean()->getRegistroLatitud()); endif;
      if($this->getObjetoBean()->getRegistroLongitud()) : $a_Fields['registrolongitud'] = ($this->getObjetoBean()->getRegistroLongitud()); endif;
      if($this->getObjetoBean()->getFechaPago()) : $a_Fields['FechaPago'] = ($this->getObjetoBean()->getFechaPago()); endif;
      if($this->getObjetoBean()->getIdColaborador()) : $a_Fields['IdColaborador'] = ($this->getObjetoBean()->getIdColaborador()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getEstado()) : $a_Fields['Estado'] = ($this->getObjetoBean()->getEstado()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
                 
      $sStringField = arrayClass::implode_keys(',', $a_Fields);
      $sStringValue = "'".implode("','", $a_Fields)."'";
      
      $sql = "INSERT INTO cr_pago 
      				(".$sStringField.")
              VALUES 
                    (".$sStringValue.");";
      $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      //mysql_close($con);

      $idpago = mysql_insert_id($con);
      $iResultSave = $result;
      if($iResultSave > 0){
        return $idpago;
      }else{
        return false;
      }

    
  }
  
  
  public function TrasladoPagos() {
	
    
      
      $con = Conexion::getConexion();
      
      if($this->getObjetoBean()->getIdColaboradorDestino()) : $a_Fields['IdColaborador'] = ($this->getObjetoBean()->getIdColaboradorDestino()); endif;
     
      $sString = arrayClass::implode_key_value(",", $a_Fields);

      $sql = "	UPDATE cr_pago SET 
                  ".$sString."
            	WHERE IdColaborador = '".$this->getObjetoBean()->getIdColaborador()."'";
      
      $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      //mysql_close($con);

      $iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

    

  }
  
  
  /**
  * Modifica un nuevo registro
  *
  * @return IdGenerado
  */
  public function update() {
	
    if($this->getObjetoBean()->getIdPago()){
      
      $con = Conexion::getConexion();
      
      if($this->getObjetoBean()->getIdPago()) : $a_Fields['IdPago'] = ($this->getObjetoBean()->getIdPago()); endif;
      if($this->getObjetoBean()->getIdPrestamo()) : $a_Fields['IdPrestamo'] = ($this->getObjetoBean()->getIdPrestamo()); endif;
      if($this->getObjetoBean()->getMontoPago()) : $a_Fields['MontoPago'] = ($this->getObjetoBean()->getMontoPago()); endif;
      if($this->getObjetoBean()->getFechaPago()) : $a_Fields['FechaPago'] = ($this->getObjetoBean()->getFechaPago()); endif;
      if($this->getObjetoBean()->getEstado()) : $a_Fields['Estado'] = ($this->getObjetoBean()->getEstado()); endif;
	  if($this->getObjetoBean()->getRegistroLatitud()) : $a_Fields['registrolatitud'] = ($this->getObjetoBean()->getRegistroLatitud()); endif;
      if($this->getObjetoBean()->getRegistroLongitud()) : $a_Fields['registrolongitud'] = ($this->getObjetoBean()->getRegistroLongitud()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getUsuarioModificacion()) : $a_Fields['UsuarioModificacion'] = ($this->getObjetoBean()->getUsuarioModificacion()); endif;
      if($this->getObjetoBean()->getFechaModificacion()) : $a_Fields['FechaModificacion'] = ($this->getObjetoBean()->getFechaModificacion()); endif;
      $a_Fields['flagCC'] = '-1';
      $sString = arrayClass::implode_key_value(",", $a_Fields);

      $sql = "	UPDATE cr_pago SET 
                  ".$sString."
            	WHERE IdPago = '".$this->getObjetoBean()->getIdPago()."'";
      
      $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      //mysql_close($con);

      $iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

    }else{
      return false;
    }

  }
  
  /**
  * Elimina registro
  *
  * @return Boolean
  */
  public function delete(){
    /*
      $o_Pago = new Pago();
      
      if($this->getObjetoBean()->getIdPago()){
          $o_Pago->setIdPago($this->getObjetoBean()->getIdPago());
      }
      $iResultDelete = $o_Pago->delete();
      if($iResultDelete > 0){
          return true;
      }else{
          return false;
      }    
    */
  }
  /**
  * Selecciona un nuevo registro
  *
  * @return IdGenerado
  */
  public function select(){
      
    $where = "";
        
    $tamPag           = is_null($this->getObjetoBean()->tamPag)?999999:$this->getObjetoBean()->tamPag;
    $pagina           = is_null($this->getObjetoBean()->page)?1:$this->getObjetoBean()->page;
    $numeroRegistros  = $this->selectNumRows();
    $limitInf         = ($pagina-1)*$tamPag;
    
    $where = $this->buildConsult();
    $orden = $this->buildOrderByField();
    //if(!$orden) $orden = "order by FechaPago  desc";
    //if(trim($orden) =='') $orden = "ORDER BY FechaPago asc"; FechaInicio
    //if(trim($orden) =='') $orden = "ORDER BY cr_prestamo.IdPrestamo desc,FechaPago asc"; 
    if(trim($orden) =='') $orden = "ORDER BY cr_prestamo.IdPrestamo desc"; 
    $con = Conexion::getConexion();
    $sql = "SELECT *,cr_pago.UsuarioCreacion as UsuarioCreacion,cr_pago.FechaCreacion as FechaCreacion,cr_pago.UsuarioModificacion as UsuarioModificacion,cr_pago.FechaModificacion as FechaModificacion,cr_pago.IdColaborador as IdColaborador,cr_pago.registrolatitud as registrolatitud,cr_pago.registrolongitud as registrolongitud
    		FROM cr_pago
            LEFT JOIN cr_prestamo ON cr_pago.IdPrestamo = cr_prestamo.IdPrestamo
            LEFT JOIN cr_cliente ON cr_prestamo.IdCliente = cr_cliente.IdCliente
             LEFT JOIN cr_mercado ON cr_cliente .IdMercado = cr_mercado.IdMercado  
            WHERE cr_prestamo.Eliminado = 0 ".$where." ".$orden." LIMIT ".$limitInf.",".$tamPag;
    //echo $sql;
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    $num_rows = mysql_num_rows($result);
    //echo $sql;
    $a_tmp = array();

    if($num_rows>0){
      while ($o_valor = mysql_fetch_object($result)) {
      $a_tmp[] = $this->insertarObjetoBean($o_valor);
      }
    }

    //mysql_close($con);
   
    return count($a_tmp)>0?$a_tmp:null;
      
  }  

  
  /**
  * Retorna un objeto PagoBean
  *
  * @return Object
  */
  public function selectByPk(){
  
    $con = Conexion::getConexion();
    $sql = "SELECT * FROM cr_pago
            LEFT JOIN cr_prestamo ON cr_pago.IdPrestamo = cr_prestamo.IdPrestamo 
           WHERE cr_pago.IdPago = '".$this->getObjetoBean()->getIdPago()."' ";
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    $o_Propel = $result ? mysql_fetch_object($result) : null;
    //mysql_close($con);

    return $o_Propel?$this->insertarObjetoBean($o_Propel):null;
  
  }
  
  /**
  * Reasigna valores retornados del propel a un objeto PagoBean
  *
  * @param Object $o_Propel
  * @return PagoBean
  */
  private function insertarObjetoBean($o_Propel){

    $o_PagoBean = new PagoBean();
    
    $o_PagoBean->setIdPago($o_Propel->IdPago);
    $o_PagoBean->setIdPrestamo($o_Propel->IdPrestamo);
    $o_PagoBean->setMontoPago($o_Propel->MontoPago);
    $o_PagoBean->setTipopago($o_Propel->Tipopago);
    $o_PagoBean->setFechaPago($o_Propel->FechaPago);
    $o_PagoBean->setEstado($o_Propel->Estado);
    $o_PagoBean->setTipo($o_Propel->TipoPago);
    $o_PagoBean->setTipoPago($o_Propel->TipoPago);
	$o_PagoBean->setIdColaborador($o_Propel->IdColaborador);
    $o_PagoBean->setRegistroLatitud($o_Propel->registrolatitud);
    $o_PagoBean->setRegistroLongitud($o_Propel->registrolongitud);
    $o_PagoBean->setUsuarioCreacion($o_Propel->UsuarioCreacion);
    $o_PagoBean->setFechaCreacion($o_Propel->FechaCreacion);
    $o_PagoBean->setUsuarioModificacion($o_Propel->UsuarioModificacion);
    $o_PagoBean->setFechaModificacion($o_Propel->FechaModificacion);
    $o_PagoBean->setDescripcion($o_Propel->Descripcion);
         
    return $o_PagoBean;
 
  }
  
  public function selectNumRows(){
    
    $where = $this->buildConsult();
    
    $con = Conexion::getConexion();
    
    $sql = "SELECT cr_pago.IdPrestamo FROM cr_pago
            LEFT JOIN cr_prestamo ON cr_pago.IdPrestamo = cr_prestamo.IdPrestamo
            LEFT JOIN cr_cliente ON cr_prestamo.IdCliente = cr_cliente.IdCliente 
            LEFT JOIN cr_mercado ON cr_cliente .IdMercado = cr_mercado.IdMercado 
           WHERE cr_prestamo.Eliminado <> '1'".$where;
     
	 
	$con = Conexion::getConexion();
	$a_param = Conexion::getParamDbByAlias($apps);
	
	
	if (!mysql_select_db($a_param['db'], $con)) {
		echo 'Could not select database';
		exit;
	} 
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    $num_rows = mysql_num_rows($result);
    
    //mysql_close($con);
    //echo $sql;
    return $num_rows;
    
  }
  
  private function buildConsult(){
    
    $where = "";
    
     if($this->getObjetoBean()->getIdPrestamo()){
       $where .= " AND cr_pago.IdPrestamo  = '".$this->getObjetoBean()->getIdPrestamo()."'";
    }
    
    if($this->getObjetoBean()->getIdPago()){
       $where .= " AND cr_pago.IdPago  = '".$this->getObjetoBean()->getIdPago()."'";
    }
     if($this->getObjetoBean()->getTipo()){
       $where .= " AND cr_pago.Tipopago  = '".$this->getObjetoBean()->getTipo()."'";
    }
    if($this->getObjetoBean()->getIdMercado()){
       $where .= " AND cr_cliente.IdMercado  = '".$this->getObjetoBean()->getIdMercado()."'";
    }
    if($this->getObjetoBean()->getEstado()){
        $where .= " AND cr_prestamo.Estado  = '".$this->getObjetoBean()->getEstado()."'";
    }
     if($this->getObjetoBean()->getFechaPago()){
      	 $where .= " AND FechaPago >= '".$this->getObjetoBean()->getFechaPago()."'";
    }
    
    if($this->getObjetoBean()->getFechaFinal()){
      	 $where .= " AND FechaPago <= '".$this->getObjetoBean()->getFechaFinal()."'";
    }
    if($this->getObjetoBean()->getIdColaborador()){
       $where .= " AND cr_pago.IdColaborador= '".$this->getObjetoBean()->getIdColaborador()."'";
    }
    if($this->getObjetoBean()->getIdPrestamo()){
       $where .= " AND cr_prestamo.idPrestamo= '".$this->getObjetoBean()->getIdPrestamo()."'";
    }
	if($this->getObjetoBean()->getIdColaboradorPrestamo()){
       $where .= " AND cr_prestamo.IdColaborador= '".$this->getObjetoBean()->getIdColaboradorPrestamo()."'";
    }
    if(is_array($this->getObjetoBean()->getIdColaboradores())){
      	 $where .= " AND cr_pago.IdColaborador in ('".implode("','",$this->getObjetoBean()->getIdColaboradores())."')";
    }
    if($this->getObjetoBean()->getApellidoPaterno()){
       $where .= " AND ApellidoPaterno like '%".$this->getObjetoBean()->getApellidoPaterno()."%'";
    }
	if($this->getObjetoBean()->getApellidoMaterno()){
       $where .= " AND ApellidoMaterno like '%".$this->getObjetoBean()->getApellidoMaterno()."%'";
    }
    if($this->getObjetoBean()->getNombres()){
       $where .= " AND Nombres like '%".$this->getObjetoBean()->getNombres()."%'";
    }  
    return $where;
    //echo $where;
    
  }
  
   public function buildOrderByField(){
    $order_by = "";
    if($this->getObjetoBean()->sortCampos || $this->getObjetoBean()->sortCampos != ""){
      $a_valCampos = explode(";", $this->getObjetoBean()->sortCampos);
      $a_valtype   = explode(";", $this->getObjetoBean()->sortType);
      $order_by = " ORDER BY ";
      $a_order = array();
      foreach ($a_valCampos as $key => $val){
        $sTmpOrder = "";
        if(array_key_exists($val, self::$fieldNames)){
          $sTmpOrder .= self::$fieldNames[$val];
          switch ($a_valtype[$key]){
            case 1: $sTmpOrder .= " ASC"; break;
            case 2: $sTmpOrder .= " DESC"; break;
          }
          $a_order[] = $sTmpOrder;
        }
      }
      $order_by .= implode(", ", $a_order);
    }
    return $order_by;
  }
    
}

