<?php 
function procesarSemaforo($cadena){
	$cadenaV='<div style="border-radius: 50%;width: 20px;height: 20px;background:green;float:left;margin-right:1px;" title="No tienes deudas vencidas a la fecha."></div>'; 
	$cadenaR='<div style="border-radius: 50%;width: 20px;height: 20px;background:red;float:left;margin-right:1px;" title="Tienes deudas con poco atraso."></div>'; 
	$cadenaA='<div style="border-radius: 50%;width: 20px;height: 20px;background:yellow;float:left;margin-right:1px;" title="Tienes deudas vencidas a la fecha"></div>';
	$cadenaM='<div style="border-radius: 50%;width: 20px;height: 20px;background:#FFFFCC;float:left;margin-right:1px;" title="Tienes deudas vencidas con poco atraso."></div>';
	$cadenaG='<div style="border-radius: 50%;width: 20px;height: 20px;background:gray;float:left;margin-right:1px;" title="No tienes deudas reportadas a la fecha."></div>';
	
	//$cadenaM='<div style="border-radius: 50%;width: 20px;height: 20px;background:linear-gradient(to right, yellow 0%, yellow 50%, green 50%);"></div>'; 
	 
	
	$cadena = str_replace("V",$cadenaV,$cadena);
	
	$cadena = str_replace("A",$cadenaA,$cadena);
	$cadena = str_replace("M",$cadenaM,$cadena);
	
	$cadena = str_replace("O",$cadenaR,$cadena);
	$cadena = str_replace("R",$cadenaR,$cadena);
	$cadena = str_replace("G",$cadenaG,$cadena);
	return $cadena;
}

function curl_get_contents_alternativo($url,$dni,$sentinel=0,$refresh=0)
{
  if($refresh)
  {
      $c_refresh = "&refresh=true";    
  }
  if($sentinel){
  	$url_f = 'https://reniec.softdatamen.com/api/sentinel/summary/'.$dni.'?api_token=$2y$10$yDyLb7t3v0vollkC50F.9e7EXRotlnfpp0tBy9ou5Et.PYFUlWmb2'.$c_refresh;
  }else{
  	$url_f = 'https://reniec.softdatamen.com/api/reniec/dni/'.$dni.'?api_token=$2y$10$yDyLb7t3v0vollkC50F.9e7EXRotlnfpp0tBy9ou5Et.PYFUlWmb2'.$c_refresh;
  }
  	
  $curl = curl_init();

	curl_setopt_array($curl, array(
	  CURLOPT_URL => $url_f,
	  CURLOPT_RETURNTRANSFER => true,
	  CURLOPT_ENCODING => '',
	  CURLOPT_MAXREDIRS => 10,
	  CURLOPT_TIMEOUT => 0,
	  CURLOPT_FOLLOWLOCATION => true,
	  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	  CURLOPT_CUSTOMREQUEST => 'GET',
	  CURLOPT_HTTPHEADER => array(
	    'Content-Type: text/plain'
	  ),
	));
	$response = curl_exec($curl);
	
	curl_close($curl);
	return $response;
}


function rucValido($ruc) {
    //11 dígitos y empieza en 10,15,16,17 o 20
    $ruce = substr($ruc,0, 2);
    if (!($ruce >= 10 && $ruce < 11
       || $ruce >= 15 && $ruce < 18
       || $ruce >= 20 && $ruce < 21))
        return false;
   
    $dig01 = substr($ruc,0, 1)*5;
    $dig02 = substr($ruc,1, 1)*4;
    $dig03 = substr($ruc,2, 1)*3;
    $dig04 = substr($ruc,3, 1)*2;
    $dig05 = substr($ruc,4, 1)*7;
    $dig06 = substr($ruc,5, 1)*6;
    $dig07 = substr($ruc,6, 1)*5;
    $dig08 = substr($ruc,7, 1)*4;
    $dig09 = substr($ruc,8, 1)*3;
    $dig10 = substr($ruc,9, 1)*2;
    
    $dig11 = substr($ruc,10, 1);

    $suma = $dig01 + $dig02 + $dig03 + $dig04 + $dig05 + $dig06 + $dig07 + $dig08 + $dig09 + $dig10;
    $residuo = $suma%11;
    $resta = 11 - $residuo;

    $digChk = 0;
    if ($resta == 10)
    {
        $digChk = 0;
    }
    elseif($resta == 11)
    {
        $digChk = 1;
    }
    else
    {
        $digChk = $resta;
    }

    if ($dig11 == $digChk)
    {
        return true;
    }
    else
    {
        return false;
    }
}
function unicodeToutf8($str){
    $repl = array ('\u00e1','\u00e9','\u00ed','\u00f3','\u00fa','\u00f1','\u00c1','\u00c9','\u00cd','\u00d3','\u00da','\u00d1');
    $with = array ('á','é','í','ó','ú','ñ','Á','É','Í','Ó','Ú','Ñ');
    return str_replace($repl,$with,$str);
}

function ultimaMoraPagada($idcliente,$idprestamo){
	$con = Conexion::getConexion();
	
	
	$sql = "	SELECT 	idprestamo 
				FROM 	cr_prestamo
				WHERE 1 = 1
					AND IdPrestamo 	<> '".$idprestamo."'
					AND idcliente 	= '".$idcliente."'
					AND eliminado 	= '0'
					AND estado 		= 'C'
				ORDER BY idprestamo desc
				LIMIT 0,1
				";
	
	$resultP = mysql_db_query(Conexion::getNameDb(), $sql, $con);
	
	if($resultP){
  		if(mysql_num_rows($resultP) > 0 ){
				while ($rowP = mysql_fetch_array($resultP)){
	
					$IdPrestamo = $rowP['idprestamo'];
	
					$sql = "	SELECT 	Sum(cr_pago.MontoPago) as SumaMP
								FROM 	cr_pago
								WHERE 1 = 1
									AND IdPrestamo in (".$IdPrestamo.")
									AND TipoPago = '2'
								";
					
					$result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
					
					if($result){
				  		if(mysql_num_rows($result) > 0 ){
								while ($row = mysql_fetch_array($result)){
						  			return round($row['SumaMP'],2);
								}
				  		}
				  	}else{
				  		return 0;
				  	}
				}
  		}
	}
}

function getEstadoCondicion($idestado){
  $desc_estado = Constantes::$a_condicionPrestamo[$idestado];
  return $desc_estado;
}


function diferenciaDates($dFecFin, $dFecIni)
{
    $dFecIni = str_replace("-","",$dFecIni);
    $dFecIni = str_replace("/","",$dFecIni);
    $dFecFin = str_replace("-","",$dFecFin);
    $dFecFin = str_replace("/","",$dFecFin);

    ereg( "([0-9]{2,4})([0-9]{1,2})([0-9]{1,2})", $dFecIni, $aFecIni);
    ereg( "([0-9]{2,4})([0-9]{1,2})([0-9]{1,2})", $dFecFin, $aFecFin);

    $date1 = mktime(0,0,0,$aFecIni[2], $aFecIni[3], $aFecIni[1]);
    $date2 = mktime(0,0,0,$aFecFin[2], $aFecFin[3], $aFecFin[1]);

    return round(($date2 - $date1) / (60 * 60 * 24));
}

function array_sort($array, $on, $order=SORT_ASC)
{
    $new_array = array();
    $sortable_array = array();

    if (count($array) > 0) {
        foreach ($array as $k => $v) {
            if (is_array($v)) {
                foreach ($v as $k2 => $v2) {
                    if ($k2 == $on) {
                        $sortable_array[$k] = $v2;
                    }
                }
            } else {
                $sortable_array[$k] = $v;
            }
        }

        switch ($order) {
            case SORT_ASC:
                asort($sortable_array);
            break;
            case SORT_DESC:
                arsort($sortable_array);
            break;
        }

        foreach ($sortable_array as $k => $v) {
            $new_array[$k] = $array[$k];
        }
    }

    return $new_array;
}

function fnroundesp( $num, $d=0 )
{
	$num = sprintf("%.4f",$num);
	$d = pow(10, $d);
	
	if($num == 0){
    $sgn = 0;
	}else if($num > 0){
    $sgn = 1;
	}else{
    $sgn = -1;
	}
	
	$v1 = intval((string)($num*$d + $sgn*.5));
	return ($v1/$d);
}

function getPermisoColaborador($idColaborador,$IdcolaboradorTrx){
	if($IdcolaboradorTrx != $idColaborador){
		?>
		<script>
			alert('Requiere volver a loguearse');
 			parent.document.location.href = '<?php echo buildUrlComplet('sys.php/user/logout')?>	
		</script>
		<?php 
		exit;
	}
}

function getPermisoColaboradorMercado($idColaborador,$IdMercado){
	$o_MercadoColaborador = new MercadoRepresentanteBean();
	$o_MercadoColaborador->setIdColaborador($idColaborador);
	$o_MercadoColaborador->setIdMercado($IdMercado);
	$o_MercadoColaboradorDP = new MercadoRepresentanteDP($o_MercadoColaborador);
	$a_MercadoRepresentante = $o_MercadoColaboradorDP->select();
	if(!is_array($a_MercadoRepresentante)){
			?>
			<script>
				alert('Requiere volver a loguearse');
	 			parent.document.location.href = '<?php echo buildUrlComplet('sys.php/user/logout')?>	
			</script>
			<?php 
			exit;
		
	}
}

function getPermisoColaboradorMercadoAjax($idColaborador,$IdMercado){
	$o_MercadoColaborador = new MercadoRepresentanteBean();
	$o_MercadoColaborador->setIdColaborador($idColaborador);
	$o_MercadoColaborador->setIdMercado($IdMercado);
	$o_MercadoColaboradorDP = new MercadoRepresentanteDP($o_MercadoColaborador);
	$a_MercadoRepresentante = $o_MercadoColaboradorDP->select();
	if(is_array($a_MercadoRepresentante)){
		return true;
	}else{
		return false;
	}
}

/******************** PARA REPORTES SEMANALES ****************/

function datosFechaMes ($ano, $mes, $a_dm) {
	$numeroSemanas 	= $a_dm['numeroSemanas'];
	$primeraFecha 	= new DateTime("$ano-$mes-01");
	$dataPrimeraFecha 	= new DateTime("$ano-$mes-01");
	$dataFinMes 	= new DateTime($primeraFecha->format('Y-m-t'));
	$ultimaFecha 	= $dataFinMes->format('Y-m-d');
	$primerDia 		= $primeraFecha->format('N');
	
	if($primerDia == '7'){ //Primer dia es Domingo
		$numeroSemanas = $numeroSemanas -1;
		$dataPrimeraFecha = new DateTime("$ano-$mes-02");
	}
	$primeraFecha = $dataPrimeraFecha->format('Y-m-d');
	$fecha1_t = $primeraFecha;
	$flag = true;
	for($i=1; $i<=$numeroSemanas;$i++){
		$fecha1 = $fecha1_t;
		$dia = date('w',strtotime($fecha1));
		if($dia == '6' && $i ==1){
			$fecha1 = $fecha1_t;
			$fecha2 = $fecha1_t;
			$flag = false;
		}
		while($flag){
			
			$fecha1_t = date('Y-m-d',strtotime($fecha1_t ."+1 day"));
			$dia = date('w',strtotime($fecha1_t));
			if($dia == '6'){
				$fecha2 = $fecha1_t;
				break;
			}
			if($dia == '1'){
				$fecha1 = $fecha1_t;
			}
			if($fecha1_t == $ultimaFecha){
				$fecha2 = $ultimaFecha;
				break;
			}
		}
		$flag = true;
		$a_semana[$i]['f1'] = $fecha1;
		$a_semana[$i]['f2'] = $fecha2;
	}
	return $a_semana;
}

function datosMes ($ano, $mes) {

    $data = new DateTime("$ano-$mes-01");
    $dataFimMes = new DateTime($data->format('Y-m-t'));
	
	$primerDia = $data->format('N');
	$ultimoDia = $dataFimMes->format('N');
		
    $numSemanaInicio = $data->format('W');
    $numSemanaFinal  = $dataFimMes->format('W') + 1;

    // �ltima semana do ano pode ser semana 1
	//echo $numSemanaFinal." < ".$numSemanaInicio;
    if($numSemanaInicio == 53 && $mes == "01") $numeroSemanas = $numSemanaFinal;
	else  $numeroSemanas = ($numSemanaFinal < $numSemanaInicio)  ? (52 + $numSemanaFinal) - $numSemanaInicio : $numSemanaFinal - $numSemanaInicio;
    $a_dm['primerFecha'] = $data->format('Y-m-d');
	$a_dm['ultimoFecha'] = $data->format('Y-m-t');
	$a_dm['primerDia'] = $primerDia;
	$a_dm['ultimoDia'] = $ultimoDia;
	$a_dm['numeroSemanas'] = $numeroSemanas;
	
	
    return $a_dm;
}


function getDimensiones($idsucursal =1 , $primeraFecha,$ultimaFecha){
	$con = Conexion::getConexion();
	$sql = "SELECT idsucursal,idmercado,idcolaborador,nombresucursal,nombremercado,nombrerepresentante
			FROM `dw_matriz`
			WHERE 1 and fecha >= '".$primeraFecha."' and fecha <= '".$ultimaFecha."' and idsucursal = '".$idsucursal."'
			GROUP BY idsucursal,idmercado,idcolaborador
			 ";
		
	$result = mysql_query($sql,$con);
	
	$num_rows = mysql_num_rows($result);
	    
	
	if($num_rows > 0){
	  $i = 1;
	  while ($o_valor = mysql_fetch_object($result)) {
	  	$a_colaboradores[$i]['idsucursal'] = $o_valor->idsucursal;
	  	$a_colaboradores[$i]['idmercado'] = $o_valor->idmercado;
	  	$a_colaboradores[$i]['idcolaborador'] = $o_valor->idcolaborador;
	  	$a_colaboradores[$i]['nombresucursal'] = $o_valor->nombresucursal;
	  	$a_colaboradores[$i]['nombremercado'] = $o_valor->nombremercado;
	  	$a_colaboradores[$i]['nombrerepresentante'] = $o_valor->nombrerepresentante;
	  	$i++;
	  }
	}
	return $a_colaboradores;
}

function getDimensionesDiario($idsucursal =1 , $primeraFecha,$ultimaFecha){
	$con = Conexion::getConexion();
	$sql = "SELECT idsucursal,idmercado,idcolaborador,nombresucursal,nombremercado,nombrerepresentante
			FROM `dw_matriz`
			WHERE 1 and fecha >= '".$primeraFecha."' and fecha <= '".$ultimaFecha."' and idsucursal = '".$idsucursal."'
			GROUP BY idsucursal,idmercado,idcolaborador
			order by 5
			 ";
	//echo $sql;	
	$result = mysql_query($sql,$con);
	
	$num_rows = mysql_num_rows($result);
	    
	
	if($num_rows > 0){
	  $i = 1;
	  while ($o_valor = mysql_fetch_object($result)) {
	  	$a_colaboradores[$i]['idsucursal'] = $o_valor->idsucursal;
	  	$a_colaboradores[$i]['idmercado'] = $o_valor->idmercado;
	  	$a_colaboradores[$i]['idcolaborador'] = $o_valor->idcolaborador;
	  	$a_colaboradores[$i]['nombresucursal'] = $o_valor->nombresucursal;
	  	$a_colaboradores[$i]['nombremercado'] = $o_valor->nombremercado;
	  	$a_colaboradores[$i]['nombrerepresentante'] = $o_valor->nombrerepresentante;
	  	$i++;
	  }
	}
	return $a_colaboradores;
}



/*
echo "<pre>";
print_r($a_semana);
echo "</pre>";
*/

function pintar_dw($ind,$idsucursal,$idmercado,$idcolaborador,$fecha){
	$con = Conexion::getConexion();
	$sql = "SELECT ind_".$ind." as valor ,id_pre_".$ind." as elementos
			FROM `dw_matriz`
			WHERE 1 
				and idsucursal = '".$idsucursal."' 
				and idmercado = '".$idmercado."' 
				and idcolaborador = '".$idcolaborador."' 
				and fecha = '".$fecha."' 
			 ";
		
	$result = mysql_query($sql,$con);
	
	$num_rows = mysql_num_rows($result);
	    
	
	if($num_rows > 0){
	 
	  while ($o_valor = mysql_fetch_object($result)) {
	  	$a_result['valor'] = $o_valor->valor;
	  	$a_elementos = array();
	  	if($o_valor->elementos){
	  		$a_elementos = explode(",",$o_valor->elementos);
	  	}
	  	$a_result['cantidad'] = count($a_elementos);
	  }
	}
	return $a_result;
	
}

function pintar_dw_diario($ind,$idsucursal,$idmercado,$idcolaborador,$fecha,$fechafin){
	$con = Conexion::getConexion();
	$sql = "SELECT ind_".$ind." as valor ,id_pre_".$ind." as elementos
			FROM `dw_matriz`
			WHERE 1 
				and idsucursal = '".$idsucursal."' 
				and idmercado = '".$idmercado."' 
				and idcolaborador = '".$idcolaborador."' 
				and fecha >= '".$fecha."' 
				and fecha <= '".$fechafin."' 
			 ";
	//echo $sql;	
	$result = mysql_query($sql,$con);
	
	$num_rows = mysql_num_rows($result);
	    
	
	if($num_rows > 0){
	 $a_elementos = array();
	 $i = 1;
	 	while ($o_valor = mysql_fetch_object($result)) {
		  	$a_result['valor'] += $o_valor->valor;
		  	
		  	if($o_valor->elementos){
		  		if($i == 1) $elementos = $o_valor->elementos;
		  		else $elementos .= ",".$o_valor->elementos;
		  		$i++;
		  	}
		  	
		  }
	  if($elementos) $a_elementos = explode(",",$elementos);
	  $a_result['cantidad'] = count($a_elementos);
	}
	return $a_result;
	
}


function pintarReporte($ind = "cn",$a_dimensiones,$a_semana,$a_dia,$a_diaT,$a_dm,$f_sumatoria = 1, $f_cantidad = 1,$pdf = 0, $excel = 0,$operacion_subtotal = "suma"){
	
	if($pdf){
		$border  	= 'border="0"';
		$fontsize  	= 'font-size:8px;';
		$fontwidth  	= "border-width:0.1px 0.1px 0.1px 0.1px;";
	}elseif($excel){
		$border  	= 'border="1"';
		$fontsize  	= 'font-size:14px;';
	}else{
		$border  	= 'border="1"';
		$fontsize  	= 'font-size:12px;';
		$fontwidth  	= "";
	}
	
	foreach($a_semana as $key_s => $val_s){
	
		$fecha_fin 		= $val_s['f2'];
		?>
		<table style="padding-bottom:5px"  border="0" width="100%">
			<tr>
				<td>
				<table <?php echo $border;?> width="100%" style="<?php echo $fontsize;?>padding:1px;" cellspacing="0" cellpadding="1">
					
					<tr bgcolor="#99ccff">
						<td rowspan="2"  width="2%" style="<?php echo $fontwidth;?>">N.</td>
						<td width="24%" colspan="2" align="center" style="<?php echo $fontwidth;?>"><b><?php	echo "Semana ".($key_s);?></b></td>
						
						<?php
						foreach($a_dia as $key => $val){
							?>
							<td  width="10%" align="center" style="<?php echo $fontwidth;?>"><b><?php echo $a_diaT[$key];?></b></td>
							<?php
						}
						if($operacion_subtotal == "suma"){
						?>
						<td  width="14%" rowspan="2" align="center" style="<?php echo $fontwidth;?>" >Total <?php if($operacion_subtotal == "avg") echo " (Promedio)"; ?></td>
						<?php 
						}?>
					</tr>
					<tr  bgcolor="#99ccff">
						<td style="<?php echo $fontwidth;?>">Mercado</td>
						<td style="<?php echo $fontwidth;?>">Representante</td>
						<?php
						foreach($a_dia as $key_dia => $val){
							$fecha_inicio 	= $val_s['f1'];
							$f_encontro = 0;
							while($fecha_inicio <= $fecha_fin){
								$fecha_dia = date('N',strtotime($fecha_inicio));
								if($key_dia == $fecha_dia){
									?>
										<td  align="center" style="<?php echo $fontwidth;?> "><?php echo $fecha_inicio;?></td>
									<?php
									$f_encontro = 1;
									break 1;
								}
								$fecha_inicio = date('Y-m-d',strtotime($fecha_inicio.' +1 day'));
							}
							if($f_encontro == 0){
								?>
								<td style="<?php echo $fontwidth;?>"></td>
								<?php
							}
						}
						?>
					</tr>
					<?php
					$i=1;
					
					if(is_array($a_dimensiones)){
						foreach($a_dimensiones as $key_colab => $a_colab){
							$bgolor_r= ($i%2)?"#ffffff":"#f9f6f6";
							$a_nombreR = explode(",",$a_colab['nombrerepresentante'])
							?>
							<tr bgcolor="<?php echo $bgolor_r?>">
							<td style="<?php echo $fontwidth;?>"><?php echo $i;?></td>
							<td style="<?php echo $fontwidth;?>"><?php echo $a_colab['nombremercado'];?></td>
							<td style="<?php echo $fontwidth;?>"><?php echo $a_nombreR[1];?></td>
							<?php
							$sumatoriaValor = 0;
							$conteoDias = 0;
							foreach($a_dia as $key_dia => $val_hf){
								$fecha_inicio 	= $val_s['f1'];
								$f_encontro = 0;
								
								while($fecha_inicio <= $fecha_fin){
									$fecha_dia = date('N',strtotime($fecha_inicio));
									if($key_dia == $fecha_dia){
										$a_result = pintar_dw($ind,$a_colab['idsucursal'],$a_colab['idmercado'],$a_colab['idcolaborador'],$fecha_inicio);
										?>
										<td align="right" style="<?php echo $fontwidth;?>">
										<?php
										if(is_array($a_result)){
											$sumatoriaValor += $a_result['valor'];
											$conteoDias++;
											if($f_sumatoria){
												echo number_format($a_result['valor'],2);
											}else{
												if($pdf || $excel){
													echo number_format($a_result['valor'],2);
												}else{
													?>
													&nbsp;<a href="#" onclick="parent.objMainTab.modalDialog('<?=buildUrl('rsemanales/show/idsucursal/'.$a_colab['idsucursal'].'/idmercado/'.$a_colab['idmercado'].'/idcolaborador/'.$a_colab['idcolaborador'].'/fecha/'.$fecha_inicio.'/ind/'.$ind);?>',{width:1000,height:540})" style="text-decoration:underline;color:#000000;"><?php echo (int)$a_result['valor'];?></a>
													<?php
												}
											}
											if($f_cantidad){
												if($pdf){
													echo " (".$a_result['cantidad'].")";
												}elseif($a_result['cantidad'] ){?>
												<a href="#" onclick="parent.objMainTab.modalDialog('<?=buildUrl('rsemanales/show/idsucursal/'.$a_colab['idsucursal'].'/idmercado/'.$a_colab['idmercado'].'/idcolaborador/'.$a_colab['idcolaborador'].'/fecha/'.$fecha_inicio.'/ind/'.$ind);?>',{width:1000,height:540})" style="text-decoration:underline;color:#3366ff;">(<?php echo $a_result['cantidad'];?>)</a>
												<?php
												}
											}
										}
										?>
										</td>
										<?php
										$f_encontro = 1;
										break 1;
									}
									$fecha_inicio = date('Y-m-d',strtotime($fecha_inicio.' +1 day'));
								}
								if($f_encontro == 0){?>
									<td style="<?php echo $fontwidth;?>">
									</td>
								<?php
								}
							}
							if($operacion_subtotal == "avg"){  if($conteoDias >0)$a_SumatoriaColaborador[$a_colab['idsucursal']."-".$a_colab['idmercado']."-".$a_colab['idcolaborador']] +=$sumatoriaValor/$conteoDias; 
							}else $a_SumatoriaColaborador[$a_colab['idsucursal']."-".$a_colab['idmercado']."-".$a_colab['idcolaborador']] +=$sumatoriaValor;
							if($operacion_subtotal == "suma"){?>
							<td  align="right" style="<?php echo $fontwidth;?>"><?php if($operacion_subtotal == "avg"){  if($conteoDias >0)echo number_format($sumatoriaValor/$conteoDias,2); else echo ""; }else echo number_format($sumatoriaValor,2);?></td>
							<?php }?>
							</tr>
							<?php
							$i++;
						}
					}?>
				</table>
			</td>
		</tr>
	</table><?php
	}	
	if($operacion_subtotal == "suma"){
	?>
	<table style="margin-top:5px;padding-top:0px" width="100%">
		<tr>
			<td width="25%"></td>
			<td width="50%">
				<table <?php echo $border;?> align="left" width="100%"  style="<?php echo $fontsize;?>padding:1px" cellspacing="0">
					<tr bgcolor="#99ccff">
						<td  colspan="4" align="center" style="<?php echo $fontwidth;?>"><b><?php echo "Resumen: ".$a_dm['primerFecha']." - ".$a_dm['ultimoFecha'];?></b></td>
					</tr>
					<tr bgcolor="#99ccff">
						<td width="10%" style="<?php echo $fontwidth;?>">N.</td>
						<td width="35%" style="<?php echo $fontwidth;?>">Mercado</td>
						<td width="30%" style="<?php echo $fontwidth;?>">Representante</td>
						<td  width="25%" align="center" style="<?php echo $fontwidth;?>">Total <?php if($operacion_subtotal == "avg") echo " (Promedio)"; ?></td>
					</tr>
					<?php
					if(is_array($a_dimensiones)){
						
						$i = 1;
						foreach($a_dimensiones as $key_colab => $a_colab){
							$SumatoriaColaboradores += $a_SumatoriaColaborador[$a_colab['idsucursal']."-".$a_colab['idmercado']."-".$a_colab['idcolaborador']];
							$bgolor_r= ($i%2)?"#ffffff":"#f9f6f6";
							$a_nombreR = explode(",",$a_colab['nombrerepresentante'])
							?>
							<tr bgcolor="<?php echo $bgolor_r;?>">
								<td style="<?php echo $fontwidth;?>"><?php echo $i;?></td>
								<td style="<?php echo $fontwidth;?>"><?php echo $a_colab['nombremercado'];?></td>
								<td style="<?php echo $fontwidth;?>"><?php echo $a_nombreR[1];?></td>
								<td align="right" style="<?php echo $fontwidth;?>"><?php echo number_format($a_SumatoriaColaborador[$a_colab['idsucursal']."-".$a_colab['idmercado']."-".$a_colab['idcolaborador']],2);?></td>
							</tr>
							<?php
							$i++;
						}
						
					}
					?>
					<tr bgcolor="#99ccff">
						<td colspan="3" align="right" style="<?php echo $fontwidth;?>">Total</td>
						<td align="right" style="<?php echo $fontwidth;?>"><?php echo number_format($SumatoriaColaboradores,2);?></td>
					</tr>
				</table>
			</td>
			<td width="25%"></td>
		</tr>
	</table>
	</div>
	<?php
	}
}


function pintarReporteDiario($ind = "cn",$a_dimensiones,$txtFechaInicial,$txtFechaFinal, $f_cantidad = 1,$pdf = 0, $excel = 0,$operacion_subtotal = "suma",$ver_filatotales="si",$sumatoria_acumaulado="1"){
	
	if($pdf){
		$border  	= 'border="0"';
		$fontsize  	= 'font-size:8px;';
		$fontwidth  	= "border-width:0.1px 0.1px 0.1px 0.1px;";
	}elseif($excel){
		$border  	= 'border="1"';
		$fontsize  	= 'font-size:14px;';
	}else{
		$border  	= 'border="1"';
		$fontsize  	= 'font-size:12px;';
		$fontwidth  	= "";
	}
	
	?>
		<table style="padding-bottom:5px"  border="0" width="100%">
			<tr>
				<td>
				<table <?php echo $border;?> width="100%" style="<?php echo $fontsize;?>padding:1px;" cellspacing="0" cellpadding="1">
					
					<tr bgcolor="#99ccff">
						<td   width="2%" style="<?php echo $fontwidth;?>">N.</td>
						
						<td style="<?php echo $fontwidth;?>">Fecha</td>
						<?php
						if(is_array($a_dimensiones)){
							foreach($a_dimensiones as $key_colab => $a_colab){
								$bgolor_r= ($i%2)?"#ffffff":"#f9f6f6";
								$a_nombreR = explode(",",$a_colab['nombrerepresentante']);
							?>
								<td style="<?php echo $fontwidth;?>"><?php echo str_pad($a_colab['idcolaborador'],4,"0",STR_PAD_LEFT);?></td>
							<?php
							}
						}
						?>
						<td style="<?php echo $fontwidth;?>">Total</td>						
					</tr>
					<?php
					
					$txtFechaInicialR = $txtFechaInicial;
					if(is_array($a_dimensiones)){
						$i=1;
						$filas = 0;
									
						while($txtFechaInicial <= $txtFechaFinal){
							$bgolor_r= ($i%2)?"#ffffff":"#f9f6f6";
							$filas++;
							?>
							<tr bgcolor="<?php echo $bgolor_r?>">
								<td style="<?php echo $fontwidth;?>"><?php echo $i;?></td>
								<td style="<?php echo $fontwidth;?>"><?php echo $txtFechaInicial;?></td>
								<?php
								$sumatoriaValor = 0;
								$conteoDias=0;
								
								foreach($a_dimensiones as $key_colab => $a_colab){
									$a_result = pintar_dw_diario($ind,$a_colab['idsucursal'],$a_colab['idmercado'],$a_colab['idcolaborador'],$txtFechaInicial,$txtFechaInicial);
									$sumatoriaValor +=$a_result['valor'];
									$a_SumatoriaColaborador[$a_colab['idsucursal']."-".$a_colab['idmercado']."-".$a_colab['idcolaborador']] +=$a_result['valor'];
									$conteoDias++;
									
									if($sumatoria_acumaulado){
										$a_repr[$a_colab['idcolaborador']] += $a_result['valor']; 
										
									}else{
										$a_repr[$a_colab['idcolaborador']] = $a_result['valor']; 
										//$a_SumatoriaColaborador[$a_colab['idsucursal']."-".$a_colab['idmercado']."-".$a_colab['idcolaborador']]=$a_result['valor']; 
									}
									//$a_SumatoriaColaborador[$a_colab['idsucursal']."-".$a_colab['idmercado']."-".$a_colab['idcolaborador']] +=$a_result['valor'];
								?>
									<td style="<?php echo $fontwidth;?>" align="right"><?php echo number_format($a_result['valor'],2);?></td>
								<?php
								}
								$sumatoriaValorTotal +=$sumatoriaValor;
								
								?>
								
								<?php
								if($operacion_subtotal == "avg"){  if($conteoDias >0)$a_SumatoriaColaborador[$a_colab['idsucursal']."-".$a_colab['idmercado']."-".$a_colab['idcolaborador']] +=$sumatoriaValor/$conteoDias; 
								?>
								<td  align="right" style="<?php echo $fontwidth;?>"><?php if($operacion_subtotal == "avg"){  if($conteoDias >0)echo number_format($sumatoriaValor/$conteoDias,2); else echo ""; }else echo number_format($sumatoriaValor,2);?></td>
								<?php	
								}
								if($operacion_subtotal == "suma"){
									$conteoDias=1;?>
								<td  align="right" style="<?php echo $fontwidth;?>"><?php if($operacion_subtotal == "avg"){  if($conteoDias >0)echo number_format($sumatoriaValor/$conteoDias,2); else echo ""; }else echo number_format($sumatoriaValor,2);?></td>
								<?php }?>
							</tr>
							<?php
								$txtFechaInicial = date('Y-m-d',strtotime($txtFechaInicial.' +1 day'));
								$i++;
							}
							if($ver_filatotales == "si"){?>
							<tr bgcolor="<?php echo $bgolor_r?>">
								<td colspan="2" style="<?php echo $fontwidth;?>" align="right"><?php if($operacion_subtotal == "avg"){?>Promedio <?php }else {?>Totales <?php }?></td>
								<?php
									foreach($a_dimensiones as $key_colab => $a_colab){
										if($operacion_subtotal == "suma"){$filas=1;}
										?>
										<td style="<?php echo $fontwidth;?>" align="right"><?php echo number_format($a_repr[$a_colab['idcolaborador']]/$filas,2);?></td>
										<?php
									}
								?>
								<td style="<?php echo $fontwidth;?>" align="right"><?php if($operacion_subtotal == "suma"){ echo number_format($sumatoriaValorTotal,2);}?></td>							
							</tr>
							<?php
							}
					}else{?>
					<tr><td colspan="3">No existen resultados</td></tr>
					<?php }?>
				</table>
			</td>
		</tr>
	</table>
	<?php
		
	if($operacion_subtotal == "suma" || $operacion_subtotal == "avg"){
		if($operacion_subtotal == "suma") $filas =1;
	?>
	<table style="margin-top:5px;padding-top:0px" width="100%">
		<tr>
			<td width="25%"></td>
			<td width="50%">
				<table <?php echo $border;?> align="left" width="100%"  style="<?php echo $fontsize;?>padding:1px" cellspacing="0">
					<tr bgcolor="#99ccff">
						<td  colspan="5" width="100%" align="center" style="<?php echo $fontwidth;?>"><b><?php echo "Resumen: ".$txtFechaInicialR." - ".$txtFechaFinal;?></b></td>
					</tr>
					<tr bgcolor="#99ccff">
						<td width="5%" style="<?php echo $fontwidth;?>">N.</td>
						<td width="35%" style="<?php echo $fontwidth;?>">Mercado</td>
						<td width="30%" style="<?php echo $fontwidth;?>">Representante</td>
						<td width="12%"style="<?php echo $fontwidth;?>">Codigo</td>
						<td  width="18%" align="center" style="<?php echo $fontwidth;?>">Total <?php if($operacion_subtotal == "avg") echo " (Promedio)"; ?></td>
					</tr>
					<?php
					if(is_array($a_dimensiones)){
						
						$i = 1;
						foreach($a_dimensiones as $key_colab => $a_colab){
							if($sumatoria_acumaulado=="1"){
								//$SumatoriaColaboradores += $a_SumatoriaColaborador[$a_colab['idsucursal']."-".$a_colab['idmercado']."-".$a_colab['idcolaborador']];
							}else{
								//$SumatoriaColaboradores = $a_SumatoriaColaborador[$a_colab['idsucursal']."-".$a_colab['idmercado']."-".$a_colab['idcolaborador']];
							}
							
							
							$bgolor_r= ($i%2)?"#ffffff":"#f9f6f6";
							$a_nombreR = explode(",",$a_colab['nombrerepresentante'])
							?>
							<tr bgcolor="<?php echo $bgolor_r;?>">
								<td style="<?php echo $fontwidth;?>"><?php echo $i;?></td>
								<td style="<?php echo $fontwidth;?>"><?php echo $a_colab['nombremercado'];?></td>
								<td style="<?php echo $fontwidth;?>"><?php echo $a_nombreR[1];?></td>
								<td style="<?php echo $fontwidth;?>"><?php echo str_pad($a_colab['idcolaborador'],4,"0",STR_PAD_LEFT);?></td>
								<td align="right" style="<?php echo $fontwidth;?>"><?php echo number_format($a_repr[$a_colab['idcolaborador']]/$filas,2); $SumatoriaColaboradores += $a_repr[$a_colab['idcolaborador']]/$filas;// ."---".$a_SumatoriaColaborador[$a_colab['idsucursal']."-".$a_colab['idmercado']."-".$a_colab['idcolaborador']]."****".number_format($a_SumatoriaColaborador[$a_colab['idsucursal']."-".$a_colab['idmercado']."-".$a_colab['idcolaborador']]/$conteoDias,2);?></td>
							</tr>
							<?php
							$i++;
						}
						
					}else{
						?>
						<tr>
							<td colspan="5">No existen resultados</td>
						</tr>
						<?php
					}
					if($operacion_subtotal == "suma"){
					?>
					<tr bgcolor="#99ccff">
						<td colspan="4" align="right" style="<?php echo $fontwidth;?>">Total</td>
						<td align="right" style="<?php echo $fontwidth;?>"><?php echo number_format($SumatoriaColaboradores,2);?></td>
					</tr>
					<?php 
					}
					?>
				</table>
			</td>
			<td width="25%"></td>
		</tr>
	</table>
	<?php
	}
}


function ImprimirReporteCobranza($cboMercado,$cboColaborador,$fechaBalanceAbierto='',$file='',$metodofile=''){
	$o_ObjectBean = new PrestamoBean();
	
	//COLOCAR CAMPOS DE LA CABECERA DEL LISTADO  
	
	if($cboMercado     		!=""){ $o_ObjectBean->setIdMercado($cboMercado);}
	if($cboColaborador     	!=""){ 
		$o_ObjectBean->setIdColaboradorPrestamo($cboColaborador);
	}else{
		$cboColaborador = myUser::getUser()->getIdColaborador();
		if(myUser::getUser()->getRoleId() == "sys.gen" || myUser::getUser()->getRoleId() == "sys.res" || myUser::getUser()->getRoleId() == "sys.sup"|| myUser::getUser()->getRoleId() == "sys.view"){
			if(myUser::getUser()->getRoleId() == "sys.gen" ) $permitir_ts = 1;
		}else{
			$o_ObjectBean->setIdColaboradorPrestamo(myUser::getUser()->getIdColaborador());
		}
	}
	
	if($FechaInicial  !=""){ $o_ObjectBean->setFechaInicio($FechaInicial); }
	
	$o_ObjectBean->setEstado('P');
	$o_ObjectBean->setFlagReporte('2');
	
	$o_class = new PrestamoBL();
	$a_ObjectBean = $o_class->busquedaPrestamo($o_ObjectBean);
	/*****************************************/
	
	
	
	$pdf = new TCPDF('P', 'mm','A4', true); 
	
	$pdf->setHeaderFont(array('times','',11));
	$pdf->setFooterMargin('12');
	
	
	if( myUser::getUser()->getRoleId() == "sys.gen" || myUser::getUser()->getRoleId() == "sys.res" || myUser::getUser()->getRoleId() == "sys.sup"){
		
		$o_MercadoRepresentanteBean = new MercadoRepresentanteBean();              
		$o_MercadoRepresentanteBean->setIdMercado($cboMercado);
		$o_MercadoRepresentanteBL = new MercadoRepresentanteDP($o_MercadoRepresentanteBean);  
		$a_o_MercadoR = $o_MercadoRepresentanteBL->select();


		foreach ($a_o_MercadoR as $key => $o_MercadoR){
			$idColaborador = $o_MercadoR->getIdColaborador();
		}
	}else{
		if(myUser::getUser()->getIdColaborador()) $idColaborador  = myUser::getUser()->getIdColaborador();
		else $idColaborador  = $cboColaborador;
		
	}
	
	$o_ColaboradorBean = new ColaboradorBean();
	$o_ColaboradorBean->setIdColaborador($idColaborador);
	$o_ColaboradorBL = new ColaboradorBL();
	$a_o_Colaborador = $o_ColaboradorBL->busquedaColaborador($o_ColaboradorBean);
	
	foreach ($a_o_Colaborador as $key => $o_Colaborador){
		$NombreRepresentante = utf8_decode($o_Colaborador->getNombreCompleto());
		
	}
	
	/////////////////////////////////////////////////////////////////////////////
	$o_sucursalmercadoBean = new SucursalMercadoBean();
	$o_sucursalmercadoBean->setIdMercado($cboMercado);
	
	$o_sucursalmercadoDP = new SucursalMercadoDP($o_sucursalmercadoBean);
	$a_o_sucursalmercadoDP = $o_sucursalmercadoDP->select();
	
	foreach ($a_o_sucursalmercadoDP as $key => $o_sucursalmercado){
		$IdSucursal = $o_sucursalmercado->getIdSucursal();
	}
	
	if(!$fechaBalanceAbierto){
		$o_BalanceDiaNew = new BalanceDiaBean();
		$o_BalanceDiaNew->setIdSucursal($IdSucursal); 
		
		
		$o_BalanceDiaNewDP 		= new BalanceDiaDP($o_BalanceDiaNew);
		$fechaBalanceAbierto  	= $o_BalanceDiaNewDP->ObtenerDiaAbierto();
	}
	//////////////////////////////////////////////////////////////////////////////////////
	
	
	$o_MercadoBean = new MercadoBean();
	$o_MercadoBean->setIdMercado($cboMercado);
	$o_MercadoBL = new MercadoBL();
	$a_o_Mercado = $o_MercadoBL->busquedaMercado($o_MercadoBean);
	
	foreach ($a_o_Mercado as $key => $o_Mercado){
		$NombreMercado = utf8_encode(ucwords($o_Mercado->getDescripcion()));
	}
	
	
	$str = 'Mercado:'.ucwords($NombreMercado).'   *Representante :'.ucwords(utf8_encode($NombreRepresentante)).' Fecha:'.$fechaBalanceAbierto;
	
	
	$pdf->setHeaderData('','','Cobranza Diaria',$str);
	
	define("POS_IZQ", 3);
	
	$pdf->AddPage();
	
	/*iniciop titulo*/
	$pdf->SetFont('times','B',14);
	$pdf->SetX(POS_IZQ);
	
	
	/*fin titulo*/
	
	/*inicio de cabecera*/
	$pdf->SetFont('times','B',11);
	$pdf->SetXY(POS_IZQ,11);
	
	
	
	foreach ($a_ObjectBean as $iKey => $o_objBean){
	  $sumaTotalSaldo += $o_objBean->getSaldoPrestamo();
	   $fecha_tope = date('Y-m-d',strtotime($o_objBean->getFechaVencimiento().' +7 day'));
	   // if($o_objBean->getEstado() == 'P' && $o_objBean->getFechaVencimiento() < date('Y-m-d')){ 
	   
	   if($o_objBean->getFlagReporte() == '1'){
			$sumaMoroso += $o_objBean->getSaldoPrestamo();
	   }else{
	   
			if($fecha_tope <= $fechaBalanceAbierto){
				$a_prestamosId_PM[] =  $o_valor_pvm->IdPrestamo;
				$sumaMoroso += $o_objBean->getSaldoPrestamo();
			}else{
				//echo $o_valor_p->IdPrestamo."--><br>";
				if($o_objBean->getFechaVencimiento() < $fechaBalanceAbierto){
					$a_prestamosId_PV[] =  $o_valor_pvm->IdPrestamo;
					$sumaVencido += $o_objBean->getSaldoPrestamo();
				}
			}
		}
	   		
	  	//$sumaVencido += $o_objBean->getSaldoPrestamo();
	  
	}
	
	
	$pdf->SetFillColor(254,254,254);
	$pdf->SetFont('times','',9);
	
	$pdf->SetX(POS_IZQ);
	$pdf->Cell(25,3,"*N.P: ".(count($a_ObjectBean)),0,0,'L',1);
	$permitir_ts = 1;
	if($permitir_ts == 1){
		$pdf->Cell(25,3,"T.S: ".(number_format($sumaTotalSaldo,2)),0,0,'L');
	}
			
		  
	$pdf->SetTextColor(145, 45, 139);
	$pdf->Cell(25,3,"T.Venc.: ".(number_format($sumaVencido,2)),0,0,'L');
	$pdf->SetTextColor(255, 0, 0);		
	$pdf->Cell(25,3,"T.Moroso: ".(number_format($sumaMoroso,2)),0,1,'L',1);
	$pdf->SetTextColor(0, 0, 0); 
	$pdf->SetX(POS_IZQ); 
	$pdf->SetFillColor(236,235,236);  
	$pdf->SetFont('times','',9);
	$pdf->Cell(11,4,'Nro.',1,0,'L',1);
	if($file){
		$pdf->Cell(12,4,'Nro.Prest.',1,0,'L',1);
	}
	$pdf->Cell(50,4,'Cliente',1,0,'L',1);
	
	if(!$file){
		$pdf->Cell(12,4,'',1,0,'L',1);
	}
	//$pdf->Cell(7,4,'',1,0,'L',1);
	$pdf->Cell(17,4,'F.Ini',1,0,'L',1);
	$pdf->Cell(9,4,'G.A',1,0,'L',1);
	
	$pdf->Cell(18,4,'Capital',1,0,'L',1);
	$pdf->Cell(18,4,'Saldo',1,0,'L',1);
	$pdf->Cell(14,4,'C.Pago',1,0,'L',1);
	
	$pdf->Cell(6,4,'NP',1,0,'L',1);
	
	
	$pdf->Cell(10,4,'Ult.Pag.',1,0,'L',1);
	$pdf->Cell(18,4,'Telefono',1,0,'L',1);
	$pdf->Cell(10,4,'O',1,0,'L',1);
	$pdf->Cell(10,4,'',1,1,'L',1);
	/*fin de cabecera*/
	
	
	
	$pos    = 55;
	$count  = 0;
	$x      = 0;
	$pdf->SetFillColor(254,254,254);
	$pdf->SetFont('times','',9);
	
	if(count($a_ObjectBean)>0){
	//for($i=1;$i<50;$i++){	
	  reset($a_ObjectBean);
	 
	  
	  foreach ($a_ObjectBean as $iKey => $o_objBean){
		  $pdf->SetTextColor(0, 0, 0);
	  	  $fechaven = "";	
	  	  $vencido = "";	
	  	  $moroso = "";	
	  	  $estadoO = "";
	  	  $fecha_tope = date('Y-m-d',strtotime($o_objBean->getFechaVencimiento().' +7 day'));
	  	  
			if($o_objBean->getFechaVencimiento() >= $fechaBalanceAbierto){
				if($o_objBean->getFlagReporte() == '1'){
					$estadoO = "M";
				}
			}elseif($fecha_tope <= $fechaBalanceAbierto){
				$estadoO = "M";
			}else{
				$estadoO = "V";
			}

	  	  
		  
	  	  if($o_objBean->getOrigen() == 'R'){
	  	  	$origen ='N';
	  	  }elseif($o_objBean->getOrigen() == 'F'){
	  	  	$origen ='R';
	  	  }
	  	  $amortizacion = $o_objBean->getMontoTotal() - $o_objBean->getSaldoPrestamo();
	      $pdf->SetX(POS_IZQ);
		  if($estadoO  == "V"){
			$pdf->SetTextColor(145, 45, 139);
		  }elseif($estadoO  == "M"){
			$pdf->SetTextColor(255, 0, 0);
		  }else{
			$pdf->SetTextColor(0, 0, 0);
		  }
	      $pdf->Cell(11,4,($o_objBean->getIdCliente()),1,0,'L',1);
	      if($file){
			$pdf->Cell(11,4,($o_objBean->getIdPrestamo()),1,0,'L',1);
		  }
	      $pdf->Cell(50,4,ucwords(mb_strtolower($o_objBean->getObjectCliente()->getNombreCompleto(), 'UTF-8')),1,0,'L',1);
	      $pdf->SetTextColor(0, 0, 0);
	      
	      if($o_objBean->getIdCliente()){
	      	$o_ClienteBean = new ClienteBean();
	      	$o_ClienteBean->setIdCliente($o_objBean->getIdCliente());
	      	$o_ClienteDP = new ClienteDP($o_ClienteBean);
	      	$a_o_ClienteDP = $o_ClienteDP->select();
	      	foreach ($a_o_ClienteDP as $Key => $o_objCliente){
				$celular = trim($o_objCliente->getCelular());
				if($celular) $telefono = $celular;
	      		else $telefono = $o_objCliente->getTelefono();
	      		$IdTipoNegocio = $o_objCliente->getIdTipoNegocio();
				$OtroTipoNegocio = $o_objCliente->getOtroTipoNegocio();
				if($OtroTipoNegocio){
					$DescripcionNegocio = $OtroTipoNegocio; 
	      		}elseif($IdTipoNegocio){
	      			$o_TipoNegocioBean = new TipoNegocioBean();
	      			$o_TipoNegocioBean->setIdTipoNegocio($IdTipoNegocio);
			      	$o_TipoNegocioDP = new TipoNegocioDP($o_TipoNegocioBean);
			      	$a_o_TipoNegocioDP = $o_TipoNegocioDP->select();
			      	foreach ($a_o_TipoNegocioDP as $Keytn => $o_TipoNegocioDP){
			      		$DescripcionNegocio = $o_TipoNegocioDP->getDescripcion();
			      	}
	      		}
	      	}
			
	      }
	      if(!$file){
	      	$pdf->Cell(12,4,"",1,0,'C',1);
	      }
	      //$pdf->Cell(7,4,"",1,0,'C',1);
		 
	      $pdf->Cell(17,4,substr($o_objBean->getFechaInicio(),0,10),1,0,'C',1);
	      $pdf->Cell(9,4,number_format($o_objBean->getGastoAdministrativo(),2),1,0,'C',1);
	      $pdf->Cell(18,4,number_format($o_objBean->getMontoTotal(),2),1,0,'R',1);
		  if($estadoO  == "V"){
			$pdf->SetTextColor(145, 45, 139);
		  }elseif($estadoO  == "M"){
			$pdf->SetTextColor(255, 0, 0);
		  }else{
			$pdf->SetTextColor(0, 0, 0);
		  }
	      $pdf->Cell(18,4,number_format($o_objBean->getSaldoPrestamo(),2),1,0,'R',1);
	      $pdf->SetTextColor(0, 0, 0);
	      //$pdf->Cell(9,4,number_format($amortizacion,2),1,0,'R',1);
	      $pdf->Cell(14,4,number_format($o_objBean->getCuotaPago(),2),1,0,'R',1);
		  
	      $pdf->Cell(6,4,$o_objBean->getNroPagos(),1,0,'C',1);
	     
	      //$pdf->Cell(5,4,$fechaven,1,0,'R',1);
	      $pdf->SetFont('times','',9);
	
	      //$pdf->Cell(5,4,$origen,1,0,'C',1);
	      //$pdf->Cell(15,4,getEstadoCondicion($o_objBean->getCondicion()),1,0,'C',1);
	      $pdf->Cell(10,4,number_format($o_objBean->getPago_1(),2),1,0,'L',1);
		  
		   $pdf->Cell(18,4,$telefono,1,0,'L',1);
		   $saldoMora = '';
		   if($o_objBean->getSaldoMora()>0) $saldoMora = $o_objBean->getSaldoMora();
		   //$pdf->Cell(12,4,$saldoMora,1,0,'L',1);
		   
		   $pdf->Cell(10,4,$o_objBean->getOrigen(),1,0,'C',1);
		   $pdf->Cell(10,4,"",1,1,'L',1);
	      //$pdf->Cell(14,4,substr($DescripcionNegocio,0,10),1,1,'L',1);
	
	 
	      //$pdf->Cell(10,0,'',1,1,'L',1);
	      
	    }
	   /* $pdf->SetX(POS_IZQ);
		$pdf->Cell(61,4,'Totales',1,0,'R',1);
		$pdf->Cell(16,4,'',1,0,'L',1);
		//$pdf->Cell(7,4,'',1,0,'L',1);
		$pdf->Cell(17,4,'',1,0,'L',1);
		$pdf->Cell(9,4,'',1,0,'L',1);
		*/
	//}
	}else{  
	  $pdf->SetXY(POS_IZQ,$pos);
	  $pdf->Cell(200,4,"No hay registros.",0,0,'L',1);
	  
	}
	
	if($file){
		$pdf->Output($file, $metodofile);
	}else{
		$pdf->Output();
	}
	
}


function sendReporteCobranzaDiaria($fechaDiaCerrado,$idMercado,$idColaborador,$archivo){
	
	ImprimirReporteCobranza($idMercado,$idColaborador,$fechaDiaCerrado,$archivo,"F");
	
	$mail = new PHPMailer();

	//Luego tenemos que iniciar la validación por SMTP:
	$mail->CharSet = "UTF-8";
	$mail->isSMTP();
	//$mail->SMTPAuth = true;
	//$mail->Host = "mail.sinergiaperu.com"; // A RELLENAR. Aquí pondremos el SMTP a utilizar. Por ej. mail.midominio.com
	//$mail->Username = "sistemas@sinergiaperu.com"; // A RELLENAR. Email de la cuenta de correo. ej.info@midominio.com La cuenta de correo debe ser creada previamente. 
	//$mail->Password = "py[58RZuqVIj"; // A RELLENAR. Aqui pondremos la contraseña de la cuenta de correo
	//$mail->Port = 465; // Puerto de conexión al servidor de envio. 
	$mail->From = "no-reply@uni-barranca.com"; // A RELLENARDesde donde enviamos (Para mostrar). Puede ser el mismo que el email creado previamente.
	$mail->FromName = "I. Gladis"; //A RELLENAR Nombre a mostrar del remitente. 
	//$mail->AddAddress("cesar.jan@outlook.com"); // Esta es la dirección a donde enviamos 
	$mail->AddAddress("mascruz13@hotmail.com"); // Esta es la dirección a donde enviamos 
	$mail->isHTML(true); // El correo se envía como HTML 
	$mail->Subject = "I.Gladis::Cobranza Diaria ".$fechaDiaCerrado; // Este es el titulo del email. 
	$body = "Se envio la cobranza diaria. al cerrar el dia ".$fechaDiaCerrado; 
	//$body .= "Aquí continuamos el mensaje"; 
	$mail->Body = $body; // Mensaje a enviar. 
	//$attachment = chunk_split($attachment);
	//$mail->AddStringAttachment($attachment, 'filename.pdf','base64', "application/pdf");
	//$mail->AddStringAttachment($attachment, 'some_filename.pdf');
	
	$mail->AddAttachment($archivo); 
	$exito = $mail->Send(); // Envía el correo.
	if($exito)
	{ 
		echo "El correo fue enviado correctamente."; 
	}else{ 
		echo "Hubo un problema. Contacta a un administrador."; 
	} 
	
}


function getDia(){
	$a_dia[1] = "Lun";
	$a_dia[2] = "Mar";
	$a_dia[3] = "Mie";
	$a_dia[4] = "Jue";
	$a_dia[5] = "Vie";
	$a_dia[6] = "Sab";
	return $a_dia ;
}
function getDiaT(){
	
	$a_diaT[1] = "Lunes";
	$a_diaT[2] = "Martes";
	$a_diaT[3] = "Miercoles";
	$a_diaT[4] = "Jueves";
	$a_diaT[5] = "Viernes";
	$a_diaT[6] = "Sabado";
	return $a_diaT;

}

/*****************************************/

function grabar_reprogramacioncovid19($idSucursal,$idMercado,$fechaParo,$fechaReinicio,$idUsuario="system"){
	// --Si no hay cabcera grabada --> lectura de cr_prestamo
	$con = Conexion::getConexion();
	$sql = "SHOW TABLES LIKE 'cr_cuota' ";
     
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
     
                 
    $iResultSave = $result;
    if($iResultSave > 0){
    	$permitir_modificar_cuota = 1;
    }
	$o_ObjectBean = new PrestamoBean();
	$tamanioPag = 9999;
	if($idMercado     	!= ""){
		 $o_ObjectBean->setIdMercado($idMercado);	 
	}
	$o_ObjectBean->setEstado("P");
	$o_ObjectBean->setFlagReporte("2");
	
	
	$o_ObjectBean->page = $page;
	$o_ObjectBean->tamPag = $tamanioPag;
	$o_ObjectBean->sortCampos = $sortCampos;
	$o_ObjectBean->sortType   = $sortType;
	 
	$o_class = new PrestamoBL();
	$a_ObjectBean = $o_class->busquedaPrestamo($o_ObjectBean);
	
	$o_crCovid19DP = new CrCovid19detalleDP();
	
	if(count($a_ObjectBean)>0){
          foreach ($a_ObjectBean as $iKey => $o_objBean){
			 
			if($o_objBean->getFechaInicio() > $fechaParo && $o_objBean->getFechaInicio() < $fechaReinicio && $o_objBean->getOrigen() == "F"){
				continue;
			}
            
            $idprestamo = $o_objBean->getIdPrestamo();
            $FechaInicio = $o_objBean->getFechaInicio();
            $FechaVencimiento = $o_objBean->getFechaVencimiento();
			$diferenciadias = diferenciaDates($o_objBean->getFechaVencimiento(),$fechaParo);
			$fechaNuevaVencimiento = date("Y-m-d",strtotime($fechaReinicio." ".$diferenciadias." days"));
			
            $difernciadiasCovid19 = diferenciaDates($fechaNuevaVencimiento,$o_objBean->getFechaVencimiento()); 
            
            $o_crCovid19DP->setIdsucursal($idSucursal); 
            $o_crCovid19DP->setIdmercado($idMercado); 
            $o_crCovid19DP->setIdprestamo($idprestamo);
			$o_crCovid19DP->setDiasdiferencia($diferenciadias);  
			$o_crCovid19DP->setFechavencimientoanterior($FechaVencimiento);
			$o_crCovid19DP->setFechavencimientonuevo($fechaNuevaVencimiento);
			$o_crCovid19DP->setUsuarioregistro($idUsuario);
          	$o_crCovid19DP->setFecharegistro(date("Y-m-d H:i:s"));
			$o_crCovid19DP->save();
			
			$o_ObjectPrestamoBean = new PrestamoBean();
			$o_ObjectPrestamoBean->setIdPrestamo($idprestamo);	 
			$o_ObjectPrestamoBean->setFechaVencimiento($fechaNuevaVencimiento);	 
			$o_ObjectPrestamoBean->setFechaModificacion(date("Y-m-d H:i:s"));	 
			$o_ObjectPrestamoBean->setUsuarioModificacion($idUsuario);
			$o_ObjectPrestamoDP = new PrestamoDP($o_ObjectPrestamoBean);
			$o_ObjectPrestamoDP->update();
			
		    if($permitir_modificar_cuota){
		    	$con = Conexion::getConexion(); 
		    	$sql_cuota = "
		    				UPDATE cr_cuota 
		    				SET fecha = DATE_ADD(fecha, INTERVAL ".$difernciadiasCovid19." DAY)
		    				WHERE idprestamo='".$idprestamo."' and fecha >= '".$fechaParo."'";
		    	
		    	$result_cuota = mysql_db_query(Conexion::getNameDb(), $sql_cuota, $con);
		    	
		        
		    }			
			
          } 
          $o_crCovid19CabDP = new CrCovid19cabeceraDP();
          $o_crCovid19CabDP->setIdsucursal($idSucursal);
          $o_crCovid19CabDP->setIdmercado($idMercado);
          $o_crCovid19CabDP->setUsuarioregistro($idUsuario);
          $o_crCovid19CabDP->setFecharegistro(date("Y-m-d H:i:s"));
          $o_crCovid19CabDP->save();
	  }
			
	
}



/*-------------------------------------FUNCIONES DE CRONOGRAMA----------------------------------------------*/

function getDatosPrestamo($idPrestamo){
	$o_prestamoBean = new PrestamoBean();		
	$o_prestamoBean->setIdPrestamo($idPrestamo);
	
	$o_prestamoDP = new PrestamoDP($o_prestamoBean);		
	$a_o_prestamo = $o_prestamoDP->select();
	 
	if(is_array($a_o_prestamo)) return $a_o_prestamo[0];
	return false;
}


function procesoCalculoCronograma($idPrestamo,$noDomingos=''){
		
	if(!$idPrestamo) exit("No va");
	$o_prestamo = getDatosPrestamo($idPrestamo);
	//echo "<pre>";
	//print_r($o_prestamo);
	
	//echo "</pre>";
	if(is_object($o_prestamo)){
		$FechaInicioPago 	= $o_prestamo->getFechaInicioPago();
		$MontoTotal 		= $o_prestamo->getMontoTotal();
		$PeriodicidadPago 	= $o_prestamo->getPeriodicidadPago();
		$CuotaPago 			= round($o_prestamo->getCuotaPago(),2);
		$NroCuotas 			= $o_prestamo->getNroCuotas();	
		$cuotaPago 			= round($MontoTotal/$NroCuotas,1); 
		
		
		$a_fechaMonto = generarCronogramaCuotas($idPrestamo,$FechaInicioPago,$MontoTotal,$PeriodicidadPago,$NroCuotas,$cuotaPago, $noDomingos=1);
		
		//echo "<pre>";
		//print_r($a_fechaMonto);
		//echo "</pre>";
		grabarCuotaPago($idPrestamo,$a_fechaMonto);
	}
}

function grabarCuotaPago($idPrestamo,$a_fechaMonto){
	$con = Conexion::getConexion();
	$sql = "SELECT * 
				FROM cr_cuota
				WHERE idprestamo = '".$idPrestamo."'";
	
		$oLink = method_exists($con, 'getResource')?$con->getResource():$con;
		
		$result_c = mysql_db_query(Conexion::getNameDb(), $sql, $oLink);
		$num_cuotas = mysql_num_rows($result_c);
		if($num_cuotas == 0){
			
			foreach ($a_fechaMonto as $fecha => $Monto){
		
		
		
			
			
				$sql = "INSERT cr_cuota
						(idcuota,idprestamo,fecha,montocuota,saldocuota,estado,fecharegistro,usuarioregistro)
						values
						(
						 null,'".$idPrestamo."','".$fecha."','".$Monto."','".$Monto."','P','".(date('Y-m-d H:i:s'))."','system')
					"	;
				//echo $sql;
				$result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
			
			}
	}
      
    
}


function esDomingo($Fecha){
	$dia = date('w',strtotime($Fecha));
	if($dia > 0 ) return false;
	return true;
}


function saltoFecha($Fecha,$PeriodicidadPago,$noDomingos){
	if($PeriodicidadPago == "D") $saltoDias = 1;
	if($PeriodicidadPago == "S") $saltoDias = 7;
	if($PeriodicidadPago == "M") $saltoDias = 30;
	$fecha = date('Y-m-d',strtotime($Fecha.' +'.$saltoDias.' days'));
	if(esDomingo($fecha)) $fecha = date('Y-m-d',strtotime($fecha.' +1 days'));
	return $fecha;
}


function generarCronogramaCuotas($idPrestamo,$FechaInicioPago,$MontoTotal,$PeriodicidadPago,$NroCuotas, $cuotaPago, $noDomingos=1){
	$fecha = $FechaInicioPago;
	$diferenciaMonto = $MontoTotal - ($cuotaPago*$NroCuotas);
	for($i=1;$i<= $NroCuotas;$i++){
		//echo $i."-> ".$fecha."<br>";
		if($i == $NroCuotas) $a_fechaMonto[$fecha] = $cuotaPago + $diferenciaMonto;
		else $a_fechaMonto[$fecha] = $cuotaPago;
		$fecha = saltoFecha($fecha,$PeriodicidadPago,$noDomingos);
	}
	return $a_fechaMonto;
}

function procesoPagoCuota($db,$con,$idPrestamo,$IdPago,$MontoPago){
	
      
	//Busco las cuotas que estan en la base de datos
	$sql = "SELECT * 
			FROM cr_cuota
			WHERE IdPrestamo='".$idPrestamo."'
				and Estado='P'
			order by idcuota
			limit 0,1
			";
      echo $sql."----".$db;
    $result2 = mysql_db_query($db, $sql, $con);
    echo $result2;
    $num_rows = mysql_num_rows($result2);
    echo "num rows:".$num_rows."..................";
    if($num_rows > 0){
    	echo $result2."#----#";
    	while ($o_valor = mysql_fetch_object($result2)) {	
    		echo "entro";
    		$montocuota = $o_valor->montocuota;
    		$saldocuota = $o_valor->saldocuota;
    		$idcuota = $o_valor->idcuota;
    		if($MontoPago > $saldocuota ){
    			$nuevoSaldoCuota = 0.00;
    			$restoPago = $MontoPago - $saldocuota;
    			$nuevoEstado = 'C';
    			$MontoCuotaPago = $saldocuota;
    		}
    		if($MontoPago < $saldocuota ){
    			$nuevoSaldoCuota = $saldocuota - $MontoPago;
    			$restoPago = 0.00;
    			$nuevoEstado = 'P';
    			$MontoCuotaPago = $MontoPago;
    		}
    		if($MontoPago == $saldocuota ){
    			$nuevoSaldoCuota = 0.00;
    			$restoPago = 0.00;
    			$nuevoEstado = 'C';
    			$MontoCuotaPago = $MontoPago;
    		}
    		if($nuevoSaldoCuota == 0.00){
    			$nuevoEstado = 'C';
    		}
    		//Actualizar Cuota
    		$sql = "UPDATE cr_cuota
    				SET 
    					saldocuota='".$nuevoSaldoCuota."',
    					estado ='".$nuevoEstado."'
    					
					WHERE idcuota =".$idcuota."
					";
    		echo $sql."<br>";
		    echo "entro 2";  
		    $result_1 = mysql_db_query($db, $sql, $con);
		    
		    //Insertar Cuota Pago
    		$sql = "INSERT cr_cuota_pago
    				( idcuota, idpago, idprestamo, monto ,fecharegistro,usuarioregistro)
					VALUES
					( '".$idcuota."','".$IdPago."','".$idPrestamo."','".$MontoCuotaPago."','".(date('Y-m-d H:i:s'))."','system')
					";
    		echo $sql."<br>";
		    echo "entro 3";    
		    $result_2 = mysql_db_query($db, $sql, $con);
		    
		    
		    $sql = "UPDATE cr_pago
    				SET 
    					calculado='1'
					WHERE IdPago =".$IdPago."
					";
    		echo $sql."<br>";
		    echo "entro 3";  
		    $result_3 = mysql_db_query($db, $sql, $con);
		   
    	}
    }
    echo $restoPago."-----<br>";
    if($restoPago > 0){
        echo "entra OK";
        procesoPagoCuota($db,$con,$idPrestamo,$IdPago,$restoPago);
    }
}

function depurarCuotaPrestamo($idPrestamo,$fechaVencimiento){
	$con = Conexion::getConexion();
	//Depurar PrestamoLog
	$sql = "DELETE FROM cr_categoria_prestamolog
			WHERE fecha not in (
					SELECT fecha
					FROM cr_cuota
					WHERE idprestamo ='".$idPrestamo."'
				) and idprestamo = $idPrestamo
				and fecha < '".$fechaVencimiento."'
			";
      echo $sql;
      //exit;
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
       
}

function procesoCalculoPagoCuota($idPrestamo){
	
	$con = Conexion::getConexion();
      
	//Busco los pagos del prestamo
	$sql = "SELECT * 
			FROM cr_pago
			WHERE IdPrestamo=".$idPrestamo."
				 and calculado='-1' and MontoPago >0 and TipoPago='1'
			";
    echo $sql." de Proceso Calculo PAgo Cuota<br>";
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    
    $num_rows = mysql_num_rows($result);
    if($num_rows>0){
    	while ($o_valor = mysql_fetch_object($result)) {
      		$IdPago 	= $o_valor->IdPago;
      		$MontoPago 	= $o_valor->MontoPago;
      		if($MontoPago > 0){
      			procesoPagoCuota(Conexion::getNameDb(),$con,$idPrestamo,$IdPago,$MontoPago);
      			
      		}
      		
    	}
    }
	
	
} 

//Detecta el porcentaje de pago
function conteoImpagosPrestamo($idPrestamo,$fechaDiaAbierto,$fechaVencimiento,$PeriodicidadPago){
	$con = Conexion::getConexion();
	
    if( $fechaVencimiento < $fechaDiaAbierto){ //Prestamo vencido
		$porcentajePagos = 0;
	}else{
		
		$sql = "SELECT cu.fecha,cu.montocuota
				FROM cr_cuota cu
				WHERE idprestamo ='".$idPrestamo."'
				AND fecha <='".$fechaDiaAbierto."'
			";
	      echo $sql;
	      //exit;
	    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
	    
	    $num_rows = mysql_num_rows($result);
	    $montocuota = 0;
	    if($num_rows>0){
	    	while ($o_valor = mysql_fetch_object($result)) {
	      		if($o_valor->fecha <= $fechaDiaAbierto){
	      			$montocuota += $o_valor->montocuota;
	      		}else{
	      			continue;
	      		}
	    	}
	    }
	    
	    //Pago Real acumulado
    	$sql = "SELECT sum(MontoPago) as MontoPago
				FROM cr_pago
				WHERE idprestamo ='".$idPrestamo."'
			";
	     echo $sql;
	      //exit;
	    $resultPP = mysql_db_query(Conexion::getNameDb(), $sql, $con);
	    $num_rowsPP = mysql_num_rows($resultPP);
	    if($num_rowsPP>0){
	    	while ($o_valorPP = mysql_fetch_object($resultPP)) {
	      		$SumaMontoPago = $o_valorPP->MontoPago;
	    	}
	    }
	    $porcentajePagos = ($SumaMontoPago/$montocuota)*100;

	} 
    	
	return $porcentajePagos;
}

function diferenciaDias($inicio, $fin)
{
	$inicio = strtotime($inicio);
	$fin = strtotime($fin);
	$dif = $fin - $inicio;
	$diasFalt = (( ( $dif / 60 ) / 60 ) / 24);
	return ceil($diasFalt);
}


function categorizarPrestamo($idPrestamo,$fechaDiaAbierto,$numeroImpagos){
	$con = Conexion::getConexion();
      
	//Busco los pagos del prestamo
	$sql = "SELECT *
			FROM cr_categoria_prestamo
			WHERE impagominimo <='".$numeroImpagos."'
			and impagomaximo >='".$numeroImpagos."'
			";
      echo $sql;
      //exit;
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    
    $num_rows = mysql_num_rows($result);
    
    if($num_rows>0){
    	while ($o_valor = mysql_fetch_object($result)) {
      			$idcategoria = $o_valor->idcategoria;
      			$codigo = $o_valor->codigo;
      			$descripcion = $o_valor->descripcion;
      			$peso = $o_valor->peso;
      			
      			$sql = "REPLACE cr_categoria_prestamolog
						(idprestamo,fecha,nombrecategoria,idcategoria,peso)
						values
						(
						 '".$idPrestamo."','".$fechaDiaAbierto."','".$descripcion."','".$idcategoria."','".$peso."')
					"	;
				echo $sql;
				$result_i = mysql_db_query(Conexion::getNameDb(), $sql, $con);	
				
				$sql = "UPDATE cr_prestamo
						set 
						nombrecategoria = '".$descripcion."',
						idcategoria = '".$idcategoria."'
						WHERE idprestamo = '".$idPrestamo."'
					"	;
				echo $sql;
				$result_ip = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      		
    	}
    }
    
    
}

function cerrarCalculoPagosCero(){

	$con = Conexion::getConexion();
	
	$sql = "UPDATE cr_pago
			set calculado = '1'
			where MontoPago = 0
		"	;
	echo $sql;
	$result_ip = mysql_db_query(Conexion::getNameDb(), $sql, $con);
}



/*------------------------------------------------------------------------------------------------------------------*/

function listaCategoria($idCategoria=''){
	$con = Conexion::getConexion();
      
	//Busco los pagos del prestamo
	$sql = "SELECT *
			FROM cr_categoria_prestamo
			WHERE 1
			";
     // echo $sql;
      //exit;
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    
    $num_rows = mysql_num_rows($result);
    
    if($num_rows>0){
    	while ($o_valor = mysql_fetch_object($result)) {
      		$idcategoria = $o_valor->idcategoria;
      		$descripcion = $o_valor->descripcion;
      		$a_categoria[$idcategoria] = $descripcion;
	   	}
    	return $a_categoria;
    }
}

function listaCategoriaAll(){
	$con = Conexion::getConexion();
      
	//Busco los pagos del prestamo
	$sql = "SELECT *
			FROM cr_categoria_prestamo
			WHERE 1
			";
     // echo $sql;
      //exit;
    $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
    
    $num_rows = mysql_num_rows($result);
    
    if($num_rows>0){
    	while ($o_valor = mysql_fetch_object($result)) {
      		$a_categoria[$o_valor->idcategoria] = $o_valor;
	   	}
    	return $a_categoria;
    }
}
