<?php
/**
 * utilJson
 *
 * @package    ss_menu
 * @subpackage utilJson
 * @author     Willy
 * @version    SVN: $Id: utilJson.class.php,v 1.4 2007/11/20 17:23:55 william.taype Exp $ 
 */
class utilJson{
  
  /**
   * Retorna un subconjunto de la notacin literal de objetos de Javascript para la actualizacion
   * de un SELECT (COMBO).
   *
   * @param String $nameElm
   * @param Array $arrayObj
   * @param String $method0
   * @param String $method1
   * @return StringJson
   * 
   * @example 
   * 
   * como se utilizaria:
   * $salida = utilJson::generateJsonCmbo('NombreCOMBO', 'ArrayDeObjetos', "MetodoParaExtraerId", "MetodoParaExtraerNombre");
   * 
   * un ejemplo de un posible resultado:
   * $salida= '(["Combo_1",["0","-- Seleccionar--"],["0527","Estacion 1"],["0560","Suc a"],["0561","dsfdsfds"]])';
   * 
   */
  static function generateJsonCmbo($nameElm, $arrayObj, $method0, $method1){
    
		$sResultado      = "[";
		$sResultado     .= '"'.$nameElm.'"';
		
		foreach ($arrayObj as $obj){		
			$text    = call_user_func(array($obj, $method0));
			$value   = call_user_func(array($obj, $method1));
			$sResultado .= ',["'.$text.'","'.$value.'"]';	
		}
		
		$sResultado		.= ']';
		
		return $sResultado;
    
  }
  
  /**
   * Retorna un subconjunto de la notacin literal de objetos de Javascript para la actualizacion
   * de uno o varios elementos.
   *
   * @param Array $a_Param
   * @return StringJson
   * 
   * @example 
   * 
   * array que podria venir en el parametro:
   * $a_Params = array('NombreElemento1'=>'Mi nombre es William', 'NombreElemento2'=>'Mi apellido es Taype Perez');
   * 
   * como se utilizaria:
   * $salida = utilJson::generateJsonElment($a_Params);
   * 
   * un ejemplo de un posible resultado:
   * $salida = '[["NombreElemento1", "Mi nombre es William"], ["NombreElemento2", "Mi apellido es Taype Perez"]]';
   * 
   */
  static function generateJsonElment($a_Param){
    
    $sResultado      = "[";
    $a_Resultado     = array();
    
    foreach ($a_Param as $key => $value){
      
      $nameElm = $key;
      $valueElm = $value;
      
      $a_Resultado[]  = '["'.$nameElm.'","'.$valueElm.'"]';
      
    }
    
    return "[".implode(",",$a_Resultado).']';
    
  }
  
  /**
   * Retorna un objeto para javascript
   *
   * @param Array $a_Param
   * @return StringJson
   * 
   * @example 
   * 
   * array que podria venir
   * $a_Params = array("indice1"=>'valorIndice1', "indice2"=>'valorIndice2');
   * 
   * como se utilizria
   * $salida = utilJson::generateJsonObject($a_Params);
   * 
   * un ejemplo de un posible resultado:
   * $salida = "{'indice1':'valorIndice1', 'indice2':'valorIndice2'}";
   * 
   */
  static function generateJsonObject($a_Param){
    
    
    $a_Resultado     = array();
    
    foreach ($a_Param as $key => $value){
      
      $nameMethod = $key;
      $valueMethod = $value;
      
      $a_Resultado[]  = $nameMethod.':"'.$valueMethod.'"';
      
    }
    
    return "{".implode(",",$a_Resultado).'}';
    
  }
  
}