<?php

require(SF_ROOT_DIR.DIRECTORY_SEPARATOR."config".DIRECTORY_SEPARATOR."sfCore.class.php");

class Parameter {
  
  protected static $instance = null;
  protected $parameter;
  public $module;
  public $actions;
  static protected $Const = array(
  	'MAX_ARRAY_EXIST' => 0,
  	'MAX_ARRAY_SELF'  => 2
  );

  private function __construct(){
    
  }

  public static function getInstance(){
    if (!isset(self::$instance))
    {
      $class = __CLASS__;
      self::$instance = new $class();
      //self::$instance->initialize();
    }
    return self::$instance;
  }
  
  public function getModule(){
    return $this->module;
  }
  
  public function getActions(){
    return $this->actions;
  }
  
  public function TransformPathInfoGlobal(){
    $a_path_info = explode("/", $_SERVER['PATH_INFO']);
    array_shift($a_path_info);
    if(count($a_path_info)>=2){
      $this->module  = array_shift($a_path_info);
      $this->actions = array_shift($a_path_info);
      for ($i=1; $i<=count($a_path_info); $i++){
        if(fmod($i, 2) == 0){
          $this->parameter[$a_path_info[$i-2]] = $a_path_info[$i-1];
        }
      }
    }
  }
  
  public function TransformParameterGlobal(){
    $glGet    = $_GET;
    $glPost   = $_POST;
    if($_SERVER['PATH_INFO']){
      $this->TransformPathInfoGlobal();
    }else{
      if(count($_GET)==0){
        $a_arguments = homepage_default();
        $this->module  = $a_arguments['module'];
        $this->actions = $a_arguments['action'];
      }else{
        $this->module  = key($_GET);
        $this->actions = array_shift($_GET);
      }
    }
    if(count($glGet)>self::$Const['MAX_ARRAY_EXIST']){
      foreach ($glGet as $sKey => $sValue){
        $this->parameter[$sKey] = $sValue;
      }
    }
    if(count($glPost)>self::$Const['MAX_ARRAY_EXIST']){
      foreach ($glPost as $sKey => $sValue){
        $this->parameter[$sKey] = $sValue;
      }
    }
    return $this->parameter;
  }
  
}

abstract class sfUser{
  
  protected $default_namespace = null;
  //protected $parameters = array();
  
  public function __construct($namespace = 'default')
  {
    $this->default_namespace = $namespace;
  }
  
  public function addCredential($credential)
  {
    $this->addCredentials(func_get_args());
  }
  
  public function addCredentials()
  {
    if (func_num_args() == 0) return;

    // Add all credentials
    $credentials = (is_array(func_get_arg(0))) ? func_get_arg(0) : func_get_args();

    foreach ($credentials as $aCredential)
    {
      //if (!in_array($aCredential, $this->credentials)){
        $_SESSION['credentials'][] = $aCredential;
      //}
    }
        
  }
  
  public function clearCredentials(){
    //$this->credentials = null;
    //$this->credentials = array();
    $_SESSION['credentials'] = array();
  }
  
  public function removeNamespace($ns = null){
    
    unset($_SESSION[$ns]);
    
  }
  
  public function setAuthenticated($authenticated){

    if ($authenticated === true){
      //$this->authenticated = true;
      $_SESSION['authenticated'] = true;
    }
    else
    {
      //$this->authenticated = false;
      $_SESSION['authenticated'] = false;
      $this->clearCredentials();
    }
    
  }
  
  public function isAuthenticated(){
    //return $this->authenticated;
    return $_SESSION['authenticated'];
  }
  
  public function getAttribute($name, $default = null, $ns = null){
    
    //return $this->attributeHolder->get($name, $default, $ns);
    return $_SESSION[$ns][$name];
  }
  
  public function setAttribute($name, $value, $ns = null){
    //$_SESSION[$ns][$name] = $value;
    //return $this->attributeHolder->set($name, $value, $ns);
    $_SESSION[$ns][$name] = $value;
  }
  
  public function serialize(){
    return serialize($this->parameters);
  }

  public function unserialize($serialized){
    $this->parameters = unserialize($serialized);
  }
  
}

class ViewResponse {
  
  protected static $instance = null;
  protected $method;
  
  private function __construct(){
    $this->method = 1;
  }
  
  public static function getInstance(){
    if (!isset(self::$instance))
    {
      $class = __CLASS__;
      self::$instance = new $class();
      //self::$instance->initialize();
    }
    return self::$instance;
  }
  
  public function setMethodAjax(){
    $this->method = 0;
  }
  
  public function getMethod(){
    return $this->method;
  }
  
}

class Conexion{
  
  private static $database = array (
                                     'sys' => array('user'=>'diycash22_db', 'host'=>'localhost', 'pass'=>'JfALEeUXGNff', 'db'=>'diycash22_user'),
                                     'mnt' => array('user'=>'diycash22_db', 'host'=>'localhost', 'pass'=>'JfALEeUXGNff', 'db'=>'diycash22_user')
                                   );
  
  static public function getParamDbByAlias($name,  $default="sys"){
    
    $a_tmp = isset(self::$database[$name]) ? self::$database[$name] : self::$database[$default];;
    return $a_tmp;
    
  }
  
  static public function getConexion(){
    $apps = SF_APP;
    
    $a_param = self::getParamDbByAlias($apps);
    
    return mysql_connect($a_param['host'], $a_param['user'], $a_param['pass']);
    
  }
  
  static public function getNameDb(){
    //por este proyecto
    $apps = SF_APP;
    $a_param = self::getParamDbByAlias("sys");
    return $a_param['db'];
  }
  
}

sfCore::initAutoload();