<?php 
ViewResponse::getInstance()->setMethodAjax();

$o_BalanceGeneralBean = new BalanceGeneralBean();

$o_BalanceGeneralBean->setIdSucursal($id);	
$o_BalanceGeneralBean->setFecha($Fecha);
$o_BalanceGeneralBean->setFechaFinal($Fecha);

$o_BalanceGeneralDP = new BalanceGeneralDP($o_BalanceGeneralBean);
$a_o_resumenGeneral = $o_BalanceGeneralDP->select();

//Datos de Balance Diario

$o_BalanceDiaBean = new BalanceDiaBean();

$o_BalanceDiaBean->setIdSucursal($id);	
$o_BalanceDiaBean->setFechaBalance($Fecha);
$o_BalanceDiaBean->setFechaBalanceFinal($Fecha);

$o_BalanceDiaDP = new BalanceDiaDP($o_BalanceDiaBean);
$a_o_resumenDiario = $o_BalanceDiaDP->select();


$pdf = new TCPDF('P', PDF_UNIT,'A4', true); 
$pdf->AliasNbPages();
$pdf->setHeaderFont(array('times','',9));
$pdf->setFooterMargin('20');
$str = 'Reporte::Control diario Detalle de Caja ';
$pdf->setHeaderData('logo_alfa.png','30','Caja Diaria ',$str);

define("POS_IZQ", 5);

$pdf->AddPage();
$pdf->SetY('20');

$pdf->SetFillColor(254,254,254);
$pdf->SetFont('times','',9);

$pdf->Ln('20');
if(is_array($a_o_resumenGeneral)){
	foreach ($a_o_resumenGeneral as $key => $o_resumenHeader) {
  	  $pdf->SetX(POS_IZQ);
  	  $pdf->Cell(40,6,'Sucursal',1,0,'L',1);
      $pdf->Cell(160,6,$o_resumenHeader->getNombreSucursal(),1,1,'L',1);
      $pdf->SetX(POS_IZQ);
      $pdf->Cell(40,6,'Administrador',1,0,'L',1);
      $pdf->Cell(160,6,$o_resumenHeader->getNombreAdministrador(),1,1,'L',1); 
      $pdf->SetX(POS_IZQ);
      $pdf->Cell(40,6,'Fecha',1,0,'L',1);
      $pdf->Cell(160,6,$o_resumenHeader->getFecha(),1,1,'L',1);
      $pdf->SetX(POS_IZQ);
      $pdf->Cell(40,6,'Saldo Disponible',1,0,'L',1);
      $pdf->Cell(160,6,number_format($o_resumenHeader->getTotalAnterior(),2),1,1,'L',1);
      $pdf->SetX(POS_IZQ);     
  }   
  $pdf->SetX(POS_IZQ);
  
  $pdf->Cell(100,6,'SALIDA',1,0,'L',1); 
  $pdf->Cell(100,6,'ENTRADA',1,1,'L',1); 
  
  $pdf->SetX(POS_IZQ);
  $pdf->Cell(75,6,'Representante',1,0,'L',1); 
  $pdf->Cell(25,6,'Caja',1,0,'R',1); 
  $pdf->Cell(75,6,'Representante',1,0,'L',1); 
  $pdf->Cell(25,6,'Efectivo del Dia',1,1,'R',1); 
  
  $pdf->SetX(POS_IZQ);
  
  $x_det = $pdf->GetX(); 
  $y_det = $pdf->GetY(); 
  
  if(is_array($a_o_resumenDiario)){
	reset($a_o_resumenDiario);
	foreach ($a_o_resumenDiario as $key => $o_resumenDiario) {
		$pdf->SetX(POS_IZQ);
		$pdf->Cell(75,6,$o_resumenDiario->getNombreColaborador(),1,0,'L',1); 
		$pdf->Cell(25,6,$o_resumenDiario->getTotalCaja(),1,1,'R',1); 
		$TotalSalidas +=$o_resumenDiario->getTotalCaja();
	}
  }
  $TotalSalidas +=$o_resumenHeader->getTotalAdelantoSueldo(); 
  $TotalSalidas +=$o_resumenHeader->getTotalGastoGeneral();
  $pdf->SetX(POS_IZQ);
  $pdf->Cell(75,6,"Total Adelanto",1,0,'L',1); 
  $pdf->Cell(25,6,number_format($o_resumenHeader->getTotalAdelantoSueldo(),2),1,1,'R',1); 
  $pdf->SetX(POS_IZQ);
  $pdf->Cell(75,6,"Total Gastos",1,0,'L',1); 
  $pdf->Cell(25,6,number_format($o_resumenHeader->getTotalGastoGeneral(),2),1,1,'R',1); 
  
  
  $y_f_det_salida = $pdf->GetY();
  
  $pdf->SetXY($x_det + 100,$y_det);
  
  
  if(is_array($a_o_resumenDiario)){
	reset($a_o_resumenDiario);
	foreach ($a_o_resumenDiario as $key => $o_resumenDiario) {
		$pdf->SetX(POS_IZQ+100);
		$Ingresos = ((float)$o_resumenDiario->getTotalPagos() - (float)$o_resumenDiario->getTotalPrestamos()+(float)$o_resumenDiario->getTotalSobrantes()- (float)$o_resumenDiario->getTotalFaltantes()+ (float)$o_resumenDiario->getTotalGastoAdministrativo());
		$TotalIngresos +=$Ingresos;
		$pdf->Cell(75,6,$o_resumenDiario->getNombreColaborador(),1,0,'L',1); 
		$pdf->Cell(25,6,number_format($Ingresos,2),1,1,'R',1); 
	}
	
	$TotalIngresos +=$o_resumenHeader->getTotalIngreso();
	$pdf->SetX(POS_IZQ+100);
	$pdf->Cell(75,6,"Ingreso Diversos",1,0,'L',1); 
	$pdf->Cell(25,6,number_format($o_resumenHeader->getTotalIngreso(),2),1,1,'R',1); 
	
	$y_f_det_entrada = $pdf->GetY();
	
  }
  
  if($y_f_det_salida > $y_f_det_entrada){
  	$pdf->SetY($y_f_det_salida);
  }else{
  	$pdf->SetY($y_f_det_entrada);
  }
  

  $pdf->SetX(POS_IZQ);
  $pdf->Cell(75,6,"Total Salida",1,0,'L',1); 
  $pdf->Cell(25,6,number_format($TotalSalidas,2),1,0,'R',1); 
  $pdf->Cell(75,6,"Total Entrada",1,0,'L',1); 
  $pdf->Cell(25,6,number_format($TotalIngresos,2),1,1,'R',1); 

  $pdf->SetY($pdf->GetY()+2);
  $pdf->SetX(POS_IZQ);
  $pdf->Cell(250,6,"",0,1,'L',1);
  
  
  $pdf->SetX(POS_IZQ+100);
  $saldoAnterior= $o_resumenHeader->getTotalAnterior();
  $pdf->Cell(75,6,"Saldo Anterior",1,0,'L',1); 
  $pdf->Cell(25,6,number_format($saldoAnterior,2),1,1,'R',1); 
  $pdf->SetX(POS_IZQ+100);
  $pdf->Cell(75,6,"Total Ingresos",1,0,'L',1); 
  $pdf->Cell(25,6,number_format($TotalIngresos,2),1,1,'R',1); 
  $pdf->SetX(POS_IZQ+100);
  $pdf->Cell(75,6,"",1,0,'L',1); 
  $pdf->Cell(25,6,number_format($saldoAnterior + $TotalIngresos,2),1,1,'R',1); 
  $pdf->SetX(POS_IZQ+100);
  $pdf->Cell(75,6,"Total Salida",1,0,'L',1); 
  $pdf->Cell(25,6,number_format($TotalSalidas,2),1,1,'R',1); 
  $pdf->SetX(POS_IZQ+100);
  $pdf->Cell(75,6,"Saldo (".$Fecha.")",1,0,'L',1); 
  $pdf->Cell(25,6,number_format($saldoAnterior + $TotalIngresos - $TotalSalidas,2),1,1,'R',1); 
  
}
$pdf->Output();    				 
?>