<?php

//============================================================+
// File name   : example_005.php
// Begin       : 2008-03-04
// Last Update : 2013-05-14
//
// Description : Example 005 for TCPDF class
//               Multicell
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//============================================================+

/**
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: Multicell
 * @author Nicola Asuni
 * @since 2008-03-04
 */
use_helper('UrlFunctions');
use_helper('UtilFunctionsPlanilla');


// create new PDF document
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Nicola Asuni');
$pdf->SetTitle('TCPDF Example 005');
$pdf->SetSubject('TCPDF Tutorial');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data

$pdf->SetHeaderData("ca_logo.jpg", 50, "Cronograma de Pagos","");

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);


// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, 5);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

$pdf->setPrintFooter(false);
$pdf->setPrintHeader(false);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
    require_once(dirname(__FILE__).'/lang/eng.php');
    $pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('times', '', 8);

// add a page
$pdf->AddPage();

// set color for text
$pdf->SetTextColor(0, 63, 127);

$o_ConceptosFN = new CrPlanillaConceptoPerFN();
$o_ConceptosFN->setPeriodo($periodo);
$o_ConceptosFN->setEstado('A');
$o_ConceptosFN->setUbicacion('OTR');
$a_o_ConceptosFN = $o_ConceptosFN->select(); 
	

//Separar por ubicacion y ordenado por su numero de posicion

if(is_array($a_o_ConceptosFN)){
	foreach ($a_o_ConceptosFN as $key => $o_ConceptosFN){
		$a_Conceptos[$o_ConceptosFN->getIdConcepto()] = $o_ConceptosFN->getCodigo();
		$a_con_otros[$o_ConceptosFN->getPosicionPlanilla()] = $o_ConceptosFN;
	}
}
	 
$o_ConceptosFN = new CrPlanillaConceptoPerFN();
$o_ConceptosFN->setPeriodo($periodo);
$o_ConceptosFN->setEstado('A');
$o_ConceptosFN->setVisualizarPlanilla('1');
$a_o_ConceptosFN = $o_ConceptosFN->select(); 
	

//Separar por ubicacion y ordenado por su numero de posicion

if(is_array($a_o_ConceptosFN)){
	foreach ($a_o_ConceptosFN as $key => $o_ConceptosFN){
		$a_Conceptos[$o_ConceptosFN->getIdConcepto()] = $o_ConceptosFN->getCodigo();
		switch($o_ConceptosFN->getUbicacion()){
			case "ING":
				$a_con_ingresos[$o_ConceptosFN->getPosicionPlanilla()] = $o_ConceptosFN;
				break;
			case "DES":
				$a_con_descuentos[$o_ConceptosFN->getPosicionPlanilla()] = $o_ConceptosFN;	
				break;
			case "APO":
				$a_con_aportes[$o_ConceptosFN->getPosicionPlanilla()] = $o_ConceptosFN;	
				break;
			case "HEA":
				$a_con_header[$o_ConceptosFN->getPosicionPlanilla()] = $o_ConceptosFN;	
				break;
		}
	}
}
ksort($a_con_ingresos);
ksort($a_con_descuentos);
ksort($a_con_aportes);
ksort($a_con_header);


$o_planillaColaborador = new CrPlanillaFN();
if($idColaborador){
	$idColaborador_T = explode("-",$idColaborador);
}

if($idColaborador) $o_planillaColaborador->setIdColaboradores($idColaborador_T);
$a_Colaborador = $o_planillaColaborador->getColaboradores($periodo);
$o_planillaColaborador->setPeriodo($periodo);
$a_o_planillaColaborador = $o_planillaColaborador->select();
foreach ($a_o_planillaColaborador as $key => $o_planillaColaborador){
	$a_planilla_Col_valor[$o_planillaColaborador->getIdColaborador()][$a_Conceptos[$o_planillaColaborador->getIdConcepto()]] = $o_planillaColaborador->getValor();
}


reset($a_Colaborador);
$j=0;
foreach ($a_Colaborador as $key =>$o_Colaborador){
	$html = imprimirPlanilla($periodo,$a_con_ingresos,$a_con_descuentos,$a_con_aportes,$a_con_otros,$a_con_header,$o_Colaborador,$a_planilla_Col_valor);
	$pdf->writeHTML(utf8_encode($html), true, false, false, false, '');
	$pdf->writeHTML(utf8_encode($html), true, false, false, false, '');
	if($j<count($a_Colaborador)-1) $pdf->AddPage();
	$j++;
}

// move pointer to last page
$pdf->lastPage();

// ---------------------------------------------------------

//Close and output PDF document
$pdf->Output('example_005.pdf', 'I');


exit;