<?php
ViewResponse::getInstance()->setMethodAjax();

/*****************************************/
$o_BalanceDiaBean = new BalanceDiaBean();

$o_BalanceDiaBean->setIdSucursal($idSucursal);	
$o_BalanceDiaBean->setFechaBalance($fecha);
$o_BalanceDiaBean->setFechaBalanceFinal($fecha);

$o_BalanceDiaDP = new BalanceDiaDP($o_BalanceDiaBean);
$a_o_resumenDiario = $o_BalanceDiaDP->select();
$a_Header = $o_BalanceDiaDP->selectHeader();
/*****************************************/


$pdf = new TCPDF('P', PDF_UNIT, PDF_PAGE_FORMAT, true); 
//$pdf->AliasNbPages();
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);
define("POS_IZQ", 5);

$pdf->AddPage();

/*iniciop titulo*/
$pdf->SetFont('times','B',13);
$pdf->SetX(POS_IZQ);
$pdf->SetFillColor(201,202,204);
$pdf->Cell(200,4,utf8_encode('Balance del Dia - Detalle'),0,0,'L',1);
$pdf->SetFillColor(254,254,254);
$pdf->SetFont('times','B',6);
/*fin titulo*/
if(is_array($a_Header)){
	foreach ($a_Header as $key => $o_resumenHeader) {
		/*inicio de cabecera*/
		$pdf->SetFont('times','B',7);
		$pdf->SetXY(POS_IZQ,20);
		$pdf->Cell(40,4,'Sucursal',1,0,'L',1);
		$pdf->Cell(100,4,$o_resumenHeader->getNombreSucursal(),1,1,'L',1);
		$pdf->SetX(POS_IZQ);
		$pdf->Cell(40,4,'Administrador',1,0,'L',1);
		$pdf->Cell(100,4,utf8_encode(ucwords(strtolower($o_resumenHeader->getNombreAdministrador()))),1,1,'L',1);
		$pdf->SetX(POS_IZQ);
		$pdf->Cell(40,4,'Fecha',1,0,'L',1);
		$pdf->Cell(100,4,$o_resumenHeader->getFechaBalance(),1,1,'L',1);
		$pdf->SetX(POS_IZQ);
		$pdf->Cell(40,4,'Comentario',1,0,'L',1);
		$pdf->Cell(100,4,$o_resumenHeader->getDescripcion(),1,1,'L',1);
		/*fin de cabecera*/
		$pdf->Ln();
		$pdf->SetX(POS_IZQ);
		$pdf->Cell(60,4,'Nombre',1,0,'L',1);
		$pdf->Cell(15,4,'T.Caja',1,0,'L',1);
		$pdf->Cell(15,4,'T.Prestamos',1,0,'L',1);
		$pdf->Cell(18,4,'T.Pagos',1,0,'L',1);
		$pdf->Cell(18,4,'T.Pagos Mora',1,0,'L',1);
		$pdf->Cell(15,4,'T.Sobrantes',1,0,'L',1);
		$pdf->Cell(15,4,'T.Faltantes',1,0,'L',1);
		$pdf->Cell(15,4,'T.G.Admin',1,0,'L',1);
		$pdf->Cell(15,4,'T.G.Movi',1,0,'L',1);
		$pdf->Cell(18,4,'Total',1,1,'L',1);
      				
		if(is_array($a_o_resumenDiario)){
			foreach ($a_o_resumenDiario as $key => $o_resumenDiario) {
				$pdf->SetX(POS_IZQ);
				$pdf->Cell(60,4,$o_resumenDiario->getNombreColaborador(),1,0,'L',1);
				$pdf->Cell(15,4, number_format(round((float)$o_resumenDiario->getTotalCaja(),2),2),1,0,'R',1);
				$pdf->Cell(15,4,number_format(round((float)$o_resumenDiario->getTotalPrestamos(),2),2),1,0,'R',1);
				$pdf->Cell(18,4,number_format(round($o_resumenDiario->getTotalPagos(),2),2),1,0,'R',1);
				$pdf->Cell(18,4,number_format(round($o_resumenDiario->getTotalPagosMora(),2),2),1,0,'R',1);
				$pdf->Cell(15,4,number_format(round($o_resumenDiario->getTotalSobrantes(),2),2),1,0,'R',1);
				$pdf->Cell(15,4,number_format(round($o_resumenDiario->getTotalFaltantes(),2),2),1,0,'R',1);
				$pdf->Cell(15,4,number_format(round($o_resumenDiario->getTotalGastoAdministrativo(),2),2),1,0,'R',1);
				$pdf->Cell(15,4,number_format(round($o_resumenDiario->getTotalGastoMovilidad(),2),2),1,0,'R',1);
				$pdf->Cell(18,4,number_format(round((round($o_resumenDiario->getTotalCaja(),2) + round($o_resumenDiario->getTotalPagos(),2) - round($o_resumenDiario->getTotalPrestamos(),2) + $o_resumenDiario->getTotalGastoAdministrativo()),2),2),1,1,'R',1);
				$TotalCaja += $o_resumenDiario->getTotalCaja();
				
				$TotalPrestamo += $o_resumenDiario->getTotalPrestamos();
				$TotalPago += $o_resumenDiario->getTotalPagos();
				$TotalPagoMora += $o_resumenDiario->getTotalPagosMora();
				$TotalSobrantes += $o_resumenDiario->getTotalSobrantes();
				$TotalFaltantes += $o_resumenDiario->getTotalFaltantes();
				$TotalGastoAdmin += $o_resumenDiario->getTotalGastoAdministrativo();
				$TotalGastoMovilidad += $o_resumenDiario->getTotalGastoMovilidad();
				$Total += round($o_resumenDiario->getTotalCaja(),2) + round($o_resumenDiario->getTotalPagos(),2)+ round($o_resumenDiario->getTotalPagosMora(),2) +round($o_resumenDiario->getTotalSobrantes(),2)-round($o_resumenDiario->getTotalFaltantes(),2)- round($o_resumenDiario->getTotalPrestamos(),2) + round($o_resumenDiario->getTotalGastoAdministrativo(),2) - round($o_resumenDiario->getTotalGastoMovilidad(),2);		
			}
			$pdf->SetX(POS_IZQ);
			$pdf->Cell(60,4,'Totales',1,0,'R',1);
			$pdf->Cell(15,4,number_format(round($TotalCaja,2),2),1,0,'R',1);
			$pdf->Cell(15,4,number_format(round($TotalPrestamo,2),2),1,0,'R',1);
			$pdf->Cell(18,4,number_format(round($TotalPago,2),2),1,0,'R',1);
			$pdf->Cell(18,4,number_format(round($TotalPagoMora,2),2),1,0,'R',1);
			$pdf->Cell(15,4,number_format(round($TotalSobrantes,2),2),1,0,'R',1);
			$pdf->Cell(15,4,number_format(round($TotalFaltantes,2),2),1,0,'R',1);
			$pdf->Cell(15,4,number_format(round($TotalGastoAdmin,2),2),1,0,'R',1);
			$pdf->Cell(15,4,number_format(round($TotalGastoMovilidad,2),2),1,0,'R',1);
			$pdf->Cell(18,4,number_format(round($Total,2),2),1,1,'R',1);
		}
	}
}
$pos    = 25;
$count  = 0;
$x      = 0;
$pdf->SetFillColor(254,254,254);
$pdf->SetFont('times','',7);


$pdf->Output();

?>