<?php
use_helper('UtilFunctions');
ViewResponse::getInstance()->setMethodAjax();


//COLOCAR CAMPOS DE LA CABECERA DEL LISTADO  

 if($id){
	$o_PrestamoBean = new PrestamoBean();
	$o_PrestamoBean->setIdPrestamo($id);
	$o_class = new PrestamoBL();
	$a_ObjectBean = $o_class->busquedaPrestamo($o_PrestamoBean);
	
	//Listado de Pagos
	$o_pagoBean = new PagoBean();
	$o_pagoBean->setIdPrestamo($id);
	
	$o_PagoBL = new PagoBL();
	$a_pagos = $o_PagoBL->busquedaPago($o_pagoBean);
	
	
}


/*****************************************/



$pdf = new TCPDF('P', PDF_UNIT,'A4', true); 

$pdf->setHeaderFont(array('times','',8));
$pdf->setFooterMargin('20');
$str = 'Estado de Cuenta';
$pdf->setHeaderData('logo_alfa.png','30','Prestamo - Detallado ',$str);

define("POS_IZQ", 5);

$pdf->AddPage();

if(is_array($a_ObjectBean)){
  while(list($key,$o_ObjectBean) = each($a_ObjectBean)){
	  	
	  	$o_ClienteBean = new ClienteBean();
		$o_ClienteBean->setIdCliente($o_ObjectBean->getIdCliente());
		$o_class = new ClienteBL();
		$a_ObjectCliente = $o_class->busquedaCliente($o_ClienteBean);
		
		while(list($keyCli,$o_ObjectBeanCli) = each($a_ObjectCliente)){
			$Nombre = $o_ObjectBeanCli->getNombreCompleto();		
			$o_MercadoBean = new MercadoBean();
			
			$o_MercadoBean->setIdMercado($o_ObjectBeanCli->getIdMercado());
			$o_class = new MercadoBL();
			$ObjectBean = $o_class->busquedaMercado($o_MercadoBean);
			
			$NombreMercado = $ObjectBean[0]->getDescripcion();
			}
		    if($o_ObjectBean->getEstado()=='P'){
		    	$estado=Pendiente;
		    }elseif($o_ObjectBean->getEstado()=='C'){
		    	$estado=Cancelado;
		    }
		    if($o_ObjectBean->getOrigen()=='R'){
		      $origen='Normal';
		    }elseif($o_ObjectBean->getOrigen()=='F'){
		    	$origen='Refinanciado';
		    }
		
			/*inicio de cabecera*/
			$pdf->SetFont('times','B',9);
			$pdf->SetXY(POS_IZQ,10);
			
			/*CABECERA*/
			
			$pdf->SetFillColor(254,254,254);
			$pdf->SetX(POS_IZQ);
			$pdf->Cell(200,4,'Datos del Cliente',1,1,'L',1);
			$pdf->SetXY(POS_IZQ,$pdf->GetY()+1);
			
			$pdf->Cell(25,4,'Nombre',0,0,'L',1);
			$pdf->SetFont('times','',9);
			$pdf->Cell(50,4,utf8_encode(ucwords($Nombre)),0,0,'L',1);
			
			$pdf->SetFont('times','B',9);
			$pdf->Cell(30,4,'Mercado',0,0,'L',1);
			$pdf->SetFont('times','',9);
			$pdf->Cell(50,4,utf8_encode(ucwords($NombreMercado)),0,0,'L',1);
			$pdf->SetFont('times','B',9);
			$pdf->Cell(30,4,'N.Prestamo',0,0,'L',1);
			$pdf->SetFont('times','',9);
			$pdf->Cell(10,4,$id,0,1,'L',1);
			
			
			$pdf->SetFont('times','B',9);
			$pdf->SetXY(POS_IZQ,$pdf->GetY()+1);
			$pdf->Cell(200,4,'Datos del Prestamo',1,1,'L',1);
			$pdf->SetXY(POS_IZQ,$pdf->GetY()+1);
			
			$pdf->SetFont('times','B',9);
			$pdf->Cell(25,4,'Fecha Inicio',0,0,'L',1);
			$pdf->SetFont('times','',9);
			$pdf->Cell(20,4,$o_ObjectBean->getFechaInicio(),0,0,'L',1);
			$pdf->SetFont('times','B',9);
			$pdf->Cell(30,4,'Fecha Vencimiento',0,0,'L',1);
			$pdf->SetFont('times','',9);
			$pdf->Cell(20,4,$o_ObjectBean->getFechaVencimiento(),0,0,'L',1);
			$pdf->SetFont('times','B',9);
			$pdf->Cell(20,4,'Estado',0,0,'L',1);
			$pdf->SetFont('times','',9);
			$pdf->Cell(20,4,$estado,0,0,'L',1);
			$pdf->SetFont('times','B',9);
			$pdf->Cell(25,4,'Tipo Prestamo',0,0,'L',1);
			$pdf->SetFont('times','',9);
			$pdf->Cell(20,4,$origen,0,0,'L',1);
			
			$pdf->Cell(30,4,'',0,0,'L',1);
			$pdf->Cell(50,4,'',0,1,'L',1);
			$pdf->SetXY(POS_IZQ,$pdf->GetY()+1);
			$pdf->SetFont('times','B',9);
			$pdf->Cell(25,4,'Capital',0,0,'L',1);
			$pdf->SetFont('times','',9);
			$pdf->Cell(20,4,'S/.'.number_format($o_ObjectBean->getMontoPrestado(),2),0,0,'L',1);
			$pdf->SetFont('times','B',9);
			$pdf->Cell(30,4,'Monto Total',0,0,'L',1);
			$pdf->SetFont('times','',9);
			$pdf->Cell(20,4,'S/.'.number_format($o_ObjectBean->getMontoTotal(),2),0,0,'L',1);
			$pdf->SetFont('times','B',9);
			$pdf->Cell(20,4,'Interes(%)',0,0,'L',1);
			$pdf->SetFont('times','',9);
			$pdf->Cell(20,4,$o_ObjectBean->getInteresPorcentaje(),0,0,'L',1);
			$pdf->SetFont('times','B',9);
			$pdf->Cell(20,4,'Saldo',0,0,'L',1);
			$pdf->SetFont('times','',9);
			$pdf->Cell(20,4,'S/.'.number_format($o_ObjectBean->getSaldoPrestamo(),2),0,1,'L',1);
			$pdf->SetFont('times','B',9);
			$pdf->Cell(20,4,'G.A.',0,0,'L',1);
			$pdf->SetFont('times','',9);
			$pdf->Cell(20,4,'S/.'.number_format($o_ObjectBean->getGastoAdministrativo(),2),0,0,'L',1);
			
			$pdf->SetFont('times','B',9);
			$pdf->Cell(30,4,'Mora',0,0,'L',1);
			$pdf->SetFont('times','',9);
			$pdf->Cell(20,4,number_format(ultimaMoraPagada($o_ObjectBean->getIdCliente(),$o_ObjectBean->getIdPrestamo()),2),0,1,'L',1);
			
			
			/*fin titulo*/
			$pdf->SetFillColor(254,254,254);
			$pdf->SetFont('times','',9);
			
			$pdf->SetXY(POS_IZQ,$pdf->GetY()+1);
			$pdf->Cell(200,4,'Listado de Pagos',1,1,'L',1);
			$pdf->SetXY(POS_IZQ,$pdf->GetY()+1);
			$pdf->SetFillColor(236,235,236);
			$pdf->SetX(POS_IZQ);
			
			$pdf->Cell(10,4,'Nro',1,0,'L',1);
			$pdf->Cell(40,4,'Fecha',1,0,'L',1);
			$pdf->Cell(30,4,'T.pago',1,0,'L',1);
			$pdf->Cell(30,4,'Monto Pagado (S/.)',1,1,'L',1);
			
			//$pdf->Cell(35,4,'Inicio',0,0,'L',1);
			/*fin de cabecera*/
			
			$pos    = 25;
			$count  = 0;
			$x      = 0;
			$pdf->SetFillColor(254,254,254);
			$pdf->SetFont('times','',9);
			
			$pdf->SetXY(POS_IZQ,$pdf->GetY()+2);
			$i = 1;	
			$sumaTotal= 0;
			if(is_array($a_pagos)){
				foreach ($a_pagos as $key => $o_Pago){
					$pdf->SetX(POS_IZQ);
					
					$pdf->Cell(10,4,$i,0,0,'R');
					$pdf->Cell(40,4,substr($o_Pago->getFechaPago(),0,10),0,0,'C',1);
					
					if($o_Pago->getTipo() == 1){ $text_tp = "Cuota";};
					if($o_Pago->getTipo() == 2){ 
						$pdf->SetTextColor(255,0,0);
						$text_tp = "Mora";
					};
					
					$pdf->Cell(30,4,$text_tp,0,0,'L',1);
					
					$pdf->Cell(30,4,number_format($o_Pago->getMontoPago(),2),0,1,'R',1);
					$pdf->SetTextColor(0,0,0);
					if($o_Pago->getTipo() == 1){
						$sumaTotal +=$o_Pago->getMontoPago();		
					}
					$i++;
				}
				$pdf->SetX(POS_IZQ);
				$pdf->Cell(80,4,'Total',0,0,'R',1);
				$pdf->Cell(30,4,'S/.'.number_format($sumaTotal,2),1,1,'R',1);
			}else{
				$pdf->SetX(POS_IZQ);
				$pdf->Cell(200,4,'No hay pagos',1,1,'L',1);
			}
	}
}

$pdf->Output();

?>